/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HBJMHisRepository {
    public static HBJMHisRepository getInstance() {
        return JobHisQueryRepository.INSTANCE;
    }

    public DynamicObjectCollection getNumAndNameList(List<Long> boidList, Date time, String entityname) {
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter boidQFilter = new QFilter("boid", "in", boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        String selectFields = "boid,id,number,name";
        QFilter qFilter = effdtQFilter.and(bsledQFilter).and(boidQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return QueryServiceHelper.query((String)entityname, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection getJobHis(List<Long> boidList, Date time) {
        String selectFields = "boid,id,number,name,createorg,jobscm.id,jobscm.name,jobscm.number,jobscm.jobgradescm.id,jobscm.jobgradescm.name, jobscm.jobgradescm.number, jobscm.joblevelscm.id, jobscm.joblevelscm.number, jobscm.joblevelscm.name, jobseq.name,jobseq.id,jobfamily.name,jobfamily.id,jobclass.name,jobclass.id, highjobgrade.jobgradescm.id,highjobgrade.jobgradescm.number,highjobgrade.jobgradescm.name, highjoblevel.joblevelscm.id,highjoblevel.joblevelscm.number,highjoblevel.joblevelscm.name, highjobgrade.name,highjobgrade.id,lowjobgrade.name,lowjobgrade.id,highjoblevel.name,highjoblevel.id,lowjoblevel.name,lowjoblevel.id,createorg.name,createorg.number";
        return this.getJobHis(boidList, time, selectFields);
    }

    public DynamicObjectCollection getJobHis(List<Long> boidList, Date time, String selectFields) {
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter boidQFilter = new QFilter("boid", "in", boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = effdtQFilter.and(bsledQFilter).and(boidQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return QueryServiceHelper.query((String)"hbjm_jobhr", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection getJobHisSimpleInfo(List<String> numberList, Date time) {
        QFilter boidQFilter = new QFilter("number", "in", numberList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(effdtQFilter).and(bsledQFilter);
        String selectFields = "boid,id,number,name,enable,firstbsed";
        return QueryServiceHelper.query((String)"hbjm_jobhr", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject[] getJobFirstBsedByNumber(List<String> numberList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter boidQFilter = new QFilter("number", "in", numberList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        String selectFields = "boid,id,firstbsed";
        return helper.queryOriginalArray(selectFields, new QFilter[]{qFilter});
    }

    public DynamicObject[] getJobHisById(List<Long> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter boidQFilter = new QFilter("id", "in", idList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObjectCollection getJobVersionInfo(List<Long> boidList, Date start, Date end) {
        Date start_data = HRDateTimeUtils.truncateDate((Date)start);
        Date end_data = HRDateTimeUtils.truncateDate((Date)end);
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)start_data);
        effdtQFilter.and(new QFilter("bsled", ">=", (Object)start_data));
        QFilter bsledQFilter = new QFilter("bsed", "<=", (Object)end_data);
        bsledQFilter.and(new QFilter("bsled", ">=", (Object)end_data));
        QFilter bsledQFilterMul = new QFilter("bsed", ">=", (Object)start_data);
        bsledQFilterMul.and(new QFilter("bsled", "<=", (Object)end_data));
        QFilter timeFilter = effdtQFilter.or(bsledQFilter).or(bsledQFilterMul);
        QFilter boidQFilter = new QFilter("boid", "in", boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        String selectFields = "boid,id,number,name,bsed,bsled";
        QFilter qFilter = timeFilter.and(boidQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return QueryServiceHelper.query((String)"hbjm_jobhr", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection getHbjmClassInfo(List<Long> boidList, Date time, String entityname) {
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter boidQFilter = new QFilter("boid", "in", boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        String selectFields = "boid,id,number,name,jobfamily,jobfamily.name,parent,parent.name,jobseq,jobseq.name,jobclasslevel";
        QFilter qFilter = effdtQFilter.and(bsledQFilter).and(boidQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return QueryServiceHelper.query((String)entityname, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection getFamilyInfo(List<Long> boidList, Date time, String entityname) {
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter boidQFilter = new QFilter("boid", "in", boidList);
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        String selectFields = "boid,id,number,name,jobseq,jobseq.name";
        QFilter qFilter = effdtQFilter.and(bsledQFilter).and(boidQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return QueryServiceHelper.query((String)entityname, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public List<Map<String, Object>> getGradeInfo(List<Long> idList, Date time, String entityname) {
        DynamicObjectCollection jobdyncol = QueryServiceHelper.query((String)entityname, (String)"jobgradescm,entryboid", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        ArrayList<Map<String, Object>> reslist = new ArrayList<Map<String, Object>>(jobdyncol.size());
        List entryboids = jobdyncol.stream().map(jobdyn -> jobdyn.getLong("entryboid")).collect(Collectors.toList());
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter entryboidQFilter = new QFilter("entryentity.entryboid", "in", entryboids);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = effdtQFilter.and(bsledQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(entryboidQFilter);
        DynamicObjectCollection jobscmdyncollection = QueryServiceHelper.query((String)"hbjm_jobgradescmhr", (String)"entryentity,entryentity.jobgrade_number,entryentity.jobgrade_name, entryentity.entryboid", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)jobscmdyncollection)) {
            return null;
        }
        for (DynamicObject jobscmdyn : jobscmdyncollection) {
            HashMap<String, Object> resmap = new HashMap<String, Object>(3);
            String number = jobscmdyn.getString("entryentity.jobgrade_number");
            String name = jobscmdyn.getString("entryentity.jobgrade_name");
            resmap.put("id", jobscmdyn.getLong("entryentity"));
            resmap.put("boid", jobscmdyn.getLong("entryentity.entryboid"));
            resmap.put("number", number);
            resmap.put("name", name);
            reslist.add(resmap);
        }
        return reslist;
    }

    public List<Map<String, Object>> getLevelInfo(List<Long> idList, Date time, String entityname) {
        DynamicObjectCollection jobdyncol = QueryServiceHelper.query((String)entityname, (String)"joblevelscm,entryboid", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        ArrayList<Map<String, Object>> reslist = new ArrayList<Map<String, Object>>(jobdyncol.size());
        List entryboids = jobdyncol.stream().map(jobdyn -> jobdyn.getLong("entryboid")).collect(Collectors.toList());
        QFilter effdtQFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter bsledQFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)time));
        QFilter entryboidQFilter = new QFilter("entryentity.entryboid", "in", entryboids);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = effdtQFilter.and(bsledQFilter).and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(entryboidQFilter);
        DynamicObjectCollection jobscmdyncollection = QueryServiceHelper.query((String)"hbjm_joblevelscmhr", (String)"entryentity,entryentity.joblevel_number,entryentity.joblevel_name, entryentity.entryboid", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)jobscmdyncollection)) {
            return null;
        }
        jobscmdyncollection.stream().forEach(jobscmdyn -> {
            HashMap<String, Object> resmap = new HashMap<String, Object>(3);
            String number = jobscmdyn.getString("entryentity.joblevel_number");
            String name = jobscmdyn.getString("entryentity.joblevel_name");
            resmap.put("id", jobscmdyn.getLong("entryentity"));
            resmap.put("boid", jobscmdyn.getLong("entryentity.entryboid"));
            resmap.put("number", number);
            resmap.put("name", name);
            reslist.add(resmap);
        });
        return reslist;
    }

    public DynamicObject getJobVersionInfoByVersionId(long versionId) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)versionId)};
        String selectFields = "id,boid,number,name,jobscm,jobseq,jobfamily,jobclass,jobtype,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel,establishmentdate,joborientation,jobstandard,diplomareq,agereq,knowledgereq,jobduty,skillreq,abilityreq,experiencereq,createorg,ctrlstrategy,bsed";
        return eventsumHelper.queryOriginalOne(selectFields, qFilters);
    }

    public DynamicObject[] getJobCurrentVersionByBoid(List<Long> jobBoids) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter boFilter = new QFilter("boid", "in", jobBoids);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        String selectFields = "id,boid,number,name,jobscm,jobseq,jobfamily,jobclass,jobtype,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel,establishmentdate,joborientation,jobstandard,diplomareq,agereq,knowledgereq,jobduty,skillreq,abilityreq,experiencereq,createorg,ctrlstrategy,bsed";
        return eventsumHelper.queryOriginalArray(selectFields, new QFilter[]{boFilter, iscurrentVersionFilter});
    }

    public DynamicObject[] getJobHisByBoId(List<Long> boidList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter boidQFilter = new QFilter("boid", "in", boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    private static class JobHisQueryRepository {
        private static HBJMHisRepository INSTANCE = new HBJMHisRepository();

        private JobHisQueryRepository() {
        }
    }
}

