/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

public class JobClassRepository {
    private static final Log logger = LogFactory.getLog(JobClassRepository.class);

    public static JobClassRepository getInstance() {
        return JobClassInstance.INSTANCE;
    }

    public DynamicObject[] queryJobClassByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hbjm_jobclasshr", (Long)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.query("id,name,number,parent,jobclasslevel,jobfamily,jobseq", new QFilter[]{currentFilter, orgFilter, enableFilter, initStatusFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobClassByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter idsFilter = new QFilter("id", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,name,number,parent,jobclasslevel,jobfamily,jobseq,createorg,enable", new QFilter[]{currentFilter, idsFilter, enableFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobClassByIdsIgnoreEnable(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter idsFilter = new QFilter("id", "in", ids);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,name,number,parent,jobclasslevel,jobfamily,jobseq,createorg,enable", new QFilter[]{currentFilter, idsFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobFamilyByIds(Collection<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter idsFilter = new QFilter("jobfamily", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.queryOriginalArray("jobfamily", new QFilter[]{currentFilter, idsFilter, enableFilter});
    }

    public DynamicObject[] querySubJobClassByIds(Collection<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter idsFilter = new QFilter("parent", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.queryOriginalArray("id, number, name, parent", new QFilter[]{currentFilter, idsFilter, enableFilter});
    }

    public DynamicObject[] queryJobClass(Long userId, Boolean isShowDisable) {
        QFilter enableFilter = new QFilter("1", "=", (Object)1);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        if (!Objects.isNull(this.getClassFilter(userId, isShowDisable))) {
            enableFilter.and(this.getClassFilter(userId, isShowDisable));
        }
        return serviceHelper.queryOriginalArray("id", new QFilter[]{enableFilter});
    }

    public QFilter getClassFilter(Long userId, Boolean isShowDisable) {
        QFilter permFilter = new QFilter("1", "=", (Object)1);
        HasPermOrgResult orgPerm = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"hjm", (String)"hbjm_jobclasshr", (String)"47150e89000000ac");
        if (!Objects.isNull(orgPerm) && !orgPerm.hasAllOrgPerm()) {
            logger.info("JobClassQueryRepository.queryJobClass():do not has all orgPermission");
            List perms = orgPerm.getHasPermOrgs();
            if (Objects.isNull(perms) || perms.isEmpty()) {
                logger.info("JobClassQueryRepository.queryJobClass():orgPermission is empty");
                return null;
            }
            QFilter qFilter = new BaseDataServiceImpl().getBaseDataFilter("hbjm_jobclasshr", perms, true);
            permFilter.or(qFilter);
        }
        return permFilter;
    }

    public DynamicObject[] queryJobFamily(Long userId, Boolean isShowDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyhr");
        QFilter enableFilter = isShowDisable != false ? new QFilter("enable", "!=", (Object)"10") : new QFilter("enable", "=", (Object)"1");
        HasPermOrgResult orgPerm = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"hjm", (String)"hbjm_jobfamilyhr", (String)"47150e89000000ac");
        if (!Objects.isNull(orgPerm) && !orgPerm.hasAllOrgPerm()) {
            logger.info("JobClassQueryRepository.queryJobFam():do not has all orgPermission");
            List perms = orgPerm.getHasPermOrgs();
            if (Objects.isNull(perms) || perms.isEmpty()) {
                logger.info("JobClassQueryRepository.queryJobFam():orgPermission is empty");
                return null;
            }
            QFilter permFilter = new BaseDataServiceImpl().getBaseDataFilter("hbjm_jobfamilyhr", perms, true);
            enableFilter.and(permFilter);
        }
        return serviceHelper.queryOriginalArray("id", new QFilter[]{enableFilter});
    }

    public List<Long> queryJobId(Long seqId, List<Long> filedId, String field, Boolean isShowDisable) {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter filter = new QFilter(field, "in", filedId);
        if (Objects.nonNull(this.getClassFilter(Long.valueOf(RequestContext.get().getUserId()), isShowDisable))) {
            filter.and(this.getClassFilter(Long.valueOf(RequestContext.get().getUserId()), isShowDisable));
        }
        if (HRObjectUtils.isEmpty((Object)(dynamicObjects = serviceHelper.queryOriginalArray("id", new QFilter[]{filter}))) || dynamicObjects.length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject[] getJobClassHisByBoId(Long[] boidList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter boidQFilter = new QFilter("boid", "in", (Object)boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getJobClassHisByFamilyBoId(List<Long> jobFamilyIdList, String selectFields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter boidQFilter = new QFilter("jobfamily.id", "in", jobFamilyIdList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.query(selectFields, new QFilter[]{qFilter});
    }

    private static class JobClassInstance {
        private static JobClassRepository INSTANCE = new JobClassRepository();

        private JobClassInstance() {
        }
    }
}

