/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class JobClassScmRepository {
    public static JobClassScmRepository getInstance() {
        return JobClassScmInstance.INSTANCE;
    }

    public DynamicObject[] queryJobClassScm(Long jobScmId, Long jobSeqId, Long jobFamilyId, Boolean isShowDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobclass.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobclass.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        QFilter seqFilter = new QFilter("jobfamily.jobseq", "=", (Object)jobSeqId);
        QFilter familyFilter = new QFilter("jobfamily", "=", (Object)jobFamilyId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{scmFilter, enableFilter, seqFilter, familyFilter});
    }

    public DynamicObject[] queryJobClassScm(List<Long> jobScmId, List<Long> jobSeqId, List<Long> jobFamilyId, Boolean isShowDisable, String orderCondition) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobclass.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobclass.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmId);
        QFilter seqFilter = new QFilter("jobfamily.jobseq", "in", jobSeqId);
        QFilter familyFilter = new QFilter("jobfamily", "in", jobFamilyId);
        QFilter initstatusFilter = new QFilter("jobclass.initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.queryOriginalArray("jobclass.name,jobscm,jobfamily.jobseq,jobfamily,jobclass,jobclass.enable,jobclass.parent", new QFilter[]{scmFilter, enableFilter, seqFilter, familyFilter, initstatusFilter}, orderCondition);
    }

    public DynamicObject[] queryJobClassScmByScmId(Long jobScmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        return serviceHelper.query("id,name,number,jobfamily,jobclass,createorg,highjobgrade,lowjobgrade,highjoblevel,lowjoblevel", new QFilter[]{scmFilter, enableFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobClassScm(Long jobScmId, List<Long> classIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        QFilter classFilter = new QFilter("jobclass", "in", classIds);
        return serviceHelper.query("id,name,number,jobfamily,jobclass,createorg,highjobgrade,lowjobgrade,highjoblevel,lowjoblevel", new QFilter[]{scmFilter, enableFilter, classFilter}, "number asc,id desc");
    }

    public void saveBatch(DynamicObjectCollection jobClassCollection) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        serviceHelper.save(jobClassCollection);
    }

    public void deleteByScmId(Long scmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)scmId);
        serviceHelper.deleteByFilter(new QFilter[]{scmFilter});
    }

    public void deleteByScmIds(List<Long> scmIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter scmFilter = new QFilter("jobscm", "in", scmIds);
        serviceHelper.deleteByFilter(new QFilter[]{scmFilter});
    }

    public DynamicObject[] queryJobClassLevelGradeInfo(List<Long> jobScmIds, List<Long> jobClassIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        return serviceHelper.query("jobscm,jobclass,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade", new QFilter[]{new QFilter("jobclass.id", "in", jobClassIds), new QFilter("jobscm.id", "in", jobScmIds)});
    }

    public DynamicObject[] getJobClassScmDyobjsByJobScmIdsAndJobClassIds(List<Long> jobScmIds, List<Long> jobClassIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter qFilter = new QFilter("jobscm.id", "in", jobScmIds);
        qFilter.and(new QFilter("jobclass.id", "in", jobClassIds));
        return serviceHelper.query("id,name,number,jobscm,jobfamily,jobclass,createorg,highjobgrade,lowjobgrade,highjoblevel,lowjoblevel", new QFilter[]{qFilter});
    }

    public DynamicObject getJobClassScmdyn(String scmnumber) {
        HRBaseServiceHelper classcmserviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        return classcmserviceHelper.queryOne("jobclass,jobclass.number,jobclass.name,jobfamily", new QFilter("jobscm.number", "=", (Object)scmnumber));
    }

    public DynamicObject[] queryJobClassScmByScmIdsAndFamilyIds(List<Long> jobScmIds, List<Long> classIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmIds);
        QFilter jobclassFilter = new QFilter("jobclass", "in", classIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{scmFilter, jobclassFilter});
    }

    private static class JobClassScmInstance {
        private static JobClassScmRepository INSTANCE = new JobClassScmRepository();

        private JobClassScmInstance() {
        }
    }
}

