/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqRepository;
import kd.hrmp.hbjm.common.util.QFilterHelper;
import org.apache.commons.collections4.CollectionUtils;

public class JobClassTreeQueryRepository {
    public static JobClassTreeQueryRepository getInstance() {
        return JobClassScmQueryInstance.INSTANCE;
    }

    public DynamicObject[] queryJobClass(Long userId, List<Long> orgIds, Boolean isShowDisable, String orderCondition) {
        QFilter enableFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        if (isShowDisable.booleanValue()) {
            enableFilter = new QFilter("enable", "!=", (Object)"10");
        } else {
            enableFilter = new QFilter("enable", "=", (Object)"1");
            enableFilter.and("jobseq.enable", "=", (Object)"1");
            enableFilter.and("jobfamily.enable", "=", (Object)"1");
        }
        if (userId != 0L) {
            QFilter permOrgFilter;
            boolean isRemoveDup = true;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                BaseDataServiceImpl baseDataService = new BaseDataServiceImpl();
                permOrgFilter = baseDataService.getBaseDataFilter("hbjm_jobclasshr", orgIds, isRemoveDup);
            } else {
                DynamicObject[] dynamicObjects = JobClassRepository.getInstance().queryJobClass(userId, isShowDisable);
                if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return null;
                }
                List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                permOrgFilter = new QFilter("id", "in", ids);
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
                enableFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            } else {
                return null;
            }
        }
        return serviceHelper.query("id,name,enable,jobclasslevel,jobfamily,jobseq,parent", new QFilter[]{enableFilter, QFilterHelper.getInitstatusQFilter()}, orderCondition);
    }

    public DynamicObject[] queryJobClass(Long userId, List<Long> orgIds, Boolean isShowDisable, QFilter familyIdQFilter, QFilter scmIdQFilter, String orderCondition) {
        QFilter enableFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        if (isShowDisable.booleanValue()) {
            enableFilter = new QFilter("enable", "!=", (Object)"10");
        } else {
            enableFilter = new QFilter("enable", "=", (Object)"1");
            enableFilter.and("jobseq.enable", "=", (Object)"1");
            enableFilter.and("jobfamily.enable", "=", (Object)"1");
        }
        if (userId != 0L) {
            QFilter permOrgFilter;
            boolean isRemoveDup = true;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                BaseDataServiceImpl baseDataService = new BaseDataServiceImpl();
                permOrgFilter = baseDataService.getBaseDataFilter("hbjm_jobclasshr", orgIds, isRemoveDup);
            } else {
                DynamicObject[] dynamicObjects = JobClassRepository.getInstance().queryJobClass(userId, isShowDisable);
                if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return null;
                }
                List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                permOrgFilter = new QFilter("id", "in", ids);
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
                enableFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            } else {
                return null;
            }
        }
        if (familyIdQFilter != null) {
            enableFilter.and(familyIdQFilter);
        }
        if (scmIdQFilter != null) {
            enableFilter.and(scmIdQFilter);
        }
        return serviceHelper.query("id,name,enable,jobclasslevel,jobfamily,jobseq,parent", new QFilter[]{enableFilter, QFilterHelper.getInitstatusQFilter()}, orderCondition);
    }

    public DynamicObject[] queryJobFamily(Long userId, List<Long> orgIds, Boolean isShowDisable, String orderCondition) {
        QFilter enableFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyhr");
        if (isShowDisable.booleanValue()) {
            enableFilter = new QFilter("enable", "!=", (Object)"10");
        } else {
            enableFilter = new QFilter("enable", "=", (Object)"1");
            enableFilter.and("jobseq.enable", "=", (Object)"1");
        }
        if (userId != 0L) {
            QFilter permOrgFilter;
            boolean isRemoveDup = true;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                BaseDataServiceImpl baseDataService = new BaseDataServiceImpl();
                permOrgFilter = baseDataService.getBaseDataFilter("hbjm_jobfamilyhr", orgIds, isRemoveDup);
            } else {
                DynamicObject[] dynamicObjects = JobClassRepository.getInstance().queryJobFamily(userId, isShowDisable);
                if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return null;
                }
                List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                permOrgFilter = new QFilter("id", "in", ids);
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
                enableFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            } else {
                return null;
            }
        }
        return serviceHelper.query("id,name,enable,jobseq", new QFilter[]{enableFilter, QFilterHelper.getInitstatusQFilter()}, orderCondition);
    }

    public DynamicObject[] queryJobFamily(Long userId, List<Long> orgIds, Boolean isShowDisable, QFilter familyIdQFilter, QFilter scmIdQFilter, String orderCondition) {
        QFilter enableFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyhr");
        if (isShowDisable.booleanValue()) {
            enableFilter = new QFilter("enable", "!=", (Object)"10");
        } else {
            enableFilter = new QFilter("enable", "=", (Object)"1");
            enableFilter.and("jobseq.enable", "=", (Object)"1");
        }
        if (userId != 0L) {
            QFilter permOrgFilter;
            boolean isRemoveDup = true;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                BaseDataServiceImpl baseDataService = new BaseDataServiceImpl();
                permOrgFilter = baseDataService.getBaseDataFilter("hbjm_jobfamilyhr", orgIds, isRemoveDup);
            } else {
                DynamicObject[] dynamicObjects = JobClassRepository.getInstance().queryJobFamily(userId, isShowDisable);
                if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return null;
                }
                List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                permOrgFilter = new QFilter("id", "in", ids);
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
                enableFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            } else {
                return null;
            }
        }
        if (familyIdQFilter != null) {
            enableFilter.and(familyIdQFilter);
        }
        if (scmIdQFilter != null) {
            enableFilter.and(scmIdQFilter);
        }
        return serviceHelper.query("id,name,enable,jobseq", new QFilter[]{enableFilter, QFilterHelper.getInitstatusQFilter()}, orderCondition);
    }

    public DynamicObject[] queryJobSeq(Long userId, List<Long> orgIds, Boolean isShowDisable, String orderCondition) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter enableFilter = isShowDisable != false ? new QFilter("enable", "!=", (Object)"10") : new QFilter("enable", "=", (Object)"1");
        if (userId != 0L) {
            QFilter permOrgFilter;
            boolean isRemoveDup = true;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                BaseDataServiceImpl baseDataService = new BaseDataServiceImpl();
                permOrgFilter = baseDataService.getBaseDataFilter("hbjm_jobseqhr", orgIds, isRemoveDup);
            } else {
                DynamicObject[] dynamicObjects = JobSeqRepository.getInstance().queryJobSeqByPerm(userId, isShowDisable);
                if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return null;
                }
                List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                permOrgFilter = new QFilter("id", "in", ids);
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
                enableFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            } else {
                return null;
            }
        }
        return serviceHelper.queryOriginalArray("id,name,enable", new QFilter[]{enableFilter, QFilterHelper.getInitstatusQFilter()}, orderCondition);
    }

    public DynamicObject[] queryJobSeq(Long userId, List<Long> orgIds, Boolean isShowDisable, QFilter seqIdQFilter, QFilter scmIdQFilter, String orderCondition) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter enableFilter = isShowDisable != false ? new QFilter("enable", "!=", (Object)"10") : new QFilter("enable", "=", (Object)"1");
        if (userId != 0L) {
            QFilter permOrgFilter;
            boolean isRemoveDup = true;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                BaseDataServiceImpl baseDataService = new BaseDataServiceImpl();
                permOrgFilter = baseDataService.getBaseDataFilter("hbjm_jobseqhr", orgIds, isRemoveDup);
            } else {
                DynamicObject[] dynamicObjects = JobSeqRepository.getInstance().queryJobSeqByPerm(userId, isShowDisable);
                if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
                    return null;
                }
                List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                permOrgFilter = new QFilter("id", "in", ids);
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
                enableFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            } else {
                return null;
            }
        }
        if (seqIdQFilter != null) {
            enableFilter.and(seqIdQFilter);
        }
        if (scmIdQFilter != null) {
            enableFilter.and(scmIdQFilter);
        }
        return serviceHelper.queryOriginalArray("id,name,enable", new QFilter[]{enableFilter, QFilterHelper.getInitstatusQFilter()}, orderCondition);
    }

    private static class JobClassScmQueryInstance {
        private static JobClassTreeQueryRepository INSTANCE = new JobClassTreeQueryRepository();

        private JobClassScmQueryInstance() {
        }
    }
}

