/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class JobFamilyScmRepository {
    public static JobFamilyScmRepository getInstance() {
        return JobFamilyScmInstance.INSTANCE;
    }

    public DynamicObject[] queryJobFamilyScmByScmId(Long jobScmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        return serviceHelper.query("id,name,number,jobseq,jobfamily,createorg,jobgradescm,joblevelscm", new QFilter[]{scmFilter, enableFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJObFamilyScmByScmId(List<Long> jobScmId, List<Long> jobSeqId, Boolean isShowDisable, String orderCondition) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobfamily.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobfamily.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmId);
        QFilter seqFilter = new QFilter("jobseq", "in", jobSeqId);
        QFilter initstatusFilter = new QFilter("jobfamily.initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.queryOriginalArray("jobfamily.name,jobseq,jobfamily,jobfamily.enable,jobscm", new QFilter[]{scmFilter, enableFilter, seqFilter, initstatusFilter}, orderCondition);
    }

    public DynamicObject[] queryJobFamilyScm(Long jobScmId, List<Long> familyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        QFilter familyFilter = new QFilter("jobfamily", "in", familyIds);
        return serviceHelper.query("id,name,number,jobseq,jobfamily,createorg,jobgradescm,joblevelscm", new QFilter[]{scmFilter, enableFilter, familyFilter}, "number asc,id desc");
    }

    public void saveBatch(DynamicObjectCollection jobFamilyCollection) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        serviceHelper.save(jobFamilyCollection);
    }

    public void deleteByScmId(Long scmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)scmId);
        serviceHelper.deleteByFilter(new QFilter[]{scmFilter});
    }

    public void deleteByScmIds(List<Long> scmIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter scmFilter = new QFilter("jobscm", "in", scmIds);
        serviceHelper.deleteByFilter(new QFilter[]{scmFilter});
    }

    public DynamicObject[] getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds(List<Long> jobScmIds, List<Long> jobFamilyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter qFilter = new QFilter("jobscm.id", "in", jobScmIds);
        qFilter.and(new QFilter("jobfamily.id", "in", jobFamilyIds));
        return serviceHelper.query("jobfamily, jobscm, jobgradescm, joblevelscm", new QFilter[]{qFilter});
    }

    public DynamicObject getFamilyScmDyn(String scmnumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter enableFilter = new QFilter("jobscm.enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("jobscm.status", "=", (Object)"C");
        QFilter scmnumberFilter = new QFilter("jobscm.number", "=", (Object)scmnumber);
        return serviceHelper.queryOne("jobscm,jobscm.number,jobscm.name,jobseq,jobseq.number,jobseq.name,id,jobfamily.number,jobfamily.name", new QFilter[]{scmnumberFilter, enableFilter, statusFilter});
    }

    public DynamicObject[] queryJobFamilyScmByScmIdsAndFamilyIds(List<Long> jobScmIds, List<Long> familyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmIds);
        QFilter familyFilter = new QFilter("jobfamily", "in", familyIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{scmFilter, familyFilter});
    }

    public DynamicObject[] queryJobFamilyScmFieldByScmIdsAndFamilyIds(List<Long> jobScmIds, List<Long> familyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmIds);
        QFilter familyFilter = new QFilter("jobfamily", "in", familyIds);
        String cols = "jobscm,jobseq,id,jobfamily, jobgradescm, joblevelscm";
        return serviceHelper.query(cols, new QFilter[]{scmFilter, familyFilter});
    }

    private static class JobFamilyScmInstance {
        private static JobFamilyScmRepository INSTANCE = new JobFamilyScmRepository();

        private JobFamilyScmInstance() {
        }
    }
}

