/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbjm.business.utils.QFilterCreatorUtils;

public class JobGradeScmRepository {
    public static JobGradeScmRepository getInstance() {
        return JobGradeScmInstance.INSTANCE;
    }

    public DynamicObject[] queryJobGradeScmByrowIds(List<Long> rowIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter jobGradeFilter = new QFilter("id", "in", rowIds);
        return hrBaseServiceHelper.query("id, boid, entryentity.entryboid, entryentity.jobgrade_number, entryentity.jobgrade_name, entryentity.jobgrade_seq", new QFilter[]{jobGradeFilter});
    }

    public DynamicObject[] getGradeScms(Set<Long> gradescmids) {
        HRBaseServiceHelper scmgradeserviceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter gradeidFilter = new QFilter("id", "in", gradescmids);
        return scmgradeserviceHelper.query("entryentity,entryentity.jobgrade_number,entryentity.jobgrade_name,entryentity.jobgrade_seq", new QFilter[]{gradeidFilter});
    }

    public DynamicObject[] getGradeScmDynsByNumberSet(Set<String> gradeScmNumberSet) {
        HRBaseServiceHelper gradeScmServiceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter gradeNumberFilter = new QFilter("number", "in", gradeScmNumberSet);
        return gradeScmServiceHelper.query("id, number, boid, createorg", new QFilter[]{gradeNumberFilter, QFilterCreatorUtils.createCurrentVersionFilter()});
    }

    public DynamicObject[] getJobGradeById(Set<Long> gradeIds) {
        HRBaseServiceHelper scmgradeserviceHelper = new HRBaseServiceHelper("hbjm_jobgradehr");
        QFilter gradeidFilter = new QFilter("id", "in", gradeIds);
        return scmgradeserviceHelper.loadDynamicObjectArray(new QFilter[]{gradeidFilter});
    }

    public DynamicObject[] getJobGradeScmByBoId(Long[] boidList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter boidQFilter = new QFilter("boid", "in", (Object)boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getJobGradeScmById(Set<Long> idList, QFilter permFilter) {
        HRBaseServiceHelper gradeScmServiceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter idFilter = new QFilter("id", "in", idList);
        return gradeScmServiceHelper.query("id, number, boid", new QFilter[]{idFilter, permFilter});
    }

    public DynamicObject[] getJobGradeScmIdByPermFilter(QFilter permFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatusQFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = enableFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(permFilter);
        return serviceHelper.query("id", new QFilter[]{qFilter});
    }

    private static class JobGradeScmInstance {
        private static JobGradeScmRepository INSTANCE = new JobGradeScmRepository();

        private JobGradeScmInstance() {
        }
    }
}

