/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbjm.business.utils.QFilterCreatorUtils;

public class JobLevelScmRepository {
    public static JobLevelScmRepository getInstance() {
        return JobLevelScmInstance.INSTANCE;
    }

    public DynamicObject[] queryJobLevelScmByrowIds(List<Long> rowIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter joblevelFilter = new QFilter("id", "in", rowIds);
        return hrBaseServiceHelper.query("id, boid, entryentity.entryboid, entryentity.joblevel_number, entryentity.joblevel_name, entryentity.joblevel_seq", new QFilter[]{joblevelFilter});
    }

    public DynamicObject[] getLevelScms(Set<Long> levelscmids) {
        HRBaseServiceHelper scmlevelserviceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter levelidFilter = new QFilter("id", "in", levelscmids);
        return scmlevelserviceHelper.query("entryentity,entryentity.joblevel_number,entryentity.joblevel_name,entryentity.joblevel_seq", new QFilter[]{levelidFilter});
    }

    public DynamicObject[] getJobLevelById(Set<Long> levelIds) {
        HRBaseServiceHelper scmgradeserviceHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        QFilter gradeidFilter = new QFilter("id", "in", levelIds);
        return scmgradeserviceHelper.loadDynamicObjectArray(new QFilter[]{gradeidFilter});
    }

    public DynamicObject[] getLevelScmDynsByNumberSet(Set<String> levelScmNumberSet) {
        HRBaseServiceHelper levelScmServiceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter levelNumberFilter = new QFilter("number", "in", levelScmNumberSet);
        return levelScmServiceHelper.query("id, number, boid, createorg", new QFilter[]{levelNumberFilter, QFilterCreatorUtils.createCurrentVersionFilter()});
    }

    public DynamicObject[] getJobLevelScmByBoId(Long[] boidList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter boidQFilter = new QFilter("boid", "in", (Object)boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getJobLevelScmById(Set<Long> idList, QFilter permFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter idFilter = new QFilter("id", "in", idList);
        return serviceHelper.query("id, number, boid", new QFilter[]{idFilter, permFilter});
    }

    public DynamicObject[] getJobLevelScmIdByPermFilter(QFilter permFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatusQFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = enableFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(permFilter);
        return serviceHelper.query("id", new QFilter[]{qFilter});
    }

    private static class JobLevelScmInstance {
        private static JobLevelScmRepository INSTANCE = new JobLevelScmRepository();

        private JobLevelScmInstance() {
        }
    }
}

