/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hbjm.common.util.HashMapUtil;
import kd.hrmp.hbjm.common.util.QFilterHelper;

public class JobRepository {
    public static JobRepository getInstance() {
        return JobRepositoryInstance.INSTANCE;
    }

    public DynamicObject findById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return serviceHelper.queryOne((Object)id);
    }

    public DynamicObject[] queryByJobClassIds(Collection<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idsFilter = new QFilter("jobclass", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.queryOriginalArray("jobclass", new QFilter[]{currentFilter, idsFilter, enableFilter});
    }

    public DynamicObject[] queryByJobSeqIds(Collection<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyhr");
        QFilter idsFilter = new QFilter("jobseq", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.queryOriginalArray("jobseq,jobseq.number", new QFilter[]{currentFilter, idsFilter, enableFilter});
    }

    public DynamicObject[] queryByJobScmIds(Collection<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idsFilter = new QFilter("jobscm", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,name,number,jobscm", new QFilter[]{currentFilter, idsFilter, enableFilter});
    }

    public DynamicObject[] findFurtherEffectJob() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return serviceHelper.query(new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("enable", "=", (Object)"10"), new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)new Date()))});
    }

    public DynamicObject[] findJobChangeHis(Long boid) {
        return BusinessDataServiceHelper.load((String)"hbjm_jobhr", (String)"id,name,bsed,changedesc,creator", (QFilter[])new QFilter[]{new QFilter("boid", "=", (Object)boid), new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2", "-2"})}, (String)"bsed desc,createtime desc");
    }

    public DynamicObject[] findJobsChangeHis(Set<Long> boids) {
        return BusinessDataServiceHelper.load((String)"hbjm_jobhr", (String)"id,name,bsed,creator,modifier,boid,createtime,modifytime", (QFilter[])new QFilter[]{new QFilter("boid", "in", boids), new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2", "-2"})}, (String)"boid asc,bsed desc,modifytime desc");
    }

    public long findLastChangeHisID(Long boid) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"hbjm_jobhr", (String)"id", (QFilter[])new QFilter[]{new QFilter("boid", "=", (Object)boid), new QFilter("iscurrentversion", "=", (Object)"0")}, (String)"bsed desc", (int)1);
        if (collection.size() > 0) {
            return ((DynamicObject)collection.get(0)).getLong("id");
        }
        return 0L;
    }

    public Date getBlsedByBsed(Date bsed, long boid) {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        for (DynamicObject b : dynamicObjects = serviceHelper.queryOriginalArray("bsed", new QFilter[]{new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"}), new QFilter("boid", "=", (Object)boid)}, "bsed asc")) {
            Date date = b.getDate("bsed");
            if (!bsed.before(date)) continue;
            return HRDateTimeUtils.addDay((Date)date, (long)-1L);
        }
        return null;
    }

    public Map<Long, DynamicObject> getChangeBeforeHisJob(Map<Long, Date> bomap, List<Long> newHisIdList) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(HashMapUtil.getInitCapacity((int)bomap.size()));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,boid,bsed", new QFilter[]{new QFilter("boid", "in", bomap.keySet()), new QFilter("id", "not in", newHisIdList), new QFilter("iscurrentversion", "=", (Object)"0")}, "boid desc,bsed desc,id desc");
        HashSet set = Sets.newHashSetWithExpectedSize((int)newHisIdList.size());
        for (DynamicObject his : dynamicObjects) {
            long boid = his.getLong("boid");
            if (set.contains(boid)) continue;
            Date jobbsed = bomap.get(boid);
            Date date = his.getDate("bsed");
            if (date.after(jobbsed)) continue;
            result.put(boid, his);
            set.add(boid);
        }
        return result;
    }

    public DynamicObject[] getDisableHis(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        QFilter currentversionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, currentversionFilter, datastatusFilter, enableFilter, initStatusFilter});
    }

    public DynamicObject[] getEnableHis(Set<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        QFilter currentversionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        DynamicObject[] aa = serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, currentversionFilter, datastatusFilter, enableFilter, initStatusFilter});
        return aa;
    }

    public DynamicObject[] loadJobData(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] loadJobDataByBoid(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, QFilterHelper.getInitstatusQFilter()});
    }

    public DynamicObject[] loadCurrentJobDataByBoid(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        idFilter.and(new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"}));
        QFilter enableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        idFilter.and(enableFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, QFilterHelper.getInitstatusQFilter()});
    }

    public DynamicObject[] loadCurrentJobFieldDataByBoid(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        idFilter.and(new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"}));
        QFilter enableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        idFilter.and(enableFilter);
        String cols = "id,number,name,status,enable,createorg,useorg,ctrlstrategy,initstatus,boid,iscurrentversion,datastatus,bsed,jobscm,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade,jobseq,jobfamily,jobclass";
        return serviceHelper.query(cols, new QFilter[]{idFilter});
    }

    public DynamicObject[] loadHisJobFieldDataByBoId(List<Long> ids, Date searchDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        idFilter.and(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()}));
        idFilter.and(new QFilter("bsed", "<=", (Object)searchDate));
        idFilter.and(new QFilter("bsled", ">=", (Object)searchDate));
        idFilter.and(new QFilter("status", "=", (Object)"C"));
        idFilter.and(new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"}));
        QFilter enableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        idFilter.and(enableFilter);
        String cols = "id,number,name,status,enable,createorg,useorg,ctrlstrategy,initstatus,boid,iscurrentversion,datastatus,bsed,jobscm,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade,jobseq,jobfamily,jobclass";
        return serviceHelper.query(cols, new QFilter[]{idFilter});
    }

    public DynamicObject[] loadFieldDataById(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("id", "in", ids);
        String cols = "id,number,name,status,enable,createorg,useorg,ctrlstrategy,initstatus,boid,iscurrentversion,datastatus,bsed,jobscm,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade,jobseq,jobfamily,jobclass";
        return serviceHelper.query(cols, new QFilter[]{idFilter});
    }

    public DynamicObject[] loadUnEnablingJobDataByBoid(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", ids);
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"10");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, enableFilter, QFilterHelper.getInitstatusQFilter()});
    }

    public DynamicObject[] loadBaseData(List<Object> ids, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.loadDynamicObjectArray(entityName, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] queryJobLevelGradeInfo(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return serviceHelper.query("id,jobscm,jobclass,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade", new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] queryJobLevelGrade(List<Long> jobboidlist) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("id", "in", jobboidlist);
        return serviceHelper.query("id,lowjoblevel,lowjobgrade,highjoblevel,highjobgrade,lowjoblevel.joblevelseq,lowjobgrade.jobgradeseq,highjoblevel.joblevelseq,highjobgrade.jobgradeseq,highjoblevel.joblevelscm,highjobgrade.jobgradescm", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryDataByBoids(List<Long> boids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter idFilter = new QFilter("boid", "in", boids);
        return serviceHelper.query("id,boid", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryOriginalArray(QFilter qFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return serviceHelper.queryOriginalArray("id, boid, enable, name, number", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryJobHisInfos(Collection<Long> jobIdList, Date earliestDate, Date latestDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter[] hisVersionQFilter = this.jobHisVersionQFilter(jobIdList, earliestDate, latestDate);
        String field = "id, boid, eanble, createorg, name, number, bsed, bsled";
        return serviceHelper.query(field, hisVersionQFilter);
    }

    private QFilter[] jobHisVersionQFilter(Collection<Long> jobIdList, Date earliestDate, Date latestDate) {
        QFilter boIdFilter = new QFilter("boid", "in", jobIdList);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter qFilter = boIdFilter.and(dataStatusFilter).and(isCurrentVersionFilter).and(initStatusFilter);
        if (earliestDate != null && latestDate != null) {
            QFilter earliestDateFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)earliestDate));
            QFilter latestDateFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)latestDate));
            earliestDateFilter.and(latestDateFilter);
            qFilter.and(earliestDateFilter);
        }
        return new QFilter[]{qFilter};
    }

    public DynamicObject[] loadDynamicArrayByFilters(QFilter[] filterArray) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return serviceHelper.loadDynamicObjectArray(filterArray);
    }

    public DynamicObject[] getJobIdByPermFilter(QFilter permFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatusQFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = enableFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(permFilter);
        DynamicObject[] jobs = serviceHelper.query("id", new QFilter[]{qFilter});
        List boids = Arrays.stream(jobs).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter hisDatastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter enableFilterNew = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilterNew = new QFilter("initstatus", "=", (Object)"2");
        QFilter boIdQFilter = new QFilter("boid", "in", boids);
        return serviceHelper.query("id", new QFilter[]{boIdQFilter.and(hisDatastatusQFilter).and(initStatusFilterNew).and(enableFilterNew)});
    }

    private static class JobRepositoryInstance {
        private static JobRepository INSTANCE = new JobRepository();

        private JobRepositoryInstance() {
        }
    }
}

