/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import com.alibaba.fastjson.JSONArray;
import java.util.List;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbjm.common.util.PermOrgQFilterUtil;

public class JobScmRepository {
    private static final Log logger = LogFactory.getLog(JobScmRepository.class);

    public static JobScmRepository getInstance() {
        return JobScmInstance.INSTANCE;
    }

    public DynamicObject[] queryJobScm(Long userId, List<Long> orgId, Boolean isShowDisable, String orderCondition) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter enableFilter = isShowDisable != false ? new QFilter("enable", "!=", (Object)"10") : new QFilter("enable", "=", (Object)"1");
        if (userId != 0L) {
            List newOrgId = JSONArray.parseArray((String)orgId.toString(), Long.class);
            QFilter permOrgFilter = PermOrgQFilterUtil.assembleFilterByOr((String)"hbjm_jobscmhr", (List)newOrgId);
            if (permOrgFilter == null) {
                permOrgFilter = PermOrgQFilterUtil.getPermOrgs((Long)userId, (String)"hjm", (String)"hbjm_jobscmhr");
            }
            if (permOrgFilter != null) {
                enableFilter.and(permOrgFilter);
            } else {
                logger.info("JobScmRepository#JobScm'perm is null");
            }
        }
        return serviceHelper.queryOriginalArray("id,name,enable", new QFilter[]{enableFilter}, orderCondition);
    }

    public DynamicObject queryBaseInfoById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        return serviceHelper.loadDynamicObject(filters);
    }

    public DynamicObject[] queryJobScmByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        return serviceHelper.loadDynamicObjectArray(filters);
    }

    public DynamicObject queryBaseInfoByNumber(String Number2) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)Number2)};
        return serviceHelper.queryOne(filters);
    }

    public DynamicObject queryBaseInfoByNumberAndPerm(String Number2, QFilter permQfilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)Number2), permQfilter};
        return serviceHelper.queryOne(filters);
    }

    public DynamicObject queryBaseInfoByNumberAndOrg(String Number2, Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter numberFilter = new QFilter("number", "=", (Object)Number2);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        return serviceHelper.queryOne(new QFilter[]{numberFilter, orgFilter});
    }

    public DynamicObject queryBaseInfoByName(String Name) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)Name)};
        return serviceHelper.queryOne(filters);
    }

    public DynamicObject queryBaseInfoByNameAndOrg(String Name, Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter nameFilter = new QFilter("name", "=", (Object)Name);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        return serviceHelper.queryOne(new QFilter[]{nameFilter, orgFilter});
    }

    public void saveBaseInfo(DynamicObject jobScmDy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        serviceHelper.saveOne(jobScmDy);
        BaseDataCtrlCache.clearBaseDataUseRange((String)"hbjm_jobscmhr", (Long)jobScmDy.getLong("org.id"));
    }

    public void updateBaseInfo(DynamicObject jobScmDy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        serviceHelper.updateDataOne(jobScmDy);
        BaseDataCtrlCache.clearBaseDataUseRange((String)"hbjm_jobscmhr", (Long)jobScmDy.getLong("org.id"));
    }

    private static class JobScmInstance {
        private static JobScmRepository INSTANCE = new JobScmRepository();

        private JobScmInstance() {
        }
    }
}

