/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.List;
import java.util.Objects;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class JobSeqRepository {
    public static JobSeqRepository getInstance() {
        return JobSeqInstance.INSTANCE;
    }

    public DynamicObject[] queryJobSeqByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hbjm_jobseqhr", (Long)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.query("id,name,number", new QFilter[]{orgFilter, enableFilter, currentFilter, initStatusFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobSeqByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter idsFilter = new QFilter("id", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,name,number,createorg,standardjobseq,enable", new QFilter[]{currentFilter, enableFilter, idsFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobSeqByIdsIgnoreEnable(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter idsFilter = new QFilter("id", "in", ids);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,name,number,createorg,standardjobseq,enable", new QFilter[]{currentFilter, idsFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJobSeqByPerm(Long userId, Boolean isShowDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter enableFilter = isShowDisable != false ? new QFilter("enable", "!=", (Object)"10") : new QFilter("enable", "=", (Object)"1");
        HasPermOrgResult orgPerm = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"hjm", (String)"hbjm_jobseqhr", (String)"47150e89000000ac");
        if (!Objects.isNull(orgPerm) && !orgPerm.hasAllOrgPerm()) {
            List perms = orgPerm.getHasPermOrgs();
            if (Objects.isNull(perms) || perms.isEmpty()) {
                return null;
            }
            QFilter permFilter = new BaseDataServiceImpl().getBaseDataFilter("hbjm_jobseqhr", perms, true);
            enableFilter.and(permFilter);
        }
        return serviceHelper.queryOriginalArray("id", new QFilter[]{enableFilter});
    }

    public DynamicObject[] getJobSeqHisByBoId(Long[] boidList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqhr");
        QFilter boidQFilter = new QFilter("boid", "in", (Object)boidList);
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidQFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    private static class JobSeqInstance {
        private static JobSeqRepository INSTANCE = new JobSeqRepository();

        private JobSeqInstance() {
        }
    }
}

