/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.repository;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class JobSeqScmRepository {
    private static final Log logger = LogFactory.getLog(JobSeqScmRepository.class);

    public static JobSeqScmRepository getInstance() {
        return JobSeqScmInstance.INSTANCE;
    }

    public DynamicObject[] queryJobSeqScmByScmId(Long jobScmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        return serviceHelper.query("id,name,number,jobseq,createorg", new QFilter[]{scmFilter, enableFilter}, "number asc,id desc");
    }

    public DynamicObject[] queryJObSeqScmByScmId(List<Long> jobScmId, Boolean isShowDisable, String orderCondition) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobseq.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobseq.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmId);
        QFilter initstatusFilter = new QFilter("jobseq.initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.queryOriginalArray("jobseq.name,jobseq,jobseq.enable,jobscm", new QFilter[]{scmFilter, enableFilter, initstatusFilter}, orderCondition);
    }

    public void saveBatch(DynamicObjectCollection jobSeqCollection) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        serviceHelper.save(jobSeqCollection);
    }

    public void deleteByScmId(Long scmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)scmId);
        serviceHelper.deleteByFilter(new QFilter[]{scmFilter});
    }

    public void deleteByScmIds(List<Long> scmIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        QFilter scmFilter = new QFilter("jobscm", "in", scmIds);
        serviceHelper.deleteByFilter(new QFilter[]{scmFilter});
    }

    public static DynamicObject[] getJobSeqByScmId(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        QFilter idFilter = new QFilter("jobscm", "in", (Object)id);
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        DynamicObject[] infoObject = serviceHelper.queryOriginalArray("jobseq.id", idFilterArray);
        return infoObject;
    }

    public static DynamicObject[] getJobFamilyByScmId(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter idFilter = new QFilter("jobscm", "in", (Object)id);
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        DynamicObject[] infoObject = serviceHelper.queryOriginalArray("jobfamily.id", idFilterArray);
        return infoObject;
    }

    public static DynamicObject[] getJobClassByScmId(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter idFilter = new QFilter("jobscm", "in", (Object)id);
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        DynamicObject[] infoObject = serviceHelper.queryOriginalArray("jobclass.id", idFilterArray);
        return infoObject;
    }

    private static class JobSeqScmInstance {
        private static JobSeqScmRepository INSTANCE = new JobSeqScmRepository();

        private JobSeqScmInstance() {
        }
    }
}

