/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.HBJMEventRepository;
import kd.hrmp.hbjm.business.domain.service.ChangeEventService;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeMsgServiceImpl;
import kd.hrmp.hbjm.common.constants.ChangeEventConstants;
import kd.hrmp.hbjm.common.util.MultiLangEqualsUtil;

public class ChangeEventServiceImpl
implements ChangeEventService {
    private Date now = new Date();
    private long creatorId = RequestContext.get().getCurrUserId();
    private Map<String, IDataEntityProperty> allFields = Maps.newHashMapWithExpectedSize((int)100);
    private String sourceType = "";
    private Map<Long, Long> afterVidToBillIdMap;

    @Override
    public void handleChangeEvent(String sourceType, DynamicObject[] beforeData, DynamicObject[] afterData, Map<Long, Long> afterVidToBillIdMap) {
        if (!this.checkParams(sourceType, afterData)) {
            return;
        }
        this.sourceType = sourceType;
        this.afterVidToBillIdMap = afterVidToBillIdMap;
        if (HRStringUtils.equals((String)sourceType, (String)"10")) {
            this.initAllfieldsExcludeEntry((String)ChangeEventConstants.sourceTypeEntity.get(sourceType));
        }
        Map<Object, Object> beforeMap = beforeData == null ? Maps.newHashMapWithExpectedSize((int)8) : Arrays.stream(beforeData).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), dynamicObject -> dynamicObject, (v1, v2) -> v1));
        long[] eventIds = DB.genGlobalLongIds((int)afterData.length);
        int index = 0;
        ArrayList eventList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList eventDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList opDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList sendData = Lists.newArrayListWithExpectedSize((int)afterData.length);
        for (DynamicObject after : afterData) {
            if (HRStringUtils.equals((String)after.getString("enable"), (String)"10")) continue;
            long eventId = eventIds[index];
            ++index;
            long boid = after.getLong("boid");
            DynamicObject before = (DynamicObject)beforeMap.get(boid);
            List<Long> subsceneIdList = this.handleChangeSubscene(after, before);
            DynamicObject event = this.handleEventSum(after, eventId, subsceneIdList);
            eventList.add(event);
            DynamicObject eventDetail = this.handleEventDetal(after, eventId, subsceneIdList);
            eventDetailList.add(eventDetail);
            DynamicObject operDetail = this.handleOperDetail(after, before, eventId, sourceType);
            opDetailList.add(operDetail);
            if (!HRStringUtils.equals((String)sourceType, (String)"10") || !HRStringUtils.equals((String)after.getString("initstatus"), (String)"2") || HRStringUtils.equals((String)after.getString("enable"), (String)"10") || !HRStringUtils.equals((String)after.getString("status"), (String)"C")) continue;
            sendData.add(after);
        }
        HBJMEventRepository.getInstance().saveBatch("hbjm_changetransum", eventList);
        HBJMEventRepository.getInstance().saveBatch("hbjm_changetrandetail", eventDetailList);
        HBJMEventRepository.getInstance().saveBatch("hbjm_changeoperdetail", opDetailList);
        ChangeMsgServiceImpl msg = new ChangeMsgServiceImpl();
        msg.handleChangeMsg(eventList, sendData);
    }

    private boolean checkParams(String sourceType, DynamicObject[] afterData) {
        if (!ChangeEventConstants.sourceTypeEntity.containsKey(sourceType)) {
            return false;
        }
        return afterData != null && afterData.length != 0;
    }

    private void initAllfieldsExcludeEntry(String entityPage) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityPage);
        Map entityTypeMap = entityType.getAllEntities();
        entityTypeMap.forEach((field, fieldType) -> {
            if (fieldType instanceof BillEntityType) {
                this.allFields.putAll(((EntityType)entityTypeMap.get(field)).getFields());
            }
        });
    }

    private DynamicObject handleEventSum(DynamicObject after, long eventId, List<Long> subsceneIdList) {
        DynamicObject event = this.newEmptyDynamicObject("hbjm_changetransum");
        long id = ChangeEventServiceImpl.createId("hbjm_changetransum");
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("sourcetype", (Object)this.sourceType);
        event.set("targetjob", (Object)after.getLong("boid"));
        event.set("changetype", (Object)after.getString("changetype"));
        event.set("changescene", (Object)after.getString("changescene"));
        event.set("changereason", (Object)after.getLong("changedesc.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        if (this.afterVidToBillIdMap != null) {
            event.set("billid", (Object)this.afterVidToBillIdMap.get(after.getLong("id")));
        }
        this.setSubsceneDynCol(event, subsceneIdList);
        return event;
    }

    private DynamicObject handleEventDetal(DynamicObject after, Long eventId, List<Long> subsceneIdList) {
        DynamicObject event = this.newEmptyDynamicObject("hbjm_changetrandetail");
        long id = ChangeEventServiceImpl.createId("hbjm_changetrandetail");
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("sourcetype", (Object)this.sourceType);
        event.set("targetjob", (Object)after.getLong("boid"));
        event.set("changetype", (Object)after.getString("changetype"));
        event.set("changescene", (Object)after.getString("changescene"));
        event.set("changereason", (Object)after.getString("changedesc.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        this.setSubsceneDynCol(event, subsceneIdList);
        return event;
    }

    private DynamicObject handleOperDetail(DynamicObject after, DynamicObject before, Long eventId, String sourceType) {
        DynamicObject operDetail = this.newEmptyDynamicObject("hbjm_changeoperdetail");
        long id = ChangeEventServiceImpl.createId("hbjm_changeoperdetail");
        operDetail.set("id", (Object)id);
        operDetail.set("creator", (Object)this.creatorId);
        operDetail.set("createtime", (Object)this.now);
        operDetail.set("event", (Object)eventId);
        operDetail.set("sourcetype", (Object)sourceType);
        operDetail.set("job", (Object)after.getLong("boid"));
        operDetail.set("changeoperate", (Object)after.getLong("changeoperate"));
        operDetail.set("changedate", (Object)after.getDate("bsed"));
        operDetail.set("beforejob", (Object)(before == null || after.getLong("changeoperate") == 1010L ? 0L : before.getLong("id")));
        operDetail.set("afterjob", (Object)after.getLong("id"));
        return operDetail;
    }

    private List<Long> handleChangeSubscene(DynamicObject after, DynamicObject before) {
        ArrayList subsceneList = Lists.newArrayListWithExpectedSize((int)8);
        long operation = after.getLong("changeoperate");
        if (1010L == operation) {
            subsceneList.add(1010L);
        } else if (1030L == operation) {
            subsceneList.add(1070L);
        } else if (1020L == operation && HRStringUtils.equals((String)"10", (String)this.sourceType)) {
            Iterator iterator = ChangeEventConstants.SUBSCENE_COMPARE_FILED.keySet().iterator();
            while (iterator.hasNext()) {
                long subscene = (Long)iterator.next();
                if (!this.compareFieldsValueChange(after, before, subscene)) continue;
                subsceneList.add(subscene);
            }
        }
        if (subsceneList.size() == 0) {
            subsceneList.add(1020L);
        }
        return subsceneList;
    }

    private boolean compareFieldsValueChange(DynamicObject after, DynamicObject before, long subscene) {
        if (before == null) {
            return true;
        }
        Set needCompareFields = (Set)ChangeEventConstants.SUBSCENE_COMPARE_FILED.get(subscene);
        for (String fieldKey : needCompareFields) {
            IDataEntityProperty field = this.allFields.get(fieldKey);
            if (field instanceof MuliLangTextProp) {
                OrmLocaleValue oldValue;
                OrmLocaleValue currentValue = (OrmLocaleValue)after.get(field.getName());
                if (MultiLangEqualsUtil.compare((OrmLocaleValue)currentValue, (OrmLocaleValue)(oldValue = (OrmLocaleValue)before.get(field.getName())), (boolean)false)) continue;
                return true;
            }
            if (field instanceof MulBasedataProp) {
                DynamicObjectCollection afterMulBasedata = after.getDynamicObjectCollection(field.getName());
                DynamicObjectCollection beforeMulBasedata = before.getDynamicObjectCollection(field.getName());
                if (afterMulBasedata.size() != beforeMulBasedata.size()) {
                    return true;
                }
                ArrayList afterMulBaseDataIds = Lists.newArrayListWithExpectedSize((int)afterMulBasedata.size());
                ArrayList beforeMulBaseDataIds = Lists.newArrayListWithExpectedSize((int)afterMulBasedata.size());
                for (int index = 0; index < afterMulBasedata.size(); ++index) {
                    afterMulBaseDataIds.add(((DynamicObject)afterMulBasedata.get(index)).getString("fbasedataid_id"));
                    beforeMulBaseDataIds.add(((DynamicObject)beforeMulBasedata.get(index)).getString("fbasedataid_id"));
                }
                afterMulBaseDataIds.removeAll(beforeMulBaseDataIds);
                if (afterMulBaseDataIds.size() <= 0) continue;
                return true;
            }
            if (!(field instanceof DateProp ? !HRDateTimeUtils.format((Date)after.getDate(field.getName())).equals(HRDateTimeUtils.format((Date)before.getDate(field.getName()))) : (field instanceof BasedataProp ? !HRStringUtils.equals((String)after.getString(field.getName() + ".id"), (String)before.getString(field.getName() + ".id")) : !HRStringUtils.equals((String)after.getString(field.getName()), (String)before.getString(field.getName()))))) continue;
            return true;
        }
        return false;
    }

    private void setSubsceneDynCol(DynamicObject dyn, List<Long> subsceneIds) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = dyn.getDynamicObjectCollection("changesubscene").getDynamicObjectType();
        for (Long subsceneId : subsceneIds) {
            DynamicObject subcene = new DynamicObject(dynamicObjectType);
            subcene.set("fbasedataid", (Object)subsceneId);
            collection.add((Object)subcene);
        }
        if (collection.size() > 0) {
            dyn.set("changesubscene", (Object)collection);
        }
    }

    private static long createId(String pageValue) {
        return ORM.create().genLongId(pageValue);
    }

    private DynamicObject newEmptyDynamicObject(String pageValue) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageValue);
        return new DynamicObject((DynamicObjectType)dataEntityType);
    }

    @Override
    public void delEvent(List<Long> jobIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("hbjm_changetransum");
        DynamicObject[] eventsums = eventsumHelper.queryOriginalArray("id,event", new QFilter[]{new QFilter("targetjob", "in", jobIds)});
        Set<Long> eventIds = Arrays.stream(eventsums).map(eventsum -> eventsum.getLong("event")).collect(Collectors.toSet());
        HBJMEventRepository.getInstance().delEventSum(eventIds);
        HBJMEventRepository.getInstance().delEventDetail(eventIds);
        HBJMEventRepository.getInstance().delOpDetail(eventIds);
    }
}

