/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hrmp.hbjm.business.domain.repository.HBJMMsgRepository;
import kd.hrmp.hbjm.business.domain.service.ChangeMsgService;
import kd.hrmp.hbjm.business.task.PublishTask;
import kd.hrmp.hbjm.business.utils.JobUtils;

public class ChangeMsgServiceImpl
implements ChangeMsgService {
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"HBJMChangeMsgServiceThreadpool", (int)1, (int)4);
    private static ThreadLocal<List<DynamicObject>> msgDynThreadLocal = new ThreadLocal();

    @Override
    public void handleChangeMsg(List<DynamicObject> eventList, List<DynamicObject> jobs) {
        List<DynamicObject> msgList = this.saveChangeMsg(eventList, jobs);
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        msgDynThreadLocal.set(msgList);
    }

    private List<DynamicObject> saveChangeMsg(List<DynamicObject> eventList, List<DynamicObject> jobs) {
        if (jobs == null || jobs.size() == 0 || eventList == null || eventList.size() == 0) {
            return null;
        }
        Map<Long, DynamicObject> jobToEventMap = eventList.stream().collect(Collectors.toMap(event -> event.getLong("targetjob"), event -> event));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbjm_changemsg");
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)jobs.size());
        for (DynamicObject job : jobs) {
            long changetype = job.getLong("changetype");
            if (changetype != 1010L && changetype != 1020L && changetype != 1030L) continue;
            DynamicObject msg = new DynamicObject((DynamicObjectType)dataEntityType);
            DynamicObject event2 = jobToEventMap.get(job.getLong("boid"));
            this.setMsgValue(msg, job, event2);
            msgList.add(msg);
        }
        JobUtils.callOp("save", msgList.toArray(new DynamicObject[msgList.size()]));
        return msgList;
    }

    @Override
    public void sendMsg() {
        DynamicObject[] msgs;
        List<DynamicObject> msgList = msgDynThreadLocal.get();
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        List<Long> ids = msgList.stream().map(msg -> msg.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> idToJobMap = msgList.stream().collect(Collectors.toMap(msg -> msg.getLong("id"), msg -> msg.getDynamicObject("job")));
        for (DynamicObject dyn : msgs = HBJMMsgRepository.getInstance().queryRetryMsgsById(ids)) {
            DynamicObject job = idToJobMap.get(dyn.getLong("id"));
            if (job == null) continue;
            dyn.set("job", (Object)job);
        }
        threadPool.execute((Runnable)new PublishTask(Arrays.asList(msgs)));
        msgDynThreadLocal.remove();
    }

    @Override
    public void retrySend(DynamicObject[] needRetrysendMsgs) {
        PublishTask publishTask = new PublishTask();
        publishTask.publish(Arrays.asList(needRetrysendMsgs), true);
    }

    @Override
    public void delByJobBoids(List<Long> josDataIds) {
        HBJMMsgRepository.getInstance().delByJobIds(josDataIds);
    }

    private void setMsgValue(DynamicObject msg, DynamicObject job, DynamicObject event) {
        msg.set("number", (Object)event.getString("event"));
        msg.set("createorg", (Object)job.getDynamicObject("createorg"));
        msg.set("org", (Object)job.getDynamicObject("org"));
        msg.set("useorg", (Object)job.getDynamicObject("useorg"));
        msg.set("ctrlstrategy", (Object)job.getString("ctrlstrategy"));
        msg.set("changedesc", (Object)job.getString("changedesc2"));
        msg.set("effetdate", (Object)event.getDate("changedate"));
        msg.set("changetype", (Object)event.getString("changetype"));
        msg.set("changescene", (Object)event.getString("changescene"));
        msg.set("changesubscene", (Object)event.getDynamicObjectCollection("changesubscene"));
        long changeoperate = job.getLong("changeoperate");
        msg.set("changeoperate", (Object)changeoperate);
        msg.set("changereason", (Object)event.getString("changereason"));
        msg.set("changeuser", (Object)job.getString("modifier_id"));
        msg.set("changetime", (Object)event.getDate("createtime"));
        msg.set("job", (Object)job);
        msg.set("sendstate", (Object)"0");
        msg.set("status", (Object)Character.valueOf('C'));
        msg.set("enable", (Object)"1");
        this.setMsgPublishInfo(changeoperate, job, msg);
    }

    private void setMsgPublishInfo(long changeoperate, DynamicObject job, DynamicObject msg) {
        String desc;
        String tag;
        String title;
        if (changeoperate == 1010L) {
            title = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u804c\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_0", (String)"hrmp-hbjm-business", (Object[])new Object[0]), job.getString("number"), job.getString("name"));
            tag = ResManager.loadKDString((String)"\u804c\u4f4d\u65b0\u589e", (String)"ChangeEventServiceImpl_3", (String)"hrmp-hbjm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u804c\u4f4d\u65b0\u589e\u901a\u77e5", (String)"ChangeEventServiceImpl_6", (String)"hrmp-hbjm-business", (Object[])new Object[0]);
        } else if (changeoperate == 1020L) {
            title = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u804c\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c \u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_1", (String)"hrmp-hbjm-business", (Object[])new Object[0]), job.getString("number"), job.getString("name"));
            tag = ResManager.loadKDString((String)"\u804c\u4f4d\u53d8\u66f4", (String)"ChangeEventServiceImpl_4", (String)"hrmp-hbjm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u804c\u4f4d\u53d8\u66f4\u901a\u77e5", (String)"ChangeEventServiceImpl_7", (String)"hrmp-hbjm-business", (Object[])new Object[0]);
        } else if (changeoperate == 1030L) {
            title = String.format(ResManager.loadKDString((String)"\u7981\u7528\u804c\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c \u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_2", (String)"hrmp-hbjm-business", (Object[])new Object[0]), job.getString("number"), job.getString("name"));
            tag = ResManager.loadKDString((String)"\u804c\u4f4d\u7981\u7528", (String)"ChangeEventServiceImpl_5", (String)"hrmp-hbjm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u804c\u4f4d\u7981\u7528\u901a\u77e5", (String)"ChangeEventServiceImpl_8", (String)"hrmp-hbjm-business", (Object[])new Object[0]);
        } else {
            title = "";
            tag = "";
            desc = "";
        }
        msg.set("msgtag", (Object)tag);
        msg.set("msgtitle", (Object)(title.length() > 50 ? title.substring(0, 50) : title));
        msg.set("msgdesc", (Object)desc);
    }
}

