/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.service.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.service.IBaseValidatorService;

public class JobAbstractBaseValidatorService
implements IBaseValidatorService {
    private static Log LOG = LogFactory.getLog(JobAbstractBaseValidatorService.class);

    public static JobAbstractBaseValidatorService getInstance() {
        return JobAbstractBaseValidatorRepository.INSTANCE;
    }

    @Override
    public <T> void enableValide(ExtendedDataEntity[] datas, String col, Consumer<T> consumer) {
        if (ObjectUtils.isEmpty((Object[])datas) || ObjectUtils.isEmpty((Object)col)) {
            return;
        }
        this.checkBasedataColAccess(datas[0].getDataEntity(), col);
        Arrays.stream(datas).forEach(data -> {
            String enable;
            DynamicObject dynamicObject = data.getDataEntity().getDynamicObject(col);
            if (!ObjectUtils.isEmpty((Object)dynamicObject) && !"1".equals(enable = String.valueOf(dynamicObject.get("enable")))) {
                consumer.accept(data);
            }
        });
    }

    @Override
    public <T> void changeAllowAccessValde(ExtendedDataEntity[] newDatas, DynamicObject[] sourceDatas, String col, Consumer<T> consumer) {
        if (ObjectUtils.isEmpty((Object[])newDatas) || ObjectUtils.isEmpty((Object[])sourceDatas) || ObjectUtils.isEmpty((Object)col)) {
            return;
        }
        IDataEntityType newType = this.checkBasedataColAccess(newDatas[0].getDataEntity(), col);
        IDataEntityType sourceType = this.checkBasedataColAccess(sourceDatas[0], col);
        if (!newType.getName().equals(sourceType.getName())) {
            LOG.error(String.format("connt compare diffrent type of DynamicObject :% %", newType, sourceType));
            throw new RuntimeException("connt compare diffrent type of DynamicObject");
        }
        String primaryKey = newType.getPrimaryKey().getName();
        Map<Object, ExtendedDataEntity> newMap = Arrays.stream(newDatas).collect(Collectors.toMap(dy -> dy.getValue(primaryKey), dy -> dy));
        Map<Object, DynamicObject> sourceMap = Arrays.stream(sourceDatas).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        for (Map.Entry<Object, ExtendedDataEntity> entry : newMap.entrySet()) {
            Object key = entry.getKey();
            DynamicObject srouceDy = sourceMap.get(key);
            if (ObjectUtils.isEmpty((Object)srouceDy) || !this.compareDynamicCol(entry.getValue().getDataEntity(), srouceDy, newType, col)) continue;
            consumer.accept((Object)entry.getValue());
        }
    }

    @Override
    public void availabilityValide(ExtendedDataEntity[] datas) {
        LOG.error("JobAbstractBaseValidator availabilityValide need be override");
        throw new RuntimeException("JobAbstractBaseValidator availabilityValide need be override");
    }

    protected IDataEntityType checkBasedataColAccess(DynamicObject dynamicObject, String col) {
        IDataEntityType type;
        DataEntityPropertyCollection cols;
        if (!ObjectUtils.isEmpty((Object)dynamicObject) && !ObjectUtils.isEmpty((Object)col) && !ObjectUtils.isEmpty((Object)(cols = (type = dynamicObject.getDataEntityType()).getProperties())) && cols.stream().anyMatch(info -> col.equals(info.getName()))) {
            return type;
        }
        LOG.error(String.format("JobAbstractBaseValidator checkBasedataColAccess DynamicObject donnot contains this col or col is not BasedataProp :% %", dynamicObject, col));
        throw new RuntimeException("DynamicObject donnot contains this col or col is not BasedataProp ");
    }

    protected IDataEntityProperty getProp(IDataEntityType type, String col) {
        if (!ObjectUtils.isEmpty((Object)type) && !ObjectUtils.isEmpty((Object)col)) {
            DataEntityPropertyCollection props = type.getProperties();
            for (IDataEntityProperty prop : props) {
                if (!col.equals(prop.getName())) continue;
                return prop;
            }
        }
        LOG.error(String.format("JobAbstractBaseValidator getProp IDataEntityType donnot contains this col:% %", type, col));
        throw new RuntimeException("IDataEntityType donnot contains this col");
    }

    public boolean compareDynamicCol(DynamicObject dynamicObject, DynamicObject sourceDynamic, IDataEntityType type, String col) {
        IDataEntityProperty prop = this.getProp(type, col);
        if (prop instanceof MuliLangTextProp) {
            return !this.compareMulLangTextCol(dynamicObject.getLocaleString(col), sourceDynamic.getLocaleString(col));
        }
        if (prop instanceof BasedataProp) {
            return !this.compareBaseDataCol(dynamicObject.getDynamicObject(col), sourceDynamic.getDynamicObject(col));
        }
        if (prop instanceof DynamicObjectCollection) {
            return !this.compareDynaCollectCol(dynamicObject.getDynamicObjectCollection(col), sourceDynamic.getDynamicObjectCollection(col));
        }
        return !this.compareCommonCol(dynamicObject.get(col), sourceDynamic.get(col));
    }

    protected boolean compareMulLangTextCol(ILocaleString val, ILocaleString sourceVal) {
        if (ObjectUtils.isEmpty((Object)val) && ObjectUtils.isEmpty((Object)sourceVal)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)val) || ObjectUtils.isEmpty((Object)sourceVal)) {
            return false;
        }
        for (Map.Entry entry : val.entrySet()) {
            String key = (String)entry.getKey();
            String sourceSubVal = (String)sourceVal.get((Object)key);
            if (((String)entry.getValue()).equals(sourceSubVal)) continue;
            return false;
        }
        return true;
    }

    protected boolean compareBaseDataCol(DynamicObject dynamicObject, DynamicObject sourceDynamic) {
        if (ObjectUtils.isEmpty((Object)dynamicObject) && ObjectUtils.isEmpty((Object)sourceDynamic)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)sourceDynamic)) {
            return false;
        }
        return HRStringUtils.equals((String)String.valueOf(dynamicObject.getPkValue()), (String)String.valueOf(sourceDynamic.getPkValue()));
    }

    protected boolean compareDynaCollectCol(DynamicObjectCollection datas, DynamicObjectCollection sourceDatas) {
        if (ObjectUtils.isEmpty((Object)datas) && ObjectUtils.isEmpty((Object)sourceDatas)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)datas) || ObjectUtils.isEmpty((Object)sourceDatas)) {
            return false;
        }
        Map<Object, DynamicObject> dataMap = datas.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        Map<Object, DynamicObject> sourceMap = sourceDatas.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        if (dataMap.size() != sourceMap.size()) {
            return false;
        }
        for (Map.Entry<Object, DynamicObject> entry : dataMap.entrySet()) {
            DynamicObject srouceDy = sourceMap.get(entry.getKey());
            if (!ObjectUtils.isEmpty((Object)srouceDy)) continue;
            return false;
        }
        return true;
    }

    protected boolean compareCommonCol(Object data, Object sourceData) {
        if (ObjectUtils.isEmpty((Object)data) && ObjectUtils.isEmpty((Object)sourceData)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)data) || ObjectUtils.isEmpty((Object)sourceData)) {
            return false;
        }
        return HRStringUtils.equals((String)String.valueOf(data), (String)String.valueOf(sourceData));
    }

    private static class JobAbstractBaseValidatorRepository {
        private static JobAbstractBaseValidatorService INSTANCE = new JobAbstractBaseValidatorService();

        private JobAbstractBaseValidatorRepository() {
        }
    }
}

