/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.service.impl;

import java.util.ArrayList;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.hr.hbp.business.log.ModifyDirtyManager;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqScmRepository;
import kd.hrmp.hbjm.business.domain.service.JobScmService;

public class JobScmServiceImpl
implements JobScmService {
    @Override
    public boolean saveAll(DynamicObject jobScmBaseInfo, DynamicObjectCollection jobSeqScmCollection, DynamicObjectCollection jobFamilyScmCollection, DynamicObjectCollection jobClassScmCollection) {
        boolean result = false;
        ModifyDirtyManager modifyDirtyManager = new ModifyDirtyManager();
        DynamicObject[] dys = new DynamicObject[]{jobScmBaseInfo};
        try (TXHandle txHandle = TX.required();){
            try {
                modifyDirtyManager.init(dys[0].getDynamicObjectType(), dys, "save");
                JobScmRepository.getInstance().saveBaseInfo(jobScmBaseInfo);
                JobSeqScmRepository.getInstance().saveBatch(jobSeqScmCollection);
                JobFamilyScmRepository.getInstance().saveBatch(jobFamilyScmCollection);
                JobClassScmRepository.getInstance().saveBatch(jobClassScmCollection);
                result = true;
            }
            catch (Exception ex) {
                txHandle.markRollback();
                boolean bl = false;
                if (txHandle != null) {
                    if (var9_9 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        if (result) {
            modifyDirtyManager.batchInsertLog(dys);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(jobScmBaseInfo.getLong("org_id"));
        new BaseDataServiceImpl().refreshBaseDataUseRange("hbjm_jobscmhr", ids);
        return result;
    }

    @Override
    public boolean updateAll(DynamicObject jobScmBaseInfo, DynamicObjectCollection jobSeqScmCollection, DynamicObjectCollection jobFamilyScmCollection, DynamicObjectCollection jobClassScmCollection) {
        boolean result = false;
        ModifyDirtyManager modifyDirtyManager = new ModifyDirtyManager();
        DynamicObject[] dys = new DynamicObject[]{jobScmBaseInfo};
        try (TXHandle txHandle = TX.required();){
            try {
                modifyDirtyManager.init(dys[0].getDynamicObjectType(), dys, "save");
                JobScmRepository.getInstance().updateBaseInfo(jobScmBaseInfo);
                JobClassScmRepository.getInstance().deleteByScmId(jobScmBaseInfo.getLong("id"));
                JobFamilyScmRepository.getInstance().deleteByScmId(jobScmBaseInfo.getLong("id"));
                JobSeqScmRepository.getInstance().deleteByScmId(jobScmBaseInfo.getLong("id"));
                JobSeqScmRepository.getInstance().saveBatch(jobSeqScmCollection);
                JobFamilyScmRepository.getInstance().saveBatch(jobFamilyScmCollection);
                JobClassScmRepository.getInstance().saveBatch(jobClassScmCollection);
                result = true;
            }
            catch (Exception ex) {
                txHandle.markRollback();
                boolean bl = false;
                if (txHandle != null) {
                    if (var9_9 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        if (result) {
            modifyDirtyManager.batchInsertLog(dys);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(jobScmBaseInfo.getLong("org_id"));
        new BaseDataServiceImpl().refreshBaseDataUseRange("hbjm_jobscmhr", ids);
        return result;
    }
}

