/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.init;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeEventServiceImpl;
import kd.hrmp.hbjm.business.init.HisBaseDataComsumerService;

public class JobInitComsumerService
extends HisBaseDataComsumerService {
    private static Log LOG = LogFactory.getLog(JobInitComsumerService.class);

    @Override
    protected void dealDynData(List<DynamicObject> dyns, List<Map<String, Object>> datamaps) {
        super.dealDynData(dyns, datamaps);
        LOG.info("JobInitComsumerService dealDynData start", dyns);
        if (!ObjectUtils.isEmpty(dyns) && !ObjectUtils.isEmpty(datamaps)) {
            for (DynamicObject dyna : dyns) {
                DynamicObject jobFamily;
                DynamicObject jobSeq = dyna.getDynamicObject("jobseq");
                if (!ObjectUtils.isEmpty((Object)jobSeq) || ObjectUtils.isEmpty((Object)(jobFamily = dyna.getDynamicObject("jobfamily")))) continue;
                dyna.set("jobseq", jobFamily.get("jobseq"));
            }
        }
        LOG.info("JobInitComsumerService dealDynData end");
    }

    public void rollback() {
        String entityCode = this.getInitInParam().getEntityNumber();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityCode);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.queryOriginalArray("id,boid", new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "in", (Object)new String[]{"0", "1"})});
        List idList = Stream.of(dynamicObjects).map(it -> it.getLong("id")).collect(Collectors.toList());
        hrBaseServiceHelper.delete(idList.toArray());
        List<Long> boidList = Stream.of(dynamicObjects).map(it -> it.getLong("boid")).collect(Collectors.toList());
        ChangeEventServiceImpl service = new ChangeEventServiceImpl();
        service.delEvent(boidList);
        this.getInitOutParam().getHandleIdSet().addAll(idList);
    }
}

