/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.jobclass;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;

public class JobClassTreeService {
    public static QFilter builJobClassQFilter(String nodeId) {
        Long userId = RequestContext.get().getCurrUserId();
        if (null != nodeId && !HRStringUtils.isEmpty((String)nodeId)) {
            QFilter qFilter;
            String nodeLayer = nodeId.substring(0, 1);
            Long seqId = 0L;
            String[] split = nodeId.split("#");
            String lastNodeId = split[split.length - 1];
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(lastNodeId.substring(1)));
            switch (nodeLayer) {
                case "0": {
                    qFilter = JobClassRepository.getInstance().getClassFilter(userId, Boolean.FALSE);
                    break;
                }
                case "1": {
                    qFilter = JobClassTreeService.buildJobFilter(seqId, ids, "id", "jobseq.id");
                    break;
                }
                case "2": {
                    qFilter = JobClassTreeService.buildJobFilter(seqId, ids, "id", "jobfamily.id");
                    break;
                }
                default: {
                    String strId = nodeId.substring(1, nodeId.length());
                    qFilter = new QFilter("parent", "=", (Object)Long.parseLong(strId));
                    qFilter.or(new QFilter("id", "=", (Object)Long.parseLong(strId)));
                    qFilter.and(JobClassRepository.getInstance().getClassFilter(userId, Boolean.FALSE));
                }
            }
            return qFilter;
        }
        return null;
    }

    private static QFilter buildJobFilter(Long seqId, List<Long> ids, String filterCondition, String field) {
        List<Long> longs = JobClassRepository.getInstance().queryJobId(seqId, ids, field, Boolean.FALSE);
        return new QFilter(filterCondition, "in", longs);
    }
}

