/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hrmp.hbjm.business.domain.repository.HBJMMsgRepository;
import kd.hrmp.hbjm.common.constants.PublishConstants;
import kd.hrmp.hbjm.common.util.HBJMUtil;

public class PublishTask
extends AbstractTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(PublishTask.class);
    private List<DynamicObject> msgList;
    private Map<Long, List<Map<String, String>>> actionConsumerMap = Maps.newHashMapWithExpectedSize((int)8);

    public PublishTask() {
    }

    public PublishTask(List<DynamicObject> msgList) {
        this.msgList = msgList;
    }

    @Override
    public void run() {
        this.publish(this.msgList, false);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] msgList = HBJMMsgRepository.getInstance().querySyncData();
        this.syncRecStatus(msgList);
        DynamicObject[] sendstateSyncList = HBJMMsgRepository.getInstance().querySendstateSyncData();
        this.syncSendstate(sendstateSyncList);
    }

    private void syncRecStatus(DynamicObject[] msgList) {
        if (msgList == null) {
            return;
        }
        Map<String, Map<String, Object>> msgNoToDataMapMap = this.getMsgCenterData(msgList);
        for (DynamicObject msg : msgList) {
            Map<String, Object> dataMap;
            String msgNo = msg.getString("number");
            DynamicObjectCollection entry = msg.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entry) || (dataMap = msgNoToDataMapMap.get(msgNo)) == null) continue;
            List subList = (List)dataMap.get("dataList");
            for (Map sub : subList) {
                long subscribeBD = (Long)sub.get("subscribeBD");
                String recStatus = (String)sub.get("recStatus");
                for (DynamicObject entryDyn : entry) {
                    long entrySubscribebd = entryDyn.getLong("subscribebd.id");
                    if (entrySubscribebd != subscribeBD) continue;
                    entryDyn.set("recstatus", (Object)recStatus);
                }
            }
        }
        HBJMMsgRepository.getInstance().saveBatch(Arrays.asList(msgList));
    }

    private Map<String, Map<String, Object>> getMsgCenterData(DynamicObject[] msgList) {
        if (msgList == null || msgList.length == 0) {
            return new HashMap<String, Map<String, Object>>();
        }
        ArrayList paramsList = Lists.newArrayListWithExpectedSize((int)msgList.length);
        for (DynamicObject msg : msgList) {
            String msgNo = msg.getString("number");
            long actionId = this.getMsgActionId(msg);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("msgNumber", msgNo);
            paramMap.put("actionId", actionId);
            paramsList.add(paramMap);
        }
        if (paramsList.size() == 0) {
            return new HashMap<String, Map<String, Object>>();
        }
        List<Map<String, Object>> dataList = this.getSubRecStatus(paramsList);
        return dataList.stream().collect(Collectors.toMap(o -> o.get("msgNumber").toString(), o -> o, (o1, o2) -> o2));
    }

    private void syncSendstate(DynamicObject[] msgList) {
        Map<String, Map<String, Object>> msgNoToDataMapMap = this.getMsgCenterData(msgList);
        for (DynamicObject msg : msgList) {
            String msgNo = msg.getString("number");
            Map<String, Object> dataMap = msgNoToDataMapMap.get(msgNo);
            if (dataMap == null) continue;
            msg.set("sendstate", (Object)"1");
        }
        HBJMMsgRepository.getInstance().saveBatch(Arrays.asList(msgList));
    }

    public void publish(List<DynamicObject> msgList, boolean retry) {
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        Date now = new Date();
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(msgList.size());
        for (DynamicObject msg : msgList) {
            if (retry) {
                msg.set("retrytimes", (Object)(msg.getInt("retrytimes") + 1));
            }
            int step = 0;
            long actionId = this.getMsgActionId(msg);
            try {
                Map<String, Object> actionInfo = this.getPublishInfoMap(msg, now);
                List<Map<String, String>> subInfoList = this.getSubinfo(actionId);
                ++step;
                HRProducerServiceHelper.publishAction(actionInfo);
                this.setConsumerEntry(msg, subInfoList);
                msg.set("sendstate", (Object)"1");
            }
            catch (KDBizException ex) {
                if (step > 0 && this.isSendSuccess(msg.getString("number"), actionId)) {
                    msg.set("sendstate", (Object)"1");
                }
                String errorMsg = ex.getMessage();
                msg.set("sendstate", (Object)"2");
                logger.error(errorMsg);
                logger.error("pubmsg-error");
            }
            msg.set("lastsendtime", (Object)now);
            saveList.add(msg);
        }
        HBJMMsgRepository.getInstance().saveBatch(saveList);
    }

    private List<Map<String, String>> getSubinfo(long actionId) {
        List subInfoList = this.actionConsumerMap.get(actionId);
        if (subInfoList == null) {
            Map<String, Object> pubAndSubInfo = this.getSimplePubAndSubInfo((String)PublishConstants.msgPubNoMap.get(actionId));
            subInfoList = (List)pubAndSubInfo.get("subInfoList");
            if (subInfoList == null) {
                subInfoList = Lists.newArrayListWithExpectedSize((int)8);
            }
            this.actionConsumerMap.put(actionId, subInfoList);
            return subInfoList;
        }
        return subInfoList;
    }

    private void setConsumerEntry(DynamicObject msg, List<Map<String, String>> subInfoList) {
        if (CollectionUtils.isEmpty(subInfoList)) {
            return;
        }
        DynamicObjectCollection consumerEntry = msg.getDynamicObjectCollection("entryentity");
        for (Map<String, String> consumer : subInfoList) {
            DynamicObjectType entryType = consumerEntry.getDynamicObjectType();
            DynamicObject row = new DynamicObject(entryType);
            row.set("consumercloud", (Object)consumer.get("consumerCloudId"));
            row.set("consumerapp", (Object)consumer.get("consumerAppId"));
            row.set("subscribebd", (Object)consumer.get("businessTypeId"));
            row.set("recstatus", (Object)"C");
            consumerEntry.add((Object)row);
        }
    }

    private Map<String, Object> getSimplePubAndSubInfo(String msgPubNo) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getSimplePubAndSubInfo", (Object[])new Object[]{msgPubNo});
    }

    private List<Map<String, Object>> getSubRecStatus(List<Map<String, Object>> paramsList) {
        List list = Lists.partition(paramsList, (int)500);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)paramsList.size());
        for (List paramsSubList : list) {
            try {
                result.addAll((Collection)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getMsgCenterListInfo", (Object[])new Object[]{paramsSubList}));
            }
            catch (Exception ex) {
                return Lists.newArrayListWithExpectedSize((int)8);
            }
        }
        return result;
    }

    private boolean isSendSuccess(String msgNumber, long actionId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("number", "=", (Object)msgNumber));
        filters.add(new QFilter("action", "=", (Object)actionId));
        return (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"validateMsgIsDuplicate", (Object[])new Object[]{filters.toArray(new QFilter[0])});
    }

    private Map<String, Object> getPublishInfoMap(DynamicObject msg, Date now) {
        String msgNumber = msg.getString("number");
        long actionId = this.getMsgActionId(msg);
        String msgTitle = msg.getString("msgtitle");
        String msgTag = msg.getString("msgtag");
        String msgDesc = msg.getString("msgdesc");
        HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)16);
        actionInfo.put("msgNumber", msgNumber);
        actionInfo.put("actionId", actionId);
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", now);
        actionInfo.put("msgPubNo", PublishConstants.msgPubNoMap.get(actionId));
        actionInfo.put("msgTitle", msgTitle);
        actionInfo.put("params", SerializationUtils.serializeToBase64(this.getParams(msg)));
        actionInfo.put("msgDesc", msgDesc);
        actionInfo.put("msgTag", msgTag);
        return actionInfo;
    }

    private long getMsgActionId(DynamicObject msg) {
        return (Long)PublishConstants.operateActionMap.get(HBJMUtil.getBasedataPkId((DynamicObject)msg, (String)"changeoperate"));
    }

    private Map<String, Object> getParams(DynamicObject msg) {
        long changeoperate = HBJMUtil.getBasedataPkId((DynamicObject)msg, (String)"changeoperate");
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        params.put("number", msg.getString("job.number"));
        params.put("name", msg.getString("job.name"));
        params.put("id", msg.getLong("job.id"));
        params.put("changeoperate", changeoperate);
        params.put("changedate", msg.getDate("effetdate"));
        params.put("boid", msg.getDynamicObject("job").getLong("boid"));
        params.put("eventId", msg.getString("number"));
        if (changeoperate == 1020L) {
            DynamicObjectCollection changesubsceneCol = msg.getDynamicObjectCollection("changesubscene");
            if (changesubsceneCol != null && changesubsceneCol.size() > 0) {
                ArrayList subsceneIds = Lists.newArrayListWithExpectedSize((int)changesubsceneCol.size());
                for (DynamicObject subscene : changesubsceneCol) {
                    subsceneIds.add(subscene.getString("fbasedataid"));
                }
                params.put("changesubscene", String.join((CharSequence)",", subsceneIds));
            }
            if (!"1".equals(msg.getDynamicObject("job").getString("datastatus"))) {
                params.put("ispreversion", Boolean.TRUE);
            }
        } else if (changeoperate == 1030L) {
            params.put("enable", msg.getDynamicObject("job").getString("enable"));
        }
        return params;
    }
}

