/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.upgrade.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbjm.business.domain.repository.HBJMEventRepository;
import kd.hrmp.hbjm.business.upgrade.IJobEventDataUpgradeService;
import kd.hrmp.hbjm.business.utils.JobMetaDataServiceHlper;
import kd.hrmp.hbjm.common.constants.ChangeEventConstants;

public class JobEventDataUpgradeServiceImpl
implements IJobEventDataUpgradeService,
ChangeEventConstants {
    private Log logger = LogFactory.getLog(JobEventDataUpgradeServiceImpl.class);

    @Override
    public void jobEventDataUpgrade() {
        DynamicObject[] sumDetailDyns;
        DynamicObject[] tranDetailDyns;
        if (!JobMetaDataServiceHlper.isMetaDataExist("hbjm_jobhr")) {
            return;
        }
        DynamicObject[] operationDetailDyns = HBJMEventRepository.getInstance().selectAllOpDetail();
        Map jobBoIdVsOperationDetailDynListMap = Arrays.stream(operationDetailDyns).sorted(Comparator.comparing(o -> o.getDate("createtime"))).collect(Collectors.groupingBy(dyn -> dyn.getLong("job"), Collectors.toList()));
        ArrayList changeOperateDetailDynList = Lists.newArrayListWithExpectedSize((int)operationDetailDyns.length);
        ArrayList changeTranDetailDynList = Lists.newArrayListWithExpectedSize((int)operationDetailDyns.length);
        ArrayList changeTranSumDynList = Lists.newArrayListWithExpectedSize((int)operationDetailDyns.length);
        Set jobBoIdVsDynListEntries = jobBoIdVsOperationDetailDynListMap.entrySet();
        for (Map.Entry jobBoIdVsDynListEntry : jobBoIdVsDynListEntries) {
            DynamicObject[] operationDetailDynList = jobBoIdVsDynListEntry.getValue();
            DynamicObject preOperationDetailDyn = (DynamicObject)operationDetailDynList.get(0);
            Long beforeJobIdForPre = preOperationDetailDyn.getLong("beforejob");
            Long changeOperateIdForPreDyn = preOperationDetailDyn.getLong("changeoperate.id");
            if (beforeJobIdForPre != 0L || changeOperateIdForPreDyn != 1010L) {
                this.logger.info("JobEventDataUpgradeServiceImpl jobEventDataUpgrade data error: the first operateDetail data is not add eventId={}, jobBoId = {}", (Object)preOperationDetailDyn.getLong("id"), (Object)preOperationDetailDyn.getLong("job"));
                continue;
            }
            for (int i = 1; i < operationDetailDynList.size(); ++i) {
                DynamicObject operationDetailDyn = (DynamicObject)operationDetailDynList.get(i);
                Long beforeJobId = operationDetailDyn.getLong("beforejob");
                Long changeOperateId = operationDetailDyn.getLong("changeoperate.id");
                if (beforeJobId == 0L && changeOperateId == 1010L) {
                    operationDetailDyn.set("changeoperate", (Object)1020L);
                    operationDetailDyn.set("beforejob", (Object)preOperationDetailDyn.getLong("afterjob"));
                    changeOperateDetailDynList.add(operationDetailDyn);
                }
                preOperationDetailDyn = operationDetailDyn;
            }
        }
        Set<Long> eventIdSet = changeOperateDetailDynList.stream().map(dyn -> dyn.getLong("event")).collect(Collectors.toSet());
        for (DynamicObject tranDetailDyn : tranDetailDyns = HBJMEventRepository.getInstance().selectEventDetails(eventIdSet)) {
            tranDetailDyn.set("changetype", (Object)1020L);
            tranDetailDyn.set("changescene", (Object)1020L);
            this.setSubSceneDynCol(tranDetailDyn, 1030L);
            changeTranDetailDynList.add(tranDetailDyn);
        }
        for (DynamicObject sumDetailDyn : sumDetailDyns = HBJMEventRepository.getInstance().selectEventSumDetails(eventIdSet)) {
            sumDetailDyn.set("changetype", (Object)1020L);
            sumDetailDyn.set("changescene", (Object)1020L);
            this.setSubSceneDynCol(sumDetailDyn, 1030L);
            changeTranSumDynList.add(sumDetailDyn);
        }
        new HRBaseServiceHelper("hbjm_changeoperdetail").update(changeOperateDetailDynList.toArray(new DynamicObject[0]));
        new HRBaseServiceHelper("hbjm_changetrandetail").update(changeTranDetailDynList.toArray(new DynamicObject[0]));
        new HRBaseServiceHelper("hbjm_changetransum").update(changeTranSumDynList.toArray(new DynamicObject[0]));
    }

    private void setSubSceneDynCol(DynamicObject dyn, Long subScene) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = dyn.getDynamicObjectCollection("changesubscene").getDynamicObjectType();
        DynamicObject subcene = new DynamicObject(dynamicObjectType);
        subcene.set("fbasedataid", (Object)subScene);
        dyn.set("changesubscene", (Object)collection);
    }
}

