/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.utils;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.service.InteTimeZone;
import kd.hrmp.hbjm.common.util.GroupKey;

public class GroupKeyBuilder {
    static final String GROUPKEYBUILDER_1 = "GroupKeyBuilder_1";
    static final String HRMP_HBJM_BUSINESS = "hrmp-hbjm-business";
    private List<String> propNames;
    private ExtendedDataEntity[] dataEntity;

    private GroupKeyBuilder() {
    }

    public static GroupKeyBuilder newInstance(ExtendedDataEntity[] dataEntity, List<String> propNames) {
        GroupKeyBuilder build = new GroupKeyBuilder();
        build.dataEntity = dataEntity;
        build.propNames = propNames;
        return build;
    }

    public Map<GroupKey, List<ExtendedDataEntity>> buildKeys() {
        if (this.dataEntity == null || this.dataEntity.length <= 0 || this.propNames == null || this.propNames.size() <= 0) {
            return null;
        }
        HashMap<GroupKey, List<ExtendedDataEntity>> keyResult = new HashMap<GroupKey, List<ExtendedDataEntity>>(this.dataEntity.length);
        DataEntityPropertyCollection props = this.dataEntity[0].getDataEntity().getDataEntityType().getProperties();
        for (int index = 0; index < this.dataEntity.length; ++index) {
            GroupKey groupKey = GroupKeyBuilder.buildKey(0, this.dataEntity[index].getDataEntity(), this.propNames, props);
            ArrayList<ExtendedDataEntity> entities = (ArrayList<ExtendedDataEntity>)keyResult.get(groupKey);
            if (entities == null) {
                entities = new ArrayList<ExtendedDataEntity>();
            }
            entities.add(this.dataEntity[index]);
            keyResult.put(groupKey, entities);
        }
        return keyResult;
    }

    public static GroupKey buildKey(int dataIndex, DynamicObject dy, List<String> propNames, DataEntityPropertyCollection props) {
        Object pkValue = dy.getPkValue();
        Object[] values = new Object[propNames.size()];
        Object[] valuesDesc = new Object[propNames.size()];
        for (int i = 0; i < propNames.size(); ++i) {
            String key = propNames.get(i);
            Object[] formatValues = GroupKeyBuilder.formatValue((IDataEntityProperty)props.get((Object)key), dy.get(key), dy);
            values[i] = formatValues[0];
            valuesDesc[i] = formatValues[1];
        }
        return new GroupKey(dataIndex, pkValue, values, valuesDesc);
    }

    public static Object[] formatValue(IDataEntityProperty property, Object value, DynamicObject dy) {
        Object[] values = new Object[2];
        values[0] = value;
        Object object = values[1] = value == null ? ResManager.loadKDString((String)"\u7a7a\u503c", (String)GROUPKEYBUILDER_1, (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]) : String.valueOf(value);
        if (property instanceof MuliLangTextProp) {
            boolean head = property.getParent() instanceof MainEntityType;
            DynamicObject data = null;
            data = head && !(dy.getDataEntityType() instanceof MainEntityType) ? (DynamicObject)dy.getParent() : dy;
            values[0] = property.getValueFast((Object)data) instanceof OrmLocaleValue ? property.getValueFast((Object)data) : value;
            Object object2 = values[1] = value == null ? ResManager.loadKDString((String)"\u7a7a\u503c", (String)GROUPKEYBUILDER_1, (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]) : value.toString();
        }
        if (property instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)property;
            if (value == null) {
                values[0] = bdProp.getRefIdProp() instanceof LongProp ? Long.valueOf(0L) : "";
                values[1] = ResManager.loadKDString((String)"\u7a7a\u503c", (String)GROUPKEYBUILDER_1, (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]);
            } else if (value instanceof DynamicObject) {
                values[0] = ((DynamicObject)value).getPkValue();
                values[1] = bdProp.getDisplayValue(value);
            }
        } else if (property instanceof ComboProp) {
            values[1] = ((ComboProp)property).getItemByName((String)value);
        } else if (property instanceof IntegerProp) {
            DecimalFormat format = new DecimalFormat("0");
            if (ObjectUtils.isEmpty((Object)value)) {
                value = 0;
            }
            values[1] = format.format(value);
        } else if (property instanceof DecimalProp) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(",###.");
            for (int i = 1; i <= ((DecimalProp)property).getScale(); ++i) {
                sBuilder.append('0');
            }
            DecimalFormat format = new DecimalFormat(sBuilder.toString());
            if (ObjectUtils.isEmpty((Object)value)) {
                value = 0;
            }
            values[1] = format.format(value);
        } else if (property instanceof DateProp) {
            if (value != null) {
                InteTimeZone zone = ((DateTimeProp)property).getTimeZone(Long.valueOf(0L));
                values[1] = zone.format((Date)value, (DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            }
        } else if (property instanceof TimeProp) {
            if (value != null) {
                if (value instanceof Integer && value.equals(-1)) {
                    values[1] = ResManager.loadKDString((String)"\u7a7a\u503c", (String)GROUPKEYBUILDER_1, (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]);
                } else if (value instanceof Integer) {
                    values[1] = GroupKeyBuilder.getTimeFormat((Integer)value);
                }
            }
        } else if (property instanceof DateTimeProp) {
            if (value != null) {
                InteTimeZone zone = ((DateTimeProp)property).getTimeZone(Long.valueOf(0L));
                values[1] = zone.format((Date)value, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            }
        } else if (property instanceof BooleanProp) {
            values[1] = (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"GroupKeyBuilder_2", (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"GroupKeyBuilder_3", (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]);
        } else if (property instanceof TextProp && StringUtils.isBlank((Object)value)) {
            value = "";
            values[1] = StringUtils.isBlank((Object)value) ? ResManager.loadKDString((String)"\u7a7a\u503c", (String)GROUPKEYBUILDER_1, (String)HRMP_HBJM_BUSINESS, (Object[])new Object[0]) : value;
        }
        return values;
    }

    public static String getTimeFormat(int time) {
        int temp = time;
        int hh = temp / 3600;
        int mm = temp % 3600 / 60;
        int ss = temp % 3600 % 60;
        return (hh < 10 ? "0" + hh : Integer.valueOf(hh)) + ":" + (mm < 10 ? "0" + mm : Integer.valueOf(mm)) + ":" + (ss < 10 ? "0" + ss : Integer.valueOf(ss));
    }
}

