/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.job;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeEventServiceImpl;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeMsgServiceImpl;

public class JobHrDeleteOp
extends HRDataBaseOp {
    public void initialize(InitOperationArgs initOperationArgs) {
        super.initialize(initOperationArgs);
        this.getOption().setVariableValue("ignorerefentityids", "hbjm_changeoperdetail,hbjm_changetransum,hbjm_changetrandetail,hbjm_changemsg");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        Object[] dataCols;
        String key = args.getOperationKey();
        if (HRStringUtils.equals((String)"delete", (String)key) && !ObjectUtils.isEmpty((Object[])(dataCols = args.getDataEntities()))) {
            List boidList = Arrays.stream(dataCols).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
            Object[] jobs = JobRepository.getInstance().queryDataByBoids(boidList);
            if (!ObjectUtils.isEmpty((Object[])jobs)) {
                List ids = Arrays.stream(jobs).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.operateOption.setVariableValue("deleteDataIds", SerializationUtils.serializeToBase64(ids));
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Object[] dataCols;
        String key = args.getOperationKey();
        if (HRStringUtils.equals((String)"delete", (String)key) && !ObjectUtils.isEmpty((Object[])(dataCols = args.getDataEntities()))) {
            List boidList = Arrays.stream(dataCols).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
            ChangeEventServiceImpl service = new ChangeEventServiceImpl();
            service.delEvent(boidList);
            String deleteDataIdsStr = this.operateOption.getVariableValue("deleteDataIds");
            if (HRStringUtils.isNotEmpty((String)deleteDataIdsStr)) {
                ChangeMsgServiceImpl msgService = new ChangeMsgServiceImpl();
                List ids = (List)SerializationUtils.deSerializeFromBase64((String)deleteDataIdsStr);
                msgService.delByJobBoids(ids);
            }
        }
    }
}

