/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.job;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbjm.business.domain.application.impl.job.JobApplicationImpl;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeEventServiceImpl;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeMsgServiceImpl;
import kd.hrmp.hbjm.business.utils.model.JobDisableModel;
import kd.hrmp.hbjm.common.util.HashMapUtil;

public class JobHrDisableOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("changedesc");
        keys.add("changedesc2");
        keys.add("boid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object[] datas = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])datas)) {
            return;
        }
        String opKey = e.getOperationKey();
        if (HRStringUtils.equals((String)"job_disable_confirm", (String)opKey)) {
            String disMoelStr = this.operateOption.getVariableValue("jobDisableModel", null);
            JobDisableModel model = null;
            if (!ObjectUtils.isEmpty((Object)disMoelStr)) {
                model = (JobDisableModel)SerializationUtils.deSerializeFromBase64((String)disMoelStr);
            }
            JobApplicationImpl jobApplication = new JobApplicationImpl();
            jobApplication.disableJob((DynamicObject[])datas, model);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] disablehis;
        super.endOperationTransaction(e);
        List jobBoid = Arrays.stream(e.getDataEntities()).map(data -> data.getLong("boid")).collect(Collectors.toList());
        HashMap<Long, Date> map = new HashMap<Long, Date>(HashMapUtil.getInitCapacity((int)jobBoid.size()));
        ArrayList newHisIdList = Lists.newArrayListWithExpectedSize((int)e.getDataEntities().length);
        for (DynamicObject dyn : disablehis = JobRepository.getInstance().getDisableHis(jobBoid)) {
            map.put(dyn.getLong("boid"), dyn.getDate("bsed"));
            newHisIdList.add(dyn.getLong("id"));
            dyn.set("changetype", (Object)1030L);
            dyn.set("changeoperate", (Object)1030L);
            dyn.set("changescene", (Object)1030L);
        }
        Map changeBeforeHisJob = JobRepository.getInstance().getChangeBeforeHisJob(map, (List)newHisIdList);
        ArrayList hisId = new ArrayList(changeBeforeHisJob.size());
        changeBeforeHisJob.values().forEach(his -> hisId.add(his.getLong("id")));
        DynamicObject[] beforedata = JobRepository.getInstance().loadJobData(hisId);
        ChangeEventServiceImpl service = new ChangeEventServiceImpl();
        service.handleChangeEvent("10", beforedata, disablehis, null);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
    }
}

