/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.job;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.model.hismodel.HisModelOperationBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeEventServiceImpl;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeMsgServiceImpl;
import kd.hrmp.hbjm.common.util.HashMapUtil;
import kd.hrmp.hbjm.opplugin.web.HBJMDataBaseOp;
import kd.hrmp.hbjm.opplugin.web.validator.JobEnableValidator;
import kd.hrmp.hbjm.opplugin.web.validator.JobNameUniqueValidator;

public class JobHrEnableOp
extends HBJMDataBaseOp {
    Map<Long, String> jobBoIdVsEnableMap = Maps.newHashMapWithExpectedSize((int)16);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        Map fields = EntityMetadataCache.getDataEntityType((String)"hbjm_jobhr").getFields();
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.addAll(fields.keySet());
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new JobEnableValidator());
        evt.addValidator((AbstractValidator)new JobNameUniqueValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(dataEntity -> this.jobBoIdVsEnableMap.put(dataEntity.getLong("boid"), dataEntity.getString("enable")));
        this.getOption().setVariableValue("HisModelBusinessClassName", ((Object)((Object)this)).getClass().getName());
        this.getOption().setVariableValue("HisModelBusinessMethodName", "dealDynsInfo");
    }

    public void dealDynsInfo(HisModelOperationBo bo) {
        Object[] dyns = bo.getDataEntities();
        if (!ObjectUtils.isEmpty((Object[])dyns)) {
            for (Object dyn : dyns) {
                OrmLocaleValue changedesc2orm;
                if (HRStringUtils.equals((String)dyn.getString("enable"), (String)"10")) continue;
                dyn.set("changedesc", null);
                Object changedesc2 = dyn.get("changedesc2");
                if (!(changedesc2 instanceof OrmLocaleValue) || (changedesc2orm = (OrmLocaleValue)changedesc2) == null) continue;
                changedesc2orm.clear();
                dyn.set("changedesc2", (Object)changedesc2orm);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] enableHisDyns;
        super.endOperationTransaction(e);
        List needRecordDynList = Arrays.stream(e.getDataEntities()).filter(dyn -> HRStringUtils.equals((String)dyn.getString("status"), (String)"C")).collect(Collectors.toList());
        Set jobBoIdSet = needRecordDynList.stream().map(data -> data.getLong("boid")).collect(Collectors.toSet());
        HashMap<Long, Date> map = new HashMap<Long, Date>(HashMapUtil.getInitCapacity((int)jobBoIdSet.size()));
        ArrayList newHisIdList = Lists.newArrayListWithExpectedSize((int)e.getDataEntities().length);
        for (DynamicObject enableHisDyn : enableHisDyns = JobRepository.getInstance().getEnableHis(jobBoIdSet)) {
            long boId = enableHisDyn.getLong("boid");
            String enable = this.jobBoIdVsEnableMap.get(boId);
            if (HRStringUtils.equals((String)enable, (String)"10")) {
                enableHisDyn.set("changetype", (Object)1010L);
                enableHisDyn.set("changeoperate", (Object)1010L);
                enableHisDyn.set("changescene", (Object)1010L);
                continue;
            }
            if (!HRStringUtils.equals((String)enable, (String)"0")) continue;
            map.put(boId, enableHisDyn.getDate("bsed"));
            newHisIdList.add(enableHisDyn.getLong("id"));
            enableHisDyn.set("changetype", (Object)1020L);
            enableHisDyn.set("changeoperate", (Object)1020L);
            enableHisDyn.set("changescene", (Object)1020L);
            enableHisDyn.set("changedesc", null);
            enableHisDyn.set("changedesc2", null);
        }
        Map changeBeforeHisJob = JobRepository.getInstance().getChangeBeforeHisJob(map, (List)newHisIdList);
        ArrayList hisId = new ArrayList(changeBeforeHisJob.size());
        changeBeforeHisJob.values().forEach(his -> hisId.add(his.getLong("id")));
        DynamicObject[] beforeData = JobRepository.getInstance().loadJobData(hisId);
        ChangeEventServiceImpl service = new ChangeEventServiceImpl();
        service.handleChangeEvent("10", beforeData, enableHisDyns, null);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
    }
}

