/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.job;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeEventServiceImpl;
import kd.hrmp.hbjm.business.domain.service.impl.ChangeMsgServiceImpl;
import kd.hrmp.hbjm.business.utils.JobUtils;
import kd.hrmp.hbjm.common.util.HashMapUtil;
import kd.hrmp.hbjm.common.util.ImportCommonUtil;
import kd.hrmp.hbjm.opplugin.web.validator.JobGradeLevelSaveHandelValidator;
import kd.hrmp.hbjm.opplugin.web.validator.JobNameUniqueValidator;
import kd.hrmp.hbjm.opplugin.web.validator.importinfo.JobChangeDataValidator;
import kd.hrmp.hbjm.opplugin.web.validator.importinfo.JobInitNewDataValidator;
import kd.hrmp.hbjm.opplugin.web.validator.importinfo.JobNewDataValidator;

public class JobHrSaveOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(JobHrSaveOp.class);
    private long changetype;
    private long changeoperate;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("jobscm.enable");
        keys.add("jobseq.enable");
        keys.add("jobfamily.enable");
        keys.add("jobclass.enable");
        keys.add("name");
        keys.add("number");
        keys.add("boid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        String importType;
        super.onAddValidators(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            long[] longIds = DB.genGlobalLongIds((int)args.getDataEntities().length);
            int index = 0;
            for (DynamicObject dy : args.getDataEntities()) {
                long id = dy.getLong("id");
                if (id != 0L) continue;
                dy.set("id", (Object)longIds[index]);
                ++index;
            }
        }
        if ("override".equals(importType = ImportCommonUtil.getImportType((OperateOption)this.getOption()))) {
            args.addValidator((AbstractValidator)new JobChangeDataValidator());
        } else if ("new".equals(importType)) {
            args.addValidator((AbstractValidator)new JobNewDataValidator());
        }
        if (ImportCommonUtil.isInitImportOpType((OperateOption)this.operateOption)) {
            args.addValidator((AbstractValidator)new JobInitNewDataValidator(){

                @Override
                protected void doValidate() {
                    this.doExtendValidate();
                }
            });
        }
        args.addValidator((AbstractValidator)new JobGradeLevelSaveHandelValidator());
        args.addValidator((AbstractValidator)new JobNameUniqueValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        long start = System.currentTimeMillis();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList needRecordDynList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            if (JobUtils.isEnablingOrNoAuditData((DynamicObject)dataEntity)) continue;
            needRecordDynList.add(dataEntity);
        }
        this.parseOpType(e.getOperationKey());
        ArrayList dynList = Lists.newArrayListWithExpectedSize((int)e.getDataEntities().length);
        HashMap<Long, Date> map = new HashMap<Long, Date>(HashMapUtil.getInitCapacity((int)dynList.size()));
        ArrayList newHisIdList = Lists.newArrayListWithExpectedSize((int)e.getDataEntities().length);
        for (DynamicObject dyn : needRecordDynList) {
            if (dyn.getBoolean("iscurrentversion") && !HRStringUtils.equals((String)dyn.getString("enable"), (String)"10")) continue;
            map.put(dyn.getLong("boid"), dyn.getDate("bsed"));
            newHisIdList.add(dyn.getLong("id"));
            dyn.set("changetype", (Object)this.changetype);
            dyn.set("changeoperate", (Object)this.changeoperate);
            dyn.set("changescene", (Object)this.changetype);
            dynList.add(dyn);
        }
        DynamicObject[] beforedata = null;
        if (this.changeoperate != 1010L) {
            Map changeBeforeHisJob = JobRepository.getInstance().getChangeBeforeHisJob(map, (List)newHisIdList);
            ArrayList hisId = new ArrayList(changeBeforeHisJob.size());
            changeBeforeHisJob.values().forEach(his -> hisId.add(his.getLong("id")));
            beforedata = JobRepository.getInstance().loadJobData(hisId);
        }
        long end1 = System.currentTimeMillis();
        ChangeEventServiceImpl service = new ChangeEventServiceImpl();
        service.handleChangeEvent("10", beforedata, dynList.toArray(new DynamicObject[0]), null);
        long end2 = System.currentTimeMillis();
        StringBuilder time = new StringBuilder();
        time.append("JobHrSaveOp_endOperationTransaction_expense all=").append(end2 - start);
        time.append(" time1=").append(end1 - start);
        time.append(" time2=").append(end2 - end1);
        logger.info(time.toString());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
    }

    private void parseOpType(String operationKey) {
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.changetype = 1010L;
            this.changeoperate = 1010L;
            boolean isInitSave = HRStringUtils.equals((String)"save", (String)this.operateOption.getVariableValue("initType", ""));
            if (isInitSave) {
                this.changetype = 1040L;
                this.changeoperate = 1010L;
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"confirmchangenoaudit") || HRStringUtils.equals((String)operationKey, (String)"confirmchange")) {
            this.changetype = 1020L;
            this.changeoperate = 1020L;
        }
    }
}

