/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class JobBaseValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        this.validateEnableAndInitStatus(dataEntities);
    }

    private void validateEnableAndInitStatus(ExtendedDataEntity[] dataEntities) {
        DynamicObject[] dbDatas;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityKey);
        Map<Object, Object> dataMap = new HashMap(dataEntities.length);
        QFilter filter = new QFilter("1", "=", (Object)1);
        String selectFields = "id,name,number,enable,initstatus,initdatasource";
        String happykey = "id";
        if (dataEntities[0].getDataEntity().getDataEntityType().getProperties().containsKey((Object)"iscurrentversion")) {
            happykey = "boid";
            QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            filter.and(currentFilter);
            dataMap = Arrays.stream(dataEntities).filter(entity -> entity.getDataEntity().getLong("boid") > 0L).collect(Collectors.groupingBy(ExtendedDataEntity2 -> ExtendedDataEntity2.getDataEntity().getLong("boid"), Collectors.toList()));
            QFilter boidFilter = new QFilter("boid", "in", dataMap.keySet());
            filter.and(boidFilter);
            selectFields = selectFields + ",boid";
        } else {
            dataMap = Arrays.stream(dataEntities).filter(entity -> entity.getDataEntity().getLong("id") > 0L).collect(Collectors.groupingBy(ExtendedDataEntity2 -> ExtendedDataEntity2.getDataEntity().getLong("id"), Collectors.toList()));
            QFilter idFilter = new QFilter("id", "in", dataMap.keySet());
            filter.and(idFilter);
        }
        for (DynamicObject data : dbDatas = serviceHelper.query(selectFields, new QFilter[]{filter})) {
            String errorMsg;
            if ("0".equals(data.getString("enable"))) {
                errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u53ef\u53d8\u66f4\u3002", (String)"JobBaseValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity extendedDataEntity : (List)dataMap.get(data.getLong(happykey))) {
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                }
            }
            if (!"1".equals(data.getString("initdatasource")) || "2".equals(data.getString("initstatus"))) continue;
            errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u521d\u59cb\u5316\u672a\u5b8c\u6210\uff0c\u4e0d\u53ef\u53d8\u66f4\u3002", (String)"JobBaseValidator_1", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity extendedDataEntity : (List)dataMap.get(data.getLong(happykey))) {
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
        }
    }
}

