/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbjm.business.domain.service.IBaseValidatorService;
import kd.hrmp.hbjm.business.domain.service.impl.JobAbstractBaseValidatorService;

public class JobClassEnableValidator
extends HRDataBaseValidator {
    private IBaseValidatorService valide = new JobAbstractBaseValidatorService();

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"enable")) {
            this.validateEnabledJobFamily(dataEntities);
        }
    }

    private void validateEnabledJobFamily(ExtendedDataEntity[] dataEntities) {
        this.valide.enableValide(dataEntities, "jobfamily", data -> {
            String errorMsg = ResManager.loadKDString((String)"\u804c\u4f4d\u65cf\u65e0\u6548", (String)"JobClassEnableValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)data, errorMsg);
        });
        List<ExtendedDataEntity> dataList = Arrays.stream(dataEntities).sorted(Comparator.comparingInt(data -> data.getDataEntity().getInt("jobclasslevel"))).collect(Collectors.toList());
        Set ids = dataList.stream().map(data -> data.getDataEntity().getLong("id")).collect(Collectors.toSet());
        HashSet errorIds = new HashSet(8);
        List validResults = this.validateContext.getValidateResults().getValidateErrors();
        if (validResults != null) {
            validResults.stream().forEach(validResult -> {
                List errorInfos = validResult.getAllErrorInfo();
                if (errorInfos != null) {
                    errorInfos.stream().forEach(errorInfo -> errorIds.add((Long)errorInfo.getPkValue()));
                }
            });
        }
        this.valide.enableValide(dataList.toArray(new ExtendedDataEntity[0]), "parent", data -> {
            String errorMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u804c\u4f4d\u7c7b\u65e0\u6548\u3002", (String)"JobClassEnableValidator_1", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            ExtendedDataEntity info = (ExtendedDataEntity)data;
            long parentId = info.getDataEntity().getLong("parent.id");
            if (ids.contains(parentId)) {
                if (errorIds.contains(parentId)) {
                    this.addErrorMessage(info, errorMsg);
                    errorIds.add(info.getDataEntity().getLong("id"));
                }
            } else {
                this.addErrorMessage(info, errorMsg);
                errorIds.add(info.getDataEntity().getLong("id"));
            }
        });
    }
}

