/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import org.apache.commons.collections.CollectionUtils;

public class JobClassValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"his_disable")) {
            this.validateEnabledJobClass(dataEntities);
            this.validateEnabledSubJobClass(dataEntities);
        }
    }

    private void validateEnabledJobClass(ExtendedDataEntity[] dataEntities) {
        Map<Long, ExtendedDataEntity> idJobClassMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getDataEntity().getLong("id"), dy -> dy));
        DynamicObject[] jobDys = JobRepository.getInstance().queryByJobClassIds(idJobClassMap.keySet());
        if (Objects.isNull(jobDys) || jobDys.length == 0) {
            return;
        }
        Set jobClassIds = Arrays.stream(jobDys).map(dy -> dy.getLong("jobclass")).collect(Collectors.toSet());
        for (Long jobClassId : jobClassIds) {
            ExtendedDataEntity entendedData = idJobClassMap.get(jobClassId);
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u804c\u4f4d\u7c7b\u4e0b\u5b58\u5728\u53ef\u7528\u7684\u804c\u4f4d\uff0c\u4e0d\u53ef\u7981\u7528\u3002", (String)"JobClassValidator_1", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(entendedData, errorMsg);
        }
    }

    private void validateEnabledSubJobClass(ExtendedDataEntity[] dataEntities) {
        Set jobClassIdSet = Arrays.stream(dataEntities).map(dyn -> dyn.getDataEntity().getLong("id")).collect(Collectors.toSet());
        DynamicObject[] subJobClass = JobClassRepository.getInstance().querySubJobClassByIds(jobClassIdSet);
        HashMap subIdSetForJobClassMap = Maps.newHashMap();
        Arrays.stream(subJobClass).forEach(dyn -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)subIdSetForJobClassMap.get(dyn.getLong("parent"))))) {
                HashSet subJobClassIdSet = Sets.newHashSet();
                subJobClassIdSet.add(dyn.getLong("id"));
                subIdSetForJobClassMap.put(dyn.getLong("parent"), subJobClassIdSet);
            } else {
                Set subJobClassIdSet = (Set)subIdSetForJobClassMap.get(dyn.getLong("parent"));
                subJobClassIdSet.add(dyn.getLong("id"));
                subIdSetForJobClassMap.put(dyn.getLong("parent"), subJobClassIdSet);
            }
        });
        List sortedJobClass = Arrays.stream(dataEntities).sorted((o1, o2) -> {
            int jobclasslevel1 = o1.getDataEntity().getInt("jobclasslevel");
            int jobclasslevel2 = o2.getDataEntity().getInt("jobclasslevel");
            return jobclasslevel2 - jobclasslevel1;
        }).collect(Collectors.toList());
        for (int i = 0; i < sortedJobClass.size(); ++i) {
            ExtendedDataEntity jobclassExtendedData = (ExtendedDataEntity)sortedJobClass.get(i);
            long jobClassId = jobclassExtendedData.getDataEntity().getLong("id");
            Set subJobClassIdSet = (Set)subIdSetForJobClassMap.get(jobClassId);
            if (CollectionUtils.isEmpty((Collection)subJobClassIdSet)) {
                long parentId = jobclassExtendedData.getDataEntity().getLong("parent.id");
                Set newSubJobClass = (Set)subIdSetForJobClassMap.get(parentId);
                if (CollectionUtils.isEmpty((Collection)newSubJobClass)) continue;
                newSubJobClass.remove(jobClassId);
                subIdSetForJobClassMap.put(parentId, newSubJobClass);
                continue;
            }
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u804c\u4f4d\u7c7b\u4e0b\u5b58\u5728\u53ef\u7528\u7684\u804c\u4f4d\u5b50\u7c7b\uff0c\u4e0d\u53ef\u7981\u7528\u3002", (String)"JobClassValidator_2", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(jobclassExtendedData, errorMsg);
        }
    }
}

