/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;

public class JobFamilyValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"his_disable")) {
            this.validateEnabledJobClass(dataEntities);
        }
    }

    private void validateEnabledJobClass(ExtendedDataEntity[] dataEntities) {
        Map<Long, ExtendedDataEntity> collect = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getDataEntity().getLong("id"), dy -> dy));
        DynamicObject[] classDys = JobClassRepository.getInstance().queryJobFamilyByIds(collect.keySet());
        if (Objects.isNull(classDys) || classDys.length == 0) {
            return;
        }
        List jobFamilyIds = Arrays.stream(classDys).map(dy -> dy.getLong("jobfamily")).collect(Collectors.toList());
        for (Long jobFamilyId : jobFamilyIds) {
            ExtendedDataEntity en = collect.get(jobFamilyId);
            String errorMsg = ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u804c\u4f4d\u65cf\u4e0b\u5b58\u5728\u53ef\u7528\u7684\u804c\u4f4d\u7c7b\u3002", (String)"JobFamilyValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(en, errorMsg);
        }
    }
}

