/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbjm.business.domain.repository.JobGradeScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobLevelScmRepository;

public class JobGradeLevelRefCheckUtil {
    public static Map<ExtendedDataEntity, String> checkRefrence(ExtendedDataEntity[] dataEntities, String tag) {
        HashMap<Long, ExtendedDataEntity> idJobGradeLevelScmMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        ArrayList<Long> jobGradeEntryBoIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity jobGradeScm : dataEntities) {
            idJobGradeLevelScmMap.put(jobGradeScm.getDataEntity().getLong("boid"), jobGradeScm);
            for (DynamicObject jobGrade : jobGradeScm.getDataEntity().getDynamicObjectCollection("entryentity")) {
                jobGradeEntryBoIds.add(jobGrade.getLong("entryboid"));
            }
        }
        DynamicObject[] needCheckJobGradeLevelScms = null;
        HRBaseServiceHelper serviceHelper = null;
        if ("jobgradescm".equals(tag)) {
            needCheckJobGradeLevelScms = JobGradeScmRepository.getInstance().queryJobGradeScmByrowIds(idJobGradeLevelScmMap.keySet().stream().collect(Collectors.toList()));
            serviceHelper = new HRBaseServiceHelper("hbjm_jobgradehr");
        } else {
            needCheckJobGradeLevelScms = JobLevelScmRepository.getInstance().queryJobLevelScmByrowIds(idJobGradeLevelScmMap.keySet().stream().collect(Collectors.toList()));
            serviceHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        }
        HashMap<Long, Long> needCheckIdMap = new HashMap<Long, Long>(needCheckJobGradeLevelScms.length);
        HashMap<Long, String> jobGradeLevelIdNameMap = new HashMap<Long, String>(needCheckJobGradeLevelScms.length);
        for (DynamicObject needCheckJobGradeScm : needCheckJobGradeLevelScms) {
            for (DynamicObject needCheckJobGrade : needCheckJobGradeScm.getDynamicObjectCollection("entryentity")) {
                if (jobGradeEntryBoIds.contains(needCheckJobGrade.getLong("entryboid"))) continue;
                needCheckIdMap.put(needCheckJobGrade.getLong("id"), needCheckJobGradeScm.getLong("boid"));
                if ("jobgradescm".equals(tag)) {
                    jobGradeLevelIdNameMap.put(needCheckJobGrade.getLong("id"), needCheckJobGrade.getString("jobgrade_number"));
                    continue;
                }
                jobGradeLevelIdNameMap.put(needCheckJobGrade.getLong("id"), needCheckJobGrade.getString("joblevel_number"));
            }
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        Set ignoreRefEntitySet = checker.getIgnoreRefEntityIds();
        ignoreRefEntitySet.add("hbjm_jobinit");
        DynamicObject jobGradeLevelDyn = serviceHelper.generateEmptyDynamicObject();
        Map checkResult = checker.checkRef((BasedataEntityType)jobGradeLevelDyn.getDataEntityType(), needCheckIdMap.keySet().toArray());
        Iterator resultIterator = checkResult.entrySet().iterator();
        HashMap<ExtendedDataEntity, String> result = new HashMap<ExtendedDataEntity, String>(checkResult.size());
        while (resultIterator.hasNext()) {
            ExtendedDataEntity dataObj;
            Map.Entry entry = resultIterator.next();
            Long jobGradeScmId = (Long)needCheckIdMap.get(entry.getKey());
            String jobGradeNumber = (String)jobGradeLevelIdNameMap.get(entry.getKey());
            if (jobGradeScmId == null || jobGradeScmId == 0L || (dataObj = (ExtendedDataEntity)idJobGradeLevelScmMap.get(jobGradeScmId)) == null) continue;
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
            if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
            String msg = JobGradeLevelRefCheckUtil.buildRefMessage(refrenceResult, jobGradeNumber);
            result.put((ExtendedDataEntity)idJobGradeLevelScmMap.get(jobGradeScmId), msg);
        }
        return result;
    }

    private static String buildRefMessage(BaseDataCheckRefrenceResult refrenceResult, String number) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = refrenceResult.getRefenceKey().getRefTable();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (JobGradeLevelRefCheckUtil.equalsFieldname(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!JobGradeLevelRefCheckUtil.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5206\u5f55\u6570\u636e\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u201c%2$s\u201d\u7684\u5b57\u6bb5\u201c%3$s\u201d\u5f15\u7528\u3002", (String)"JobGradeLevelRefCheckUtil_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), number, billName, fieldName);
        return msg;
    }

    private static boolean equalsFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (property instanceof IFieldHandle && property.getParent() != null && property.getParent().getAlias() != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
                return false;
            }
            String propTableName = property.getParent().getAlias();
            if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                propTableName = propTableName + "_" + property.getTableGroup();
            }
            return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
        }
        return false;
    }

    private static boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() != null && mulBasedataProp.getItemType().getAlias() != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
        }
        return false;
    }
}

