/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;

public class JobGradeLevelSaveHandelValidator
extends HRDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(JobGradeLevelSaveHandelValidator.class);
    private static final GradeOrLevelType gradeType = new GradeOrLevelType("jobgrade", ResManager.loadKDString((String)"\u804c\u7b49", (String)"JobGradeLevelSaveHandelValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), "jobgradescm", "lowjobgrade", "lowjobgradename", "highjobgrade", "highjobgradename", "jobgradeseq", "jobgrade_seq", "jobgrade_name");
    private static final GradeOrLevelType levelType = new GradeOrLevelType("joblevel", ResManager.loadKDString((String)"\u804c\u7ea7", (String)"JobGradeLevelSaveHandelValidator_1", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), "joblevelscm", "lowjoblevel", "lowjoblevelname", "highjoblevel", "highjoblevelname", "joblevelseq", "joblevel_seq", "joblevel_name");
    private Map<String, DynamicObjectCollection> entryList;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        this.validateJobGradeOrLevelInfo();
        this.validateFamilyAndJobGradeOrLevel();
        this.valideClassAndGradeOrLevel();
        long end1 = System.currentTimeMillis();
        StringBuilder time = new StringBuilder();
        time.append("JobGradeLevelSaveHandelValidator_expense all=").append(end1 - start);
        LOGGER.info(time.toString());
    }

    private void validateJobGradeOrLevelInfo() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.handleJobGradeOrLevelInfoValide(dataEntity, () -> gradeType);
            this.handleJobGradeOrLevelInfoValide(dataEntity, () -> levelType);
        }
    }

    private void handleJobGradeOrLevelInfoValide(ExtendedDataEntity dataEntity, Supplier<GradeOrLevelType> supplier) {
        String higColNameVal;
        GradeOrLevelType typeInfo = supplier.get();
        DynamicObject jobDyn = dataEntity.getDataEntity();
        String lowColNameVal = jobDyn.getString(typeInfo.lowColName);
        if (!HRStringUtils.equals((String)lowColNameVal, (String)(higColNameVal = jobDyn.getString(typeInfo.higColName))) && (HRStringUtils.equals((String)"NULL", (String)lowColNameVal) || HRStringUtils.equals((String)"NULL", (String)higColNameVal))) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u9ad8%1$s\u548c\u6700\u4f4e%2$s\u9700\u540c\u65f6\u586b\u5199\u6216\u4e0d\u586b\u5199\u3002", (String)"JobGradeLevelSaveHandelValidator_8", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name, typeInfo.name);
            this.addFatalErrorMessage(dataEntity, errorMsg);
        } else if (HRStringUtils.equals((String)"NULL", (String)lowColNameVal) && HRStringUtils.equals((String)"NULL", (String)higColNameVal)) {
            jobDyn.set(typeInfo.lowCol, null);
            jobDyn.set(typeInfo.highCol, null);
        }
        if (ObjectUtils.isEmpty((Object)lowColNameVal) && !ObjectUtils.isEmpty((Object)jobDyn.get(typeInfo.lowCol))) {
            jobDyn.set(typeInfo.lowColName, jobDyn.get(typeInfo.lowCol + ".name"));
        }
        if (ObjectUtils.isEmpty((Object)higColNameVal) && !ObjectUtils.isEmpty((Object)jobDyn.get(typeInfo.highCol))) {
            jobDyn.set(typeInfo.higColName, jobDyn.get(typeInfo.highCol + ".name"));
        }
        this.dealLowAndHighCol(jobDyn, typeInfo.lowColName, typeInfo.higColName, lowColNameVal, higColNameVal);
    }

    private void validateFamilyAndJobGradeOrLevel() {
        ArrayList<Long> jobScmIds = new ArrayList<Long>(this.dataEntities.length);
        ArrayList<Long> jobFamilyIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject jobDyn = dataEntity.getDataEntity();
            if (!HRStringUtils.isNotEmpty((String)jobDyn.getString("lowjoblevelname")) && !HRStringUtils.isNotEmpty((String)jobDyn.getString("highjoblevelname")) && !HRStringUtils.isNotEmpty((String)jobDyn.getString("lowjobgradename")) && !HRStringUtils.isNotEmpty((String)jobDyn.getString("highjobgradename"))) continue;
            jobScmIds.add(jobDyn.getLong("jobscm.id"));
            jobFamilyIds.add(jobDyn.getLong("jobfamily.id"));
        }
        Object[] jobFamilyUnderScm = JobFamilyScmRepository.getInstance().getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds(jobScmIds, jobFamilyIds);
        if (ObjectUtils.isEmpty((Object[])jobFamilyUnderScm)) {
            return;
        }
        Map<String, DynamicObject> familyMap = Arrays.stream(jobFamilyUnderScm).collect(Collectors.toMap(scm -> scm.getString("jobscm.id") + scm.getString("jobfamily.id"), dy -> dy));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.handleFamilyValide(dataEntity, familyMap, () -> gradeType);
            this.handleFamilyValide(dataEntity, familyMap, () -> levelType);
        }
    }

    private void dealLowAndHighCol(DynamicObject dyn, String lowCol, String highCol, String lowValue, String highValue) {
        lowValue = HRStringUtils.equals((String)"NULL", (String)lowValue) ? "" : lowValue;
        highValue = HRStringUtils.equals((String)"NULL", (String)highValue) ? "" : highValue;
        lowValue = HRStringUtils.isEmpty((String)lowValue) ? highValue : lowValue;
        highValue = HRStringUtils.isEmpty((String)highValue) ? lowValue : highValue;
        dyn.set(lowCol, (Object)lowValue);
        dyn.set(highCol, (Object)highValue);
    }

    private void handleFamilyValide(ExtendedDataEntity dataEntity, Map<String, DynamicObject> familyMap, Supplier<GradeOrLevelType> supplier) {
        GradeOrLevelType typeInfo = supplier.get();
        DynamicObject jobDyn = dataEntity.getDataEntity();
        Long scmId = jobDyn.getLong("jobscm.id");
        Long familyId = jobDyn.getLong("jobfamily.id");
        String lowColName = jobDyn.getString(typeInfo.lowColName);
        String higColName = jobDyn.getString(typeInfo.higColName);
        if (HRStringUtils.isNotEmpty((String)lowColName) || HRStringUtils.isNotEmpty((String)higColName)) {
            String key = String.valueOf(scmId) + String.valueOf(familyId);
            DynamicObject family = familyMap.get(key);
            if (family == null) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)family.get(typeInfo.scmColName))) {
                String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u4e0b\u804c\u4f4d\u65cf\u672a\u8bbe\u7f6e%s\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobGradeLevelSaveHandelValidator_2", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name);
                this.addFatalErrorMessage(dataEntity, errorMsg);
            } else {
                this.handleGradeAndLevel(dataEntity, family, lowColName, higColName, typeInfo);
            }
        }
    }

    private void handleGradeAndLevel(ExtendedDataEntity dataEntity, DynamicObject family, String lowLevelOrGradeName, String highLevelOrGradeName, GradeOrLevelType typeInfo) {
        String errorMsg;
        DynamicObject gradeOrLevelScm = family.getDynamicObject(typeInfo.scmColName);
        DynamicObjectCollection jobGradeOrLevelEntrys = this.getCollectionFromDynamic(gradeOrLevelScm, typeInfo.type);
        DynamicObject lowJobGradeORLevel = null;
        DynamicObject highJobGradeORLevel = null;
        if (jobGradeOrLevelEntrys != null) {
            for (DynamicObject jobGradeORLevel : jobGradeOrLevelEntrys) {
                if (jobGradeORLevel.getString(typeInfo.colId_name).equals(lowLevelOrGradeName)) {
                    lowJobGradeORLevel = jobGradeORLevel;
                }
                if (!jobGradeORLevel.getString(typeInfo.colId_name).equals(highLevelOrGradeName)) continue;
                highJobGradeORLevel = jobGradeORLevel;
            }
        }
        if (Objects.isNull(lowJobGradeORLevel)) {
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u4f4e%s\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobGradeLevelSaveHandelValidator_3", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name);
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
        if (Objects.isNull(highJobGradeORLevel)) {
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u9ad8%s\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobGradeLevelSaveHandelValidator_4", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name);
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
        if (lowJobGradeORLevel != null && !Objects.isNull(highJobGradeORLevel)) {
            Long lowSeq = lowJobGradeORLevel.getLong(typeInfo.seqColEntryId);
            Long highSeq = 0L;
            if (highJobGradeORLevel != null) {
                highSeq = highJobGradeORLevel.getLong(typeInfo.seqColEntryId);
            }
            if (lowSeq > highSeq) {
                String errorMsg2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u4f4e%1$s\u4e0e\u6700\u9ad8%2$s\u8f93\u5165\u4e0d\u6b63\u786e\u3002", (String)"JobGradeLevelSaveHandelValidator_5", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name, typeInfo.name);
                this.addFatalErrorMessage(dataEntity, errorMsg2);
            }
        }
        if (lowJobGradeORLevel != null) {
            dataEntity.setValue(typeInfo.lowCol + "_id", lowJobGradeORLevel.getPkValue());
            dataEntity.setValue(typeInfo.lowCol, (Object)lowJobGradeORLevel);
        }
        if (highJobGradeORLevel != null) {
            dataEntity.setValue(typeInfo.highCol + "_id", highJobGradeORLevel.getPkValue());
            dataEntity.setValue(typeInfo.highCol, (Object)highJobGradeORLevel);
        }
    }

    private void valideClassAndGradeOrLevel() {
        ArrayList<Long> jobScmIds = new ArrayList<Long>(this.dataEntities.length);
        ArrayList<Long> jobClassIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject jobDyn = dataEntity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)jobDyn.getString("jobclass")) || !HRStringUtils.isNotEmpty((String)jobDyn.getString("lowjoblevelname")) && !HRStringUtils.isNotEmpty((String)jobDyn.getString("highjoblevelname")) && !HRStringUtils.isNotEmpty((String)jobDyn.getString("lowjobgradename")) && !HRStringUtils.isNotEmpty((String)jobDyn.getString("highjobgradename"))) continue;
            jobScmIds.add(jobDyn.getLong("jobscm.id"));
            jobClassIds.add(jobDyn.getLong("jobclass.id"));
        }
        if (ObjectUtils.isEmpty(jobClassIds)) {
            return;
        }
        Object[] jobClassUnderScm = JobClassScmRepository.getInstance().getJobClassScmDyobjsByJobScmIdsAndJobClassIds(jobScmIds, jobClassIds);
        if (ObjectUtils.isEmpty((Object[])jobClassUnderScm)) {
            return;
        }
        Map<String, DynamicObject> jobGradeOrLevelMap = Arrays.stream(jobClassUnderScm).collect(Collectors.toMap(scm -> scm.getString("jobscm.id") + scm.getString("jobclass.id"), dy -> dy));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject job = dataEntity.getDataEntity();
            Long scmId = job.getLong("jobscm.id");
            Long classId = job.getLong("jobclass.id");
            if (!jobGradeOrLevelMap.containsKey(String.valueOf(scmId) + String.valueOf(classId))) continue;
            DynamicObject classUnderScm = jobGradeOrLevelMap.get(String.valueOf(scmId) + String.valueOf(classId));
            this.handleClassValide(dataEntity, classUnderScm, () -> gradeType);
            this.handleClassValide(dataEntity, classUnderScm, () -> levelType);
        }
    }

    private void handleClassValide(ExtendedDataEntity dataEntity, DynamicObject classUnderScm, Supplier<GradeOrLevelType> supplier) {
        String errorMsg;
        DynamicObject job = dataEntity.getDataEntity();
        GradeOrLevelType typeInfo = supplier.get();
        DynamicObject lowJobGradeOrLevel = job.getDynamicObject(typeInfo.lowCol);
        DynamicObject highJobGradeOrLevel = job.getDynamicObject(typeInfo.highCol);
        DynamicObject lowJobGradOrLevel_underscm = classUnderScm.getDynamicObject(typeInfo.lowCol);
        DynamicObject highJobGradeOrLevel_underscm = classUnderScm.getDynamicObject(typeInfo.highCol);
        if (lowJobGradeOrLevel == null || highJobGradeOrLevel == null || lowJobGradOrLevel_underscm == null || highJobGradeOrLevel_underscm == null) {
            return;
        }
        Long lowGradeOrLevelSeq = 0L;
        lowGradeOrLevelSeq = HRStringUtils.equals((String)lowJobGradeOrLevel.getDataEntityType().getExtendName(), (String)"entryentity") ? Long.valueOf(lowJobGradeOrLevel.getLong(typeInfo.seqColEntryId)) : Long.valueOf(lowJobGradeOrLevel.getLong(typeInfo.seqColId));
        Long highGradeOrLevelSeq = 0L;
        highGradeOrLevelSeq = HRStringUtils.equals((String)highJobGradeOrLevel.getDataEntityType().getExtendName(), (String)"entryentity") ? Long.valueOf(highJobGradeOrLevel.getLong(typeInfo.seqColEntryId)) : Long.valueOf(highJobGradeOrLevel.getLong(typeInfo.seqColId));
        Long lowGradeOrLevelSeq_underscm = lowJobGradOrLevel_underscm.getLong(typeInfo.seqColId);
        Long highGradeOrLevelSeq_underscm = highJobGradeOrLevel_underscm.getLong(typeInfo.seqColId);
        if (lowGradeOrLevelSeq > highGradeOrLevelSeq_underscm || lowGradeOrLevelSeq < lowGradeOrLevelSeq_underscm) {
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u4f4e%s\u4e0d\u5728\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u4e0b\u804c\u4f4d\u7c7b\u8bbe\u7f6e\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobGradeLevelSaveHandelValidator_6", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name);
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
        if (highGradeOrLevelSeq > highGradeOrLevelSeq_underscm || highGradeOrLevelSeq < lowGradeOrLevelSeq_underscm) {
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u9ad8%s\u4e0d\u5728\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u4e0b\u804c\u4f4d\u7c7b\u8bbe\u7f6e\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobGradeLevelSaveHandelValidator_7", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), typeInfo.name);
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
    }

    private DynamicObjectCollection getCollectionFromDynamic(DynamicObject gradeOrLevelScm, String type) {
        Long id = gradeOrLevelScm.getLong("id");
        String key = type + "_" + String.valueOf(id);
        if (this.entryList == null) {
            this.entryList = new HashMap<String, DynamicObjectCollection>();
        } else {
            DynamicObjectCollection value = this.entryList.get(key);
            if (value != null) {
                return value;
            }
        }
        DynamicObjectCollection jobGradeOrLevelEntrys = gradeOrLevelScm.getDynamicObjectCollection("entryentity");
        this.entryList.put(key, jobGradeOrLevelEntrys);
        return jobGradeOrLevelEntrys;
    }

    static class GradeOrLevelType {
        String type;
        String name;
        String scmColName;
        String lowCol;
        String lowColName;
        String highCol;
        String higColName;
        String seqColId;
        String seqColEntryId;
        String colId_name;

        GradeOrLevelType(String type, String name, String scmColName, String lowCol, String lowColName, String highCol, String higColName, String seqColId, String seqColEntryId, String colId_name) {
            this.type = type;
            this.name = name;
            this.scmColName = scmColName;
            this.lowCol = lowCol;
            this.lowColName = lowColName;
            this.highCol = highCol;
            this.higColName = higColName;
            this.seqColId = seqColId;
            this.seqColId = seqColId;
            this.seqColEntryId = seqColEntryId;
            this.colId_name = colId_name;
        }
    }
}

