/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hrmp.hbjm.business.utils.HbjmSystemParamHelper;
import kd.hrmp.hbjm.opplugin.web.validator.MultilangUniqueValidator;

public class JobNameUniqueValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] needValideData = this.filterNeedValideData(this.dataEntities);
        if (needValideData == null || needValideData.length <= 0) {
            return;
        }
        ArrayList<ExtendedDataEntity> jobClassDataList = new ArrayList<ExtendedDataEntity>(needValideData.length);
        ArrayList<ExtendedDataEntity> jobFamilyDataList = new ArrayList<ExtendedDataEntity>(needValideData.length);
        for (ExtendedDataEntity data : needValideData) {
            DynamicObject jobclass = data.getDataEntity().getDynamicObject("jobclass");
            if (jobclass != null && jobclass.getLong("id") > 0L) {
                jobClassDataList.add(data);
                continue;
            }
            jobFamilyDataList.add(data);
        }
        this.valideUnderJobClass(jobClassDataList.toArray(new ExtendedDataEntity[0]));
        this.valideUnderJobFamily(jobFamilyDataList.toArray(new ExtendedDataEntity[0]));
    }

    private void valideUnderJobClass(ExtendedDataEntity[] data) {
        if (data == null || data.length <= 0) {
            return;
        }
        String jobClassValideErrorInfo = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5e8f\u5217/\u65cf/\u7c7b\u4e0b\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7684\u804c\u4f4d\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u804c\u4f4d\u540d\u79f0\u3002", (String)"JobNameUniqueValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
        final JobNameUniqueValidator jobNameUniqueValidator = this;
        MultilangUniqueValidator multilangUniqueValidator_class = new MultilangUniqueValidator(data, new String[]{"jobscm", "name", "jobclass"}, jobClassValideErrorInfo){

            @Override
            protected QFilter getCommonFilter() {
                return JobNameUniqueValidator.this.getFilter();
            }

            @Override
            protected void buildErrorMessage(ExtendedDataEntity entity, String errorInfo) {
                jobNameUniqueValidator.addErrorMessage(entity, errorInfo);
            }
        };
        multilangUniqueValidator_class.validate();
    }

    private void valideUnderJobFamily(ExtendedDataEntity[] data) {
        if (data == null || data.length <= 0) {
            return;
        }
        final JobNameUniqueValidator jobNameUniqueValidator = this;
        String jobFamilyValideErrorInfo = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5e8f\u5217/\u65cf\u4e0b\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u804c\u4f4d\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u804c\u4f4d\u540d\u79f0\u3002", (String)"JobNameUniqueValidator_1", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
        MultilangUniqueValidator multilangUniqueValidator_family = new MultilangUniqueValidator(data, new String[]{"jobscm", "name", "jobfamily"}, jobFamilyValideErrorInfo){

            @Override
            protected QFilter getCommonFilter() {
                return JobNameUniqueValidator.this.getFilter().and(new QFilter("jobclass.id", "=", (Object)0));
            }

            @Override
            protected void buildErrorMessage(ExtendedDataEntity entity, String errorInfo) {
                jobNameUniqueValidator.addErrorMessage(entity, errorInfo);
            }
        };
        multilangUniqueValidator_family.validate();
    }

    protected ExtendedDataEntity[] filterNeedValideData(ExtendedDataEntity[] data) {
        if (data == null || data.length <= 0) {
            return data;
        }
        boolean param = HbjmSystemParamHelper.getJobNameValideParameterByRootId();
        if (param) {
            return data;
        }
        return null;
    }

    protected QFilter getFilter() {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return filter;
    }
}

