/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;

public class JobScmValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"disable")) {
            this.validateRelateJob(dataEntities);
        }
    }

    private void validateRelateJob(ExtendedDataEntity[] dataEntities) {
        Map<Long, ExtendedDataEntity> jobScmMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getDataEntity().getLong("id"), dy -> dy));
        DynamicObject[] scmDys = JobRepository.getInstance().queryByJobScmIds(jobScmMap.keySet());
        if (Objects.isNull(scmDys) || scmDys.length == 0) {
            return;
        }
        Set jobScmIds = Arrays.stream(scmDys).map(dy -> dy.getLong("jobscm_id")).collect(Collectors.toSet());
        for (Long jobScmId : jobScmIds) {
            ExtendedDataEntity jobScm = jobScmMap.get(jobScmId);
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u7981\u7528\u3002", (String)"JobScmValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]), jobScm.getDataEntity().get("number"));
            this.addFatalErrorMessage(jobScm, errorMsg);
        }
    }
}

