/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.utils.GroupKeyBuilder;
import kd.hrmp.hbjm.common.util.GroupKey;
import org.apache.commons.lang3.StringUtils;

public class MultilangUniqueValidator
extends AbstractValidator {
    private DataEntityPropertyCollection props;
    private String entityNumber;
    private Map<GroupKey, List<ExtendedDataEntity>> allBuildKeysMap;
    private Set<GroupKey> dbGroupKeys;
    protected String[] mulCols = new String[]{"name"};
    protected Lang[] supportMulTypes = new Lang[]{Lang.zh_CN, Lang.en_US, Lang.zh_TW};
    protected String errorInfo = ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MultilangUniqueValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
    protected ExtendedDataEntity[] needValideEntity;

    public MultilangUniqueValidator(ExtendedDataEntity[] needValideEntity) {
        this.needValideEntity = needValideEntity;
    }

    public MultilangUniqueValidator(ExtendedDataEntity[] needValideEntity, String[] mulCols, String errorInfo) {
        this.needValideEntity = needValideEntity;
        this.mulCols = mulCols;
        this.errorInfo = errorInfo;
    }

    public MultilangUniqueValidator() {
    }

    public void validate() {
        if (this.mulCols == null || this.mulCols.length <= 0) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.needValideEntity;
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        DynamicObject dy = dataEntities[0].getDataEntity();
        this.props = dy.getDataEntityType().getProperties();
        this.entityNumber = dy.getDataEntityType().getName();
        this.getEnabledLang();
        this.buildKeys();
        this.checkInDB();
        this.checkInMemory();
    }

    private void getEnabledLang() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        if (enabledLangList != null && enabledLangList.size() > 0) {
            Lang[] enabledLang = new Lang[enabledLangList.size()];
            for (int ii = 0; ii < enabledLangList.size(); ++ii) {
                enabledLang[ii] = Lang.from((String)((EnabledLang)enabledLangList.get((int)ii)).number);
            }
            this.supportMulTypes = enabledLang;
        }
    }

    private void buildKeys() {
        Map groupkeys;
        ExtendedDataEntity[] dataEntities = this.needValideEntity;
        GroupKeyBuilder build = GroupKeyBuilder.newInstance((ExtendedDataEntity[])dataEntities, Arrays.asList(this.mulCols));
        this.allBuildKeysMap = groupkeys = build.buildKeys();
    }

    protected void checkInDB() {
        if (this.allBuildKeysMap == null || this.allBuildKeysMap.size() <= 0) {
            return;
        }
        if (!this.hasMulCol(this.mulCols)) {
            return;
        }
        Map<String, Object> allDataMap = this.buildEmptyMap();
        this.dealAllEntityData(allDataMap);
        Map<String, QFilter> filterMap = this.buildFilters(allDataMap);
        List<DynamicObject> searchResult = this.getAllMulDataByFilter(filterMap);
        HashMap errorInfoMap = new HashMap(searchResult.size());
        if (searchResult != null && searchResult.size() > 0) {
            this.dbGroupKeys = new HashSet<GroupKey>(searchResult.size());
            for (DynamicObject data : searchResult) {
                GroupKey groupKey = GroupKeyBuilder.buildKey((int)0, (DynamicObject)data, Arrays.asList(this.mulCols), (DataEntityPropertyCollection)this.props);
                List<ExtendedDataEntity> entryValue = this.allBuildKeysMap.get(groupKey);
                if (entryValue != null && entryValue.size() > 0) {
                    entryValue.forEach(entry -> {
                        String er;
                        Long entityBoId = entry.getDataEntity().getLong("boid");
                        if ((entityBoId == 0L || entityBoId.longValue() != data.getLong("boid")) && HRStringUtils.isEmpty((String)(er = (String)errorInfoMap.get(entityBoId)))) {
                            errorInfoMap.put(entityBoId, this.errorInfo);
                        }
                    });
                }
                this.dbGroupKeys.add(groupKey);
            }
            if (errorInfoMap.size() > 0) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity entity : dataEntities = this.needValideEntity) {
                    DynamicObject entityData = entity.getDataEntity();
                    Long boid = entityData.getLong("boid");
                    String errorInfo = (String)errorInfoMap.get(boid);
                    if (!HRStringUtils.isNotEmpty((String)errorInfo)) continue;
                    this.buildErrorMessage(entity, errorInfo);
                }
            }
        }
    }

    protected void checkInMemory() {
        if (this.allBuildKeysMap == null || this.allBuildKeysMap.size() <= 0) {
            return;
        }
        for (Map.Entry<GroupKey, List<ExtendedDataEntity>> entry : this.allBuildKeysMap.entrySet()) {
            List<ExtendedDataEntity> entryValue = entry.getValue();
            if (entryValue == null || entryValue.size() <= 1 || this.dbGroupKeys != null && this.dbGroupKeys.contains(entry.getKey())) continue;
            for (int index = 1; index < entryValue.size(); ++index) {
                this.buildErrorMessage(entryValue.get(index), this.errorInfo);
            }
        }
    }

    private List<DynamicObject> distinctDataById(List<DynamicObject> searchResult) {
        ArrayList<DynamicObject> searchResult_tmp = new ArrayList<DynamicObject>(8);
        if (searchResult != null && searchResult.size() > 0) {
            Map<Long, List<DynamicObject>> tmpInfos = searchResult.stream().collect(Collectors.groupingBy(data -> data.getLong("id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : tmpInfos.entrySet()) {
                List<DynamicObject> tmpList = entry.getValue();
                if (tmpList == null || tmpList.size() <= 0) continue;
                searchResult_tmp.add(tmpList.get(0));
            }
        }
        return searchResult_tmp;
    }

    private List<DynamicObject> getAllMulDataByFilter(Map<String, QFilter> filterMap) {
        ArrayList<DynamicObject> searchResult = new ArrayList<DynamicObject>(8);
        for (Lang lang : this.supportMulTypes) {
            QFilter filter = filterMap.get(lang.toString());
            DynamicObjectCollection ormResult = this.getDataFromDb(lang, filter);
            if (ormResult == null || ormResult.size() <= 0) continue;
            searchResult.addAll((Collection<DynamicObject>)ormResult);
        }
        return searchResult;
    }

    private DynamicObjectCollection getDataFromDb(Lang lang, QFilter filter) {
        ORM orm = ORM.create();
        orm.hint().setLang(lang);
        DynamicObjectCollection ormResult = orm.query(this.getEntityNumber(), "id,number,boid," + StringUtils.join((Object[])this.mulCols, (String)","), new QFilter[]{filter});
        return ormResult;
    }

    private Map<String, QFilter> buildFilters(Map<String, Object> allDataMap) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(8);
        for (Object lang : this.supportMulTypes) {
            filterMap.put(lang.toString(), new QFilter("1", "=", (Object)1));
        }
        for (Map.Entry entry : allDataMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            if (value instanceof Map) {
                Lang[] mulMap = (Lang[])value;
                Lang[] langArray = this.supportMulTypes;
                int n = langArray.length;
                for (int i = 0; i < n; ++i) {
                    Lang lang = langArray[i];
                    List filterData = (List)mulMap.get((String)entry.getKey() + "." + lang.toString());
                    if (filterData == null || filterData.size() <= 0) continue;
                    QFilter filter = (QFilter)filterMap.get(lang.toString());
                    filter.and((String)entry.getKey(), "in", (Object)filterData);
                }
                continue;
            }
            for (Lang lang : this.supportMulTypes) {
                QFilter filter = (QFilter)filterMap.get(lang.toString());
                filter.and((String)entry.getKey(), "in", value);
            }
        }
        for (Object lang : this.supportMulTypes) {
            QFilter filter = (QFilter)filterMap.get(lang.toString());
            filter.and(this.getCommonFilter());
        }
        return filterMap;
    }

    protected QFilter getCommonFilter() {
        return null;
    }

    protected String getEntityNumber() {
        return this.entityNumber;
    }

    protected void buildErrorMessage(ExtendedDataEntity entity, String errorInfo) {
        this.addErrorMessage(entity, errorInfo);
    }

    private void dealAllEntityData(Map<String, Object> allDataMap) {
        for (ExtendedDataEntity entity : this.needValideEntity) {
            DynamicObject data = entity.getDataEntity();
            for (String col : this.mulCols) {
                Object[] values;
                IDataEntityProperty prop = (IDataEntityProperty)this.props.get((Object)col);
                if (prop == null || prop.isDbIgnore() || (values = GroupKeyBuilder.formatValue((IDataEntityProperty)prop, (Object)data.get(col), (DynamicObject)data)) == null || values.length <= 0) continue;
                Object propValue = values[0];
                if (propValue instanceof OrmLocaleValue) {
                    OrmLocaleValue info = (OrmLocaleValue)propValue;
                    Map mulMap = (Map)allDataMap.get(col);
                    for (Lang lang : this.supportMulTypes) {
                        List list = (List)mulMap.get(col + "." + lang.toString());
                        list.add(info.get((Object)lang.toString()));
                    }
                    continue;
                }
                List list = (List)allDataMap.get(col);
                list.add(propValue);
            }
        }
    }

    private Map<String, Object> buildEmptyMap() {
        HashMap<String, Object> allDataMap = new HashMap<String, Object>(8);
        for (String col : this.mulCols) {
            IDataEntityProperty prop = (IDataEntityProperty)this.props.get((Object)col);
            if (prop == null || prop.isDbIgnore()) continue;
            if (prop instanceof MuliLangTextProp) {
                HashMap mulMap = new HashMap(8);
                for (Lang lang : this.supportMulTypes) {
                    mulMap.put(col + "." + lang.toString(), new ArrayList());
                }
                allDataMap.put(col, mulMap);
                continue;
            }
            allDataMap.put(col, new ArrayList());
        }
        return allDataMap;
    }

    private boolean hasMulCol(String[] mulCols) {
        boolean hasMul = false;
        for (String col : mulCols) {
            IDataEntityProperty prop = (IDataEntityProperty)this.props.get((Object)col);
            if (!(prop instanceof MuliLangTextProp)) continue;
            hasMul = true;
            break;
        }
        return hasMul;
    }

    protected void setNeedValideData(ExtendedDataEntity[] needValideEntity) {
        this.needValideEntity = needValideEntity;
    }

    public void setMulCols(String[] mulCols) {
        this.mulCols = mulCols;
    }

    public void setSupportMulTypes(Lang[] supportMulTypes) {
        this.supportMulTypes = supportMulTypes;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }
}

