/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator.importinfo;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.service.IBaseValidatorService;
import kd.hrmp.hbjm.business.domain.service.impl.JobAbstractBaseValidatorService;

public class HbjmBaseChangeDataValidator
extends HRDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(HbjmBaseChangeDataValidator.class);
    private IBaseValidatorService valide = JobAbstractBaseValidatorService.getInstance();
    protected DynamicObject[] sourceDatas;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        this.doValidate();
    }

    protected void doValidate() {
        this.doBaseValidate();
        this.doExtendValidate();
    }

    protected void doBaseValidate() {
        LOGGER.info("HbjmBaseChangeDataValidator doBaseValidate start");
        List<Object> ids = Arrays.stream(this.dataEntities).map(data -> data.getDataEntity().getPkValue()).collect(Collectors.toList());
        this.sourceDatas = this.getSourceData(ids);
        this.valide.changeAllowAccessValde(this.dataEntities, this.sourceDatas, "createorg", data -> {
            String errorMsg = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"HbjmBaseChangeDataValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage((ExtendedDataEntity)data, errorMsg);
        });
        this.valide.changeAllowAccessValde(this.dataEntities, this.sourceDatas, "ctrlstrategy", data -> {
            String errorMsg = ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e0d\u5141\u8bb8\u53d8\u66f4\u5bfc\u5165\uff0c\u8bf7\u5728\u9875\u9762\u4e0a\u901a\u8fc7\u53d8\u66f4\u7ba1\u63a7\u7b56\u7565\u64cd\u4f5c\u8fdb\u884c\u53d8\u66f4\u5904\u7406\u3002", (String)"HbjmBaseChangeDataValidator_2", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage((ExtendedDataEntity)data, errorMsg);
        });
        LOGGER.info("HbjmBaseChangeDataValidator doBaseValidate end");
    }

    protected DynamicObject[] getSourceData(List<Object> ids) {
        return JobRepository.getInstance().loadBaseData(ids, this.getEntityKey());
    }

    protected void doExtendValidate() {
    }
}

