/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.opplugin.web.validator.importinfo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.cascadedata.JobCascadeDataValideApplicatioin;

public class JobCommonValidator {
    public static void doCascadeDataValidate(ExtendedDataEntity[] dataEntities, BiConsumer<ExtendedDataEntity, String> consumer) {
        List seqIds = Arrays.stream(dataEntities).map(data -> data.getDataEntity().get("jobseq.id")).collect(Collectors.toList());
        List familyIds = Arrays.stream(dataEntities).map(data -> data.getDataEntity().get("jobfamily.id")).collect(Collectors.toList());
        List classIds = Arrays.stream(dataEntities).map(data -> data.getDataEntity().get("jobclass.id")).collect(Collectors.toList());
        JobCascadeDataValideApplicatioin applicatioin = JobCascadeDataValideApplicatioin.createInstance();
        for (ExtendedDataEntity data2 : dataEntities) {
            DynamicObject dataEntity = data2.getDataEntity();
            if (applicatioin.valideJobSeqUnderScm(dataEntity.getString("jobscm.id"), dataEntity.getString("jobseq.id"), seqIds) && applicatioin.valideJobFamilyUnderScm(dataEntity.getString("jobscm.id"), dataEntity.getString("jobfamily.id"), familyIds) && applicatioin.valideJobClassUnderScm(dataEntity.getString("jobscm.id"), dataEntity.getString("jobclass.id"), classIds) && applicatioin.valideJobFamilyUnderSeq(dataEntity.getString("jobseq.id"), dataEntity.getString("jobfamily.id")) && applicatioin.valideJobClassUnderFamily(dataEntity.getString("jobfamily.id"), dataEntity.getString("jobclass.id"))) continue;
            String errorMsg = ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848/\u804c\u4f4d\u5e8f\u5217/\u804c\u4f4d\u65cf/\u804c\u4f4d\u7c7b\u7684\u5c42\u7ea7\u5173\u7cfb\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobCommonValidator_0", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            consumer.accept(data2, errorMsg);
        }
        applicatioin.close();
    }

    public static void doChangeTypeValidate(Long typeId, ExtendedDataEntity[] dataEntities, BiConsumer<ExtendedDataEntity, String> consumer) {
        HashMap<String, Boolean> cacheResult = new HashMap<String, Boolean>();
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject changeDesc = dataEntity.getDynamicObject("changedesc");
            if (ObjectUtils.isEmpty((Object)changeDesc)) continue;
            String changeDescId = String.valueOf(changeDesc.getPkValue());
            Boolean result = (Boolean)cacheResult.get(changeDescId);
            if (result == null) {
                DynamicObjectCollection types = changeDesc.getDynamicObjectCollection("changetype");
                if (!ObjectUtils.isEmpty((Object)types)) {
                    result = types.stream().anyMatch(type -> HRStringUtils.equals((String)String.valueOf(typeId), (String)String.valueOf(type.get("fbasedataid.id"))));
                }
                cacheResult.put(changeDescId, result);
            }
            Boolean bl = result = result == null ? Boolean.TRUE : result;
            if (result.booleanValue()) continue;
            String errorMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JobCommonValidator_1", (String)"hrmp-hbjm-opplugin", (Object[])new Object[0]);
            consumer.accept(data, errorMsg);
        }
    }
}

