/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.common.util.PermOrgQFilterUtil;
import kd.hrmp.hbjm.mservice.IHBJMBuPermissionService;

public class HBJMBuPermissionService
implements IHBJMBuPermissionService {
    public Map<Long, Map<String, List<Long>>> hasBuPermission(Map<Long, Map<String, List<Long>>> bu) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(bu)) {
            return result;
        }
        bu.forEach((buId, map) -> map.forEach((entity, lists) -> {
            List<Long> ids = this.getPermissionIds((Long)buId, (List<Long>)lists, (String)entity);
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            Map temp = (Map)result.get(buId);
            if (CollectionUtils.isEmpty((Map)temp)) {
                temp = Maps.newHashMap();
                result.put(buId, temp);
            }
            temp.put(entity, ids);
        }));
        return result;
    }

    private List<Long> getPermissionIds(Long bu, List<Long> ids, String entity) {
        if (bu == 0L || CollectionUtils.isEmpty(ids) || HRStringUtils.isEmpty((String)entity)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        QFilter filter = PermOrgQFilterUtil.assembleFilterByOr((String)entity, Collections.singletonList(bu));
        if (Objects.isNull(filter)) {
            return null;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "in", ids);
        Object[] dys = serviceHelper.queryOriginalArray("id", new QFilter[]{filter, enableFilter, idFilter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return null;
        }
        return Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }
}

