/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hrmp.hbjm.business.domain.repository.HBJMEventRepository;
import kd.hrmp.hbjm.business.domain.repository.HBJMHisRepository;
import kd.hrmp.hbjm.mservice.IHBJMEventService;

public class HBJMEventService
implements IHBJMEventService {
    public Map<String, Object> getJobInfoByEventId(long eventId) {
        DynamicObject[] opDetails = HBJMEventRepository.getInstance().selectOpDetail(eventId);
        if (opDetails == null || opDetails.length == 0) {
            return HBJMEventService.buildSuccessResult(200, "", null);
        }
        List boidList = Arrays.stream(opDetails).map(opDetail -> opDetail.getLong("job")).collect(Collectors.toList());
        DynamicObject[] jobs = HBJMHisRepository.getInstance().getJobCurrentVersionByBoid(boidList);
        return HBJMEventService.buildSuccessResult(200, "", jobs);
    }

    public Map<String, Object> getJobVersionChangeInfoByEventId(long eventId, long jobBoid) {
        DynamicObject[] opDetails = HBJMEventRepository.getInstance().selectOpDetail(eventId);
        if (opDetails == null || opDetails.length == 0) {
            return HBJMEventService.buildSuccessResult(200, "", null);
        }
        HashMap jobToVersionInfoMap = Maps.newHashMapWithExpectedSize((int)opDetails.length);
        Arrays.stream(opDetails).forEach(opDetail -> {
            long jobId = opDetail.getLong("job");
            if (jobBoid == 0L || jobBoid == jobId) {
                long beforeVersionId = opDetail.getLong("beforejob");
                long afterVersionId = opDetail.getLong("afterjob");
                DynamicObject beforeVerisonInfo = null;
                DynamicObject afterVerisonInfo = null;
                if (beforeVersionId != 0L) {
                    beforeVerisonInfo = HBJMHisRepository.getInstance().getJobVersionInfoByVersionId(beforeVersionId);
                }
                if (afterVersionId != 0L) {
                    afterVerisonInfo = HBJMHisRepository.getInstance().getJobVersionInfoByVersionId(afterVersionId);
                }
                HashMap versionInfoMap = Maps.newHashMapWithExpectedSize((int)8);
                versionInfoMap.put("before", beforeVerisonInfo);
                versionInfoMap.put("after", afterVerisonInfo);
                jobToVersionInfoMap.put(jobId, versionInfoMap);
            }
        });
        return HBJMEventService.buildSuccessResult(200, "", jobToVersionInfoMap);
    }

    private static Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }
}

