/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hbjm.business.domain.repository.HBJMHisRepository;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqRepository;
import kd.hrmp.hbjm.mservice.HBJMHisVerService;
import kd.hrmp.hbjm.mservice.IHBJMForPosHisService;

public class HBJMForPosHisService
implements IHBJMForPosHisService {
    private HRBaseServiceHelper jobhelper = new HRBaseServiceHelper("hbjm_jobhr");
    private Set<Long> usedJobId;

    public List<DynamicObject> setPositionJobHisInfo(List<DynamicObject> posDyns) {
        if (posDyns == null || posDyns.size() == 0) {
            return posDyns;
        }
        this.usedJobId = Sets.newHashSetWithExpectedSize((int)posDyns.size());
        List jobIds = posDyns.stream().filter(pos -> pos.getLong("job.id") != 0L).map(pos -> pos.getLong("job.id")).collect(Collectors.toList());
        DynamicObject[] jobDyns = HBJMHisRepository.getInstance().getJobHisByBoId(jobIds);
        Map<Long, List<DynamicObject>> jobBoIdDynMap = this.baseDataGroupByBoId(jobDyns);
        ArrayList jobseqIds = Lists.newArrayListWithExpectedSize((int)posDyns.size());
        ArrayList jobfamilyIds = Lists.newArrayListWithExpectedSize((int)posDyns.size());
        ArrayList jobclassIds = Lists.newArrayListWithExpectedSize((int)posDyns.size());
        for (DynamicObject pos2 : posDyns) {
            Date bsed = pos2.getDate("bsed");
            this.handleHisCoverCurrent(jobBoIdDynMap, pos2, "job", bsed);
            DynamicObject hisJob = pos2.getDynamicObject("job");
            if (hisJob == null) continue;
            this.addNotNullValue(jobseqIds, hisJob, "jobseq.id");
            this.addNotNullValue(jobfamilyIds, hisJob, "jobfamily.id");
            this.addNotNullValue(jobclassIds, hisJob, "jobclass.id");
        }
        DynamicObject[] jobSeqDyns = JobSeqRepository.getInstance().getJobSeqHisByBoId(jobseqIds.toArray(new Long[0]));
        DynamicObject[] jobFamilyDyns = JobFamilyRepository.getInstance().getJobFamilyHisByBoId(jobfamilyIds.toArray(new Long[0]));
        DynamicObject[] jobClassDyns = JobClassRepository.getInstance().getJobClassHisByBoId(jobclassIds.toArray(new Long[0]));
        Map<Long, List<DynamicObject>> jobSeqBoIdDynMap = this.baseDataGroupByBoId(jobSeqDyns);
        Map<Long, List<DynamicObject>> jobFamilyBoIdDynMap = this.baseDataGroupByBoId(jobFamilyDyns);
        Map<Long, List<DynamicObject>> jobClassBoIdDynMap = this.baseDataGroupByBoId(jobClassDyns);
        for (DynamicObject pos3 : posDyns) {
            DynamicObject hisJob = pos3.getDynamicObject("job");
            if (hisJob == null) continue;
            Date bsed = pos3.getDate("bsed");
            this.handleHisCoverCurrent(jobSeqBoIdDynMap, hisJob, "jobseq", bsed);
            this.handleHisCoverCurrent(jobFamilyBoIdDynMap, hisJob, "jobfamily", bsed);
            this.handleHisCoverCurrent(jobClassBoIdDynMap, hisJob, "jobclass", bsed);
        }
        HBJMHisVerService hbjmHisVerService = new HBJMHisVerService();
        hbjmHisVerService.handleJobLevelAndGradeHis(posDyns.toArray(new DynamicObject[0]));
        return posDyns;
    }

    private void addNotNullValue(List<Long> list, DynamicObject dyn, String key) {
        long value = dyn.getLong(key);
        if (value != 0L) {
            list.add(value);
        }
    }

    private Map<Long, List<DynamicObject>> baseDataGroupByBoId(DynamicObject[] dyns) {
        Map<Object, Object> boidToHisListMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        if (dyns.length > 0) {
            boidToHisListMap = Arrays.stream(dyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
        }
        return boidToHisListMap;
    }

    private void handleHisCoverCurrent(Map<Long, List<DynamicObject>> basedataBoIdDynMap, DynamicObject dyn, String basedataName, Date bsed) {
        DynamicObject currentData = dyn.getDynamicObject(basedataName);
        dyn.set(basedataName, null);
        if (bsed == null) {
            return;
        }
        if (currentData == null) {
            return;
        }
        long currentDataId = currentData.getLong("id");
        List<DynamicObject> hisDataList = basedataBoIdDynMap.get(currentDataId);
        if (hisDataList == null) {
            return;
        }
        for (DynamicObject hisData : hisDataList) {
            Date hisBsed = hisData.getDate("bsed");
            Date hisBsled = hisData.getDate("bsled");
            if (hisBsed == null || hisBsled == null || bsed.before(hisBsed) || bsed.after(hisBsled)) continue;
            if (basedataName.equals("job") && !this.usedJobId.add(hisData.getLong("id"))) {
                DynamicObject hisDataCopy = this.jobhelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)hisData, (DynamicObject)hisDataCopy, (boolean)true);
                hisDataCopy.set("id", (Object)hisData.getLong("id"));
                dyn.set(basedataName, (Object)hisDataCopy);
                break;
            }
            dyn.set(basedataName, (Object)hisData);
            break;
        }
    }
}

