/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.HBJMHisRepository;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobGradeScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobLevelScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqRepository;
import kd.hrmp.hbjm.mservice.IHBJMHisVerService;

public class HBJMHisVerService
implements IHBJMHisVerService {
    private static final String DATE_TYPE_EARLIEST = "0";
    private static final String DATE_TYPE_LATEST = "1";

    private static Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    public Map<String, Object> selectJobHisinfo(List<Long> boidList, Date time) {
        if (CollectionUtils.isEmpty(boidList) || Objects.isNull(time)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        DynamicObjectCollection jobdyncol = HBJMHisRepository.getInstance().getJobHis(boidList, time);
        List jobScmIdList = jobdyncol.stream().map(dyn -> dyn.getLong("jobscm.id")).collect(Collectors.toList());
        List jobFamilyIdList = jobdyncol.stream().map(dyn -> dyn.getLong("jobfamily.id")).collect(Collectors.toList());
        DynamicObject[] jobFamilyScmDynArr = JobFamilyScmRepository.getInstance().getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds(jobScmIdList, jobFamilyIdList);
        Map<String, DynamicObject> groupKeyVsDynMap = Arrays.stream(jobFamilyScmDynArr).collect(Collectors.toMap(dyn -> "" + dyn.getLong("jobscm.id") + dyn.getLong("jobfamily.id"), dyn -> dyn));
        ArrayList reslist = new ArrayList(jobdyncol.size());
        if (CollectionUtils.isEmpty((Collection)jobdyncol)) {
            return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        for (DynamicObject jobdyn : jobdyncol) {
            HashMap<String, Object> resmap = new HashMap<String, Object>(32);
            resmap.put("id", jobdyn.getString("id"));
            resmap.put("boid", jobdyn.getLong("boid"));
            resmap.put("number", jobdyn.getString("number"));
            resmap.put("name", jobdyn.getString("name"));
            resmap.put("createorg", jobdyn.getLong("createorg"));
            long jobScmId = jobdyn.getLong("jobscm.id");
            resmap.put("jobscmhrid", jobScmId);
            resmap.put("jobscmhrname", jobdyn.getString("jobscm.name"));
            resmap.put("jobscmhrnum", jobdyn.getString("jobscm.number"));
            resmap.put("jobseqhrname", jobdyn.getString("jobseq.name"));
            resmap.put("jobseqhrid", jobdyn.getLong("jobseq.id"));
            long jobFamilyId = jobdyn.getLong("jobfamily.id");
            resmap.put("jobfamilyhrid", jobFamilyId);
            resmap.put("jobfamilyhrname", jobdyn.getString("jobfamily.name"));
            resmap.put("jobclasshrid", jobdyn.getLong("jobclass.id"));
            resmap.put("jobclasshrname", jobdyn.getString("jobclass.name"));
            long jobGradeScmId = jobdyn.getLong("highjobgrade.jobgradescm.id");
            String groupKey = "" + jobScmId + jobFamilyId;
            if (jobGradeScmId == 0L) {
                DynamicObject jobFamilyScmDyn = groupKeyVsDynMap.get(groupKey);
                if (Objects.isNull(jobFamilyScmDyn)) {
                    resmap.put("jobgradescmid", jobdyn.getLong("highjobgrade.jobgradescm.id"));
                    resmap.put("jobgradescmname", jobdyn.getString("highjobgrade.jobgradescm.name"));
                    resmap.put("jobgradescmnumber", jobdyn.getString("highjobgrade.jobgradescm.number"));
                } else {
                    long jobGradeScmFromFamily = jobFamilyScmDyn.getLong("jobgradescm.id");
                    if (jobGradeScmFromFamily == 0L) {
                        resmap.put("jobgradescmid", jobdyn.getLong("jobscm.jobgradescm.id"));
                        resmap.put("jobgradescmname", jobdyn.getString("jobscm.jobgradescm.name"));
                        resmap.put("jobgradescmnumber", jobdyn.getString("jobscm.jobgradescm.number"));
                    } else {
                        resmap.put("jobgradescmid", jobFamilyScmDyn.getLong("jobgradescm.id"));
                        resmap.put("jobgradescmname", jobFamilyScmDyn.getString("jobgradescm.name"));
                        resmap.put("jobgradescmnumber", jobFamilyScmDyn.getString("jobgradescm.number"));
                    }
                }
            } else {
                resmap.put("jobgradescmid", jobdyn.getLong("highjobgrade.jobgradescm.id"));
                resmap.put("jobgradescmname", jobdyn.getString("highjobgrade.jobgradescm.name"));
                resmap.put("jobgradescmnumber", jobdyn.getString("highjobgrade.jobgradescm.number"));
            }
            resmap.put("highjobgradeid", jobdyn.getLong("highjobgrade.id"));
            resmap.put("highjobgradename", jobdyn.getString("highjobgrade.name"));
            resmap.put("lowjobgradeid", jobdyn.getLong("lowjobgrade.id"));
            resmap.put("lowjobgradename", jobdyn.getString("lowjobgrade.name"));
            long jobLevelScmId = jobdyn.getLong("highjoblevel.joblevelscm.id");
            if (jobLevelScmId == 0L) {
                DynamicObject jobFamilyScmDyn = groupKeyVsDynMap.get(groupKey);
                if (Objects.isNull(jobFamilyScmDyn)) {
                    resmap.put("joblevelscmid", jobdyn.getLong("highjoblevel.joblevelscm.id"));
                    resmap.put("joblevelscmname", jobdyn.getString("highjoblevel.joblevelscm.name"));
                    resmap.put("joblevelscmnumber", jobdyn.getString("highjoblevel.joblevelscm.number"));
                } else {
                    long jobLevelScmFromFamily = jobFamilyScmDyn.getLong("joblevelscm.id");
                    if (jobLevelScmFromFamily == 0L) {
                        resmap.put("joblevelscmid", jobdyn.getLong("jobscm.joblevelscm.id"));
                        resmap.put("joblevelscmname", jobdyn.getString("jobscm.joblevelscm.name"));
                        resmap.put("joblevelscmnumber", jobdyn.getString("jobscm.joblevelscm.number"));
                    } else {
                        resmap.put("joblevelscmid", jobFamilyScmDyn.getLong("joblevelscm.id"));
                        resmap.put("joblevelscmname", jobFamilyScmDyn.getString("joblevelscm.name"));
                        resmap.put("joblevelscmnumber", jobFamilyScmDyn.getString("joblevelscm.number"));
                    }
                }
            } else {
                resmap.put("joblevelscmid", jobdyn.getLong("highjoblevel.joblevelscm.id"));
                resmap.put("joblevelscmname", jobdyn.getString("highjoblevel.joblevelscm.name"));
                resmap.put("joblevelscmnumber", jobdyn.getString("highjoblevel.joblevelscm.number"));
            }
            resmap.put("highjoblevelid", jobdyn.getLong("highjoblevel.id"));
            resmap.put("highjoblevelname", jobdyn.getString("highjoblevel.name"));
            resmap.put("lowjoblevelid", jobdyn.getLong("lowjoblevel.id"));
            resmap.put("lowjoblevelname", jobdyn.getString("lowjoblevel.name"));
            resmap.put("createorgname", jobdyn.getString("createorg.name"));
            resmap.put("createorgnum", jobdyn.getString("createorg.number"));
            reslist.add(resmap);
        }
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), reslist);
    }

    public Map<String, Object> queryJobHisSimpleInfo(List<String> numberList, Date time) {
        if (CollectionUtils.isEmpty(numberList)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        if (numberList.size() > 5000) {
            return HBJMHisVerService.buildSuccessResult(202, ResManager.loadKDString((String)"\u67e5\u8be2\u7f16\u7801\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc75000\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HBJMHisVerService_2", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        if (time == null) {
            time = new Date();
        }
        DynamicObjectCollection jobdyncol = HBJMHisRepository.getInstance().getJobHisSimpleInfo(numberList, time);
        DynamicObject[] jobFirstBseds = HBJMHisRepository.getInstance().getJobFirstBsedByNumber(numberList);
        Map<Object, Object> idToFirstBsedMap = new HashMap(16);
        if (jobFirstBseds != null) {
            idToFirstBsedMap = Arrays.asList(jobFirstBseds).stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("firstbsed")));
        }
        for (DynamicObject jobdyn : jobdyncol) {
            if (idToFirstBsedMap.get(jobdyn.getLong("boid")) == null) continue;
            jobdyn.set("firstbsed", idToFirstBsedMap.get(jobdyn.getLong("boid")));
        }
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), jobdyncol);
    }

    public Map<String, Object> queryJobHisAndRefHis(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        if (idList.size() > 500) {
            return HBJMHisVerService.buildSuccessResult(202, ResManager.loadKDString((String)"\u67e5\u8be2\u804c\u4f4d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7500\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HBJMHisVerService_3", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        DynamicObject[] jobdyns = HBJMHisRepository.getInstance().getJobHisById(idList);
        this.handleJobHis(jobdyns);
        this.handleJobLevelAndGradeHis(jobdyns);
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), jobdyns);
    }

    public void handleJobHis(DynamicObject[] jobdyns) {
        HashMap<Long, Date> jobBsedMap = new HashMap<Long, Date>(jobdyns.length);
        HashMap<Long, Long> jobSeqMap = new HashMap<Long, Long>(jobdyns.length);
        HashMap<Long, Long> jobFamilyMap = new HashMap<Long, Long>(jobdyns.length);
        HashMap<Long, Long> jobClassMap = new HashMap<Long, Long>(jobdyns.length);
        List<String> jobSeqFileds = null;
        List<String> jobFamilyFileds = null;
        List<String> jobClassFileds = null;
        for (DynamicObject job : jobdyns) {
            if (jobSeqFileds == null && job.getDynamicObject("jobseq") != null) {
                jobSeqFileds = this.getBaseDataQueryFiled(job.getDynamicObject("jobseq"));
            }
            if (jobFamilyFileds == null && job.getDynamicObject("jobfamily") != null) {
                jobFamilyFileds = this.getBaseDataQueryFiled(job.getDynamicObject("jobfamily"));
            }
            if (jobClassFileds == null && job.getDynamicObject("jobclass") != null) {
                jobClassFileds = this.getBaseDataQueryFiled(job.getDynamicObject("jobclass"));
            }
            jobBsedMap.put(job.getLong("id"), job.getDate("bsed"));
            jobSeqMap.put(job.getLong("id"), job.getLong("jobseq_id"));
            jobFamilyMap.put(job.getLong("id"), job.getLong("jobfamily_id"));
            jobClassMap.put(job.getLong("id"), job.getLong("jobclass_id"));
        }
        DynamicObject[] jobSeqDyns = JobSeqRepository.getInstance().getJobSeqHisByBoId(jobSeqMap.values().toArray(new Long[0]));
        DynamicObject[] jobFamilyDyns = JobFamilyRepository.getInstance().getJobFamilyHisByBoId(jobFamilyMap.values().toArray(new Long[0]));
        DynamicObject[] jobClassDyns = JobClassRepository.getInstance().getJobClassHisByBoId(jobClassMap.values().toArray(new Long[0]));
        Map<Long, List<DynamicObject>> jobSeqBoIdDynMap = this.baseDataGroupByBoId(jobSeqDyns);
        Map<Long, List<DynamicObject>> jobFamilyBoIdDynMap = this.baseDataGroupByBoId(jobFamilyDyns);
        Map<Long, List<DynamicObject>> jobClassBoIdDynMap = this.baseDataGroupByBoId(jobClassDyns);
        for (DynamicObject job : jobdyns) {
            this.handleHisCoverCurrent(jobBsedMap, jobSeqMap, jobSeqFileds, jobSeqBoIdDynMap, job, "jobseq");
            this.handleHisCoverCurrent(jobBsedMap, jobFamilyMap, jobFamilyFileds, jobFamilyBoIdDynMap, job, "jobfamily");
            this.handleHisCoverCurrent(jobBsedMap, jobClassMap, jobClassFileds, jobClassBoIdDynMap, job, "jobclass");
        }
    }

    public void handleJobLevelAndGradeHis(DynamicObject[] dyns) {
        HashMap<Long, Date> dynBsedMap = new HashMap<Long, Date>(dyns.length);
        HashMap<Long, Long> highJobGradeEntryBoIdMap = new HashMap<Long, Long>(dyns.length);
        HashMap<Long, Long> lowJobGradeEntryBoIdMap = new HashMap<Long, Long>(dyns.length);
        HashMap<Long, Long> highJobLevelEntryBoIdMap = new HashMap<Long, Long>(dyns.length);
        HashMap<Long, Long> lowJobLevelEntryBoIdMap = new HashMap<Long, Long>(dyns.length);
        HashSet<Long> jobGradeIds = new HashSet<Long>(dyns.length);
        HashSet<Long> jobLevelIds = new HashSet<Long>(dyns.length);
        for (DynamicObject dyn : dyns) {
            dynBsedMap.put(dyn.getLong("id"), dyn.getDate("bsed"));
            DynamicObject highJobGrade = dyn.getDynamicObject("highjobgrade");
            DynamicObject lowJobGrade = dyn.getDynamicObject("lowjobgrade");
            DynamicObject highJobLevel = dyn.getDynamicObject("highjoblevel");
            DynamicObject lowJobLevel = dyn.getDynamicObject("lowjoblevel");
            this.buildJobGradeOrLevelQueryParam(highJobGradeEntryBoIdMap, jobGradeIds, dyn, highJobGrade);
            this.buildJobGradeOrLevelQueryParam(lowJobGradeEntryBoIdMap, jobGradeIds, dyn, lowJobGrade);
            this.buildJobGradeOrLevelQueryParam(highJobLevelEntryBoIdMap, jobLevelIds, dyn, highJobLevel);
            this.buildJobGradeOrLevelQueryParam(lowJobLevelEntryBoIdMap, jobLevelIds, dyn, lowJobLevel);
        }
        DynamicObject[] jobGradeDyns = JobGradeScmRepository.getInstance().getJobGradeById(jobGradeIds);
        Map<Long, Long> jobGradeIdAGradeScmIdMap = Arrays.stream(jobGradeDyns).collect(Collectors.toMap(jobGrade -> jobGrade.getLong("id"), jobGrade -> jobGrade.getLong("jobgradescm_id")));
        DynamicObject[] jobGradeScmDyns = JobGradeScmRepository.getInstance().getJobGradeScmByBoId(jobGradeIdAGradeScmIdMap.values().toArray(new Long[0]));
        Map<Long, List<DynamicObject>> jobGradeBoIdDynMap = this.baseDataGroupByBoId(jobGradeScmDyns);
        DynamicObject[] jobLevelDyns = JobLevelScmRepository.getInstance().getJobLevelById(jobLevelIds);
        Map<Long, Long> jobLevelIdALevelScmIdMap = Arrays.stream(jobLevelDyns).collect(Collectors.toMap(jobLevel -> jobLevel.getLong("id"), jobLevel -> jobLevel.getLong("joblevelscm_id")));
        DynamicObject[] jobLevelScmDyns = JobLevelScmRepository.getInstance().getJobLevelScmByBoId(jobLevelIdALevelScmIdMap.values().toArray(new Long[0]));
        Map<Long, List<DynamicObject>> jobLevelBoIdDynMap = this.baseDataGroupByBoId(jobLevelScmDyns);
        for (DynamicObject dyn : dyns) {
            this.handleJobGradeHisCoverCurrent(dynBsedMap, highJobGradeEntryBoIdMap, lowJobGradeEntryBoIdMap, jobGradeIdAGradeScmIdMap, jobGradeBoIdDynMap, dyn);
            this.handleJobLevelHisCoverCurrent(dynBsedMap, highJobLevelEntryBoIdMap, lowJobLevelEntryBoIdMap, jobLevelIdALevelScmIdMap, jobLevelBoIdDynMap, dyn);
        }
    }

    public Map<String, Object> selectSeqHisinfo(List<Long> boidList, Date time) {
        if (CollectionUtils.isEmpty(boidList) || Objects.isNull(time)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        String entityname = "hbjm_jobseqhr";
        DynamicObjectCollection jobdyncol = HBJMHisRepository.getInstance().getNumAndNameList(boidList, time, entityname);
        if (CollectionUtils.isEmpty((Collection)jobdyncol)) {
            return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        ArrayList reslist = new ArrayList(jobdyncol.size());
        for (DynamicObject jobdyn : jobdyncol) {
            HashMap<String, Object> resmap = new HashMap<String, Object>(8);
            resmap.put("id", jobdyn.getString("id"));
            resmap.put("boid", jobdyn.getLong("boid"));
            resmap.put("number", jobdyn.getString("number"));
            resmap.put("name", jobdyn.getString("name"));
            reslist.add(resmap);
        }
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), reslist);
    }

    public Map<String, Object> selectFamHisinfo(List<Long> boidList, Date time) {
        if (CollectionUtils.isEmpty(boidList) || Objects.isNull(time)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        String entityname = "hbjm_jobfamilyhr";
        DynamicObjectCollection jobdyncol = HBJMHisRepository.getInstance().getFamilyInfo(boidList, time, entityname);
        ArrayList reslist = new ArrayList(jobdyncol.size());
        if (CollectionUtils.isEmpty((Collection)jobdyncol)) {
            return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        for (DynamicObject jobdyn : jobdyncol) {
            HashMap<String, Object> resmap = new HashMap<String, Object>(8);
            resmap.put("id", jobdyn.getString("id"));
            resmap.put("boid", jobdyn.getLong("boid"));
            resmap.put("number", jobdyn.getString("number"));
            resmap.put("name", jobdyn.getString("name"));
            resmap.put("jobseqhrid", jobdyn.getLong("jobseq.id"));
            resmap.put("jobseqhrname", jobdyn.getString("jobseq.name"));
            reslist.add(resmap);
        }
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), reslist);
    }

    public Map<String, Object> selectClassHisinfo(List<Long> boidList, Date time) {
        if (CollectionUtils.isEmpty(boidList) || Objects.isNull(time)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        String entityname = "hbjm_jobclasshr";
        DynamicObjectCollection jobdyncol = HBJMHisRepository.getInstance().getHbjmClassInfo(boidList, time, entityname);
        ArrayList reslist = new ArrayList(jobdyncol.size());
        if (CollectionUtils.isEmpty((Collection)jobdyncol)) {
            return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        for (DynamicObject jobdyn : jobdyncol) {
            HashMap<String, Object> resmap = new HashMap<String, Object>(16);
            resmap.put("id", jobdyn.getString("id"));
            resmap.put("boid", jobdyn.getLong("boid"));
            resmap.put("number", jobdyn.getString("number"));
            resmap.put("name", jobdyn.getString("name"));
            resmap.put("jobfamilyhrid", jobdyn.getLong("jobfamily.id"));
            resmap.put("jobfamilyhrname", jobdyn.getString("jobfamily.name"));
            resmap.put("parent", jobdyn.getLong("parent.id"));
            resmap.put("parentname", jobdyn.getString("parent.name"));
            resmap.put("jobseqhrid", jobdyn.getLong("jobseq.id"));
            resmap.put("jobseqhrname", jobdyn.getString("jobseq.name"));
            resmap.put("jobclasslevel", jobdyn.getLong("jobclasslevel"));
            reslist.add(resmap);
        }
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), reslist);
    }

    public Map<String, Object> selectGradeHisinfo(List<Long> boidList, Date time) {
        if (CollectionUtils.isEmpty(boidList) || Objects.isNull(time)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        String entityname = "hbjm_jobgradehr";
        List reslist = HBJMHisRepository.getInstance().getGradeInfo(boidList, time, entityname);
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), reslist);
    }

    public Map<String, Object> selectLevelHisinfo(List<Long> idList, Date time) {
        if (CollectionUtils.isEmpty(idList) || Objects.isNull(time)) {
            return HBJMHisVerService.buildSuccessResult(201, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HBJMHisVerService_0", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), null);
        }
        String entityname = "hbjm_joblevelhr";
        List reslist = HBJMHisRepository.getInstance().getLevelInfo(idList, time, entityname);
        return HBJMHisVerService.buildSuccessResult(200, ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HBJMHisVerService_1", (String)"hrmp-hbjm-mservice", (Object[])new Object[0]), reslist);
    }

    public Map<String, Object> selectJobHisVersionInfo(Map<Long, List<Date>> idVsDateListMap) {
        if (CollectionUtils.isEmpty(idVsDateListMap)) {
            return HBJMHisVerService.buildSuccessResult(201, "idVsDateMap is empty", null);
        }
        int mapSize = idVsDateListMap.size();
        if (mapSize > 5000) {
            return HBJMHisVerService.buildSuccessResult(201, "idVsDateMap size > 5000", null);
        }
        Date earliestDate = this.getDateByType(idVsDateListMap, DATE_TYPE_EARLIEST);
        Date latestDate = this.getDateByType(idVsDateListMap, DATE_TYPE_LATEST);
        DynamicObject[] jobHisDyns = JobRepository.getInstance().queryJobHisInfos(idVsDateListMap.keySet(), earliestDate, latestDate);
        Map<Long, List<DynamicObject>> jobBoIdVsDynListMap = Arrays.stream(jobHisDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)idVsDateListMap.size());
        Set<Map.Entry<Long, List<Date>>> entries = idVsDateListMap.entrySet();
        Date now = new Date();
        for (Map.Entry<Long, List<Date>> idVsDateListEntry : entries) {
            Long jobBoId = idVsDateListEntry.getKey();
            List<DynamicObject> jobDynList = jobBoIdVsDynListMap.get(jobBoId);
            List<Date> dateList = idVsDateListEntry.getValue();
            if (CollectionUtils.isEmpty(dateList)) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)8);
                map.put("boId", jobBoId);
                map.put("searchTime", now);
                if (CollectionUtils.isEmpty(jobDynList)) {
                    map.put("flag", false);
                } else {
                    Date date = HRDateTimeUtils.truncateDate((Date)now);
                    this.putReturnValue(jobDynList, map, date);
                }
                list.add(map);
                continue;
            }
            for (Date date : dateList) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)8);
                map.put("boId", jobBoId);
                map.put("searchTime", date);
                if (CollectionUtils.isEmpty(jobDynList)) {
                    map.put("flag", false);
                } else {
                    date = HRDateTimeUtils.truncateDate((Date)date);
                    this.putReturnValue(jobDynList, map, date);
                }
                list.add(map);
            }
        }
        return HBJMHisVerService.buildSuccessResult(200, "", list);
    }

    private void putReturnValue(List<DynamicObject> jobDynList, Map<String, Object> map, Date date) {
        DynamicObject targetDyn = this.findTargetDyn(jobDynList, date);
        if (Objects.isNull(targetDyn)) {
            map.put("flag", false);
        } else {
            map.put("flag", true);
            map.put("id", targetDyn.getLong("id"));
            map.put("name", targetDyn.getString("name"));
            map.put("number", targetDyn.getString("number"));
            map.put("createOrg", targetDyn.getLong("createorg.id"));
        }
    }

    private DynamicObject findTargetDyn(List<DynamicObject> jobDynList, Date date) {
        for (DynamicObject jobDyn : jobDynList) {
            Date bsed = jobDyn.getDate("bsed");
            Date bsled = jobDyn.getDate("bsled");
            if (HRDateTimeUtils.dayBefore((Date)date, (Date)bsed) || HRDateTimeUtils.dayAfter((Date)date, (Date)bsled)) continue;
            return jobDyn;
        }
        return null;
    }

    private Date getDateByType(Map<Long, List<Date>> idVsDateListMap, String type) {
        Set<Map.Entry<Long, List<Date>>> entries = idVsDateListMap.entrySet();
        Date latestOrEarliestDate = null;
        for (Map.Entry<Long, List<Date>> entry : entries) {
            List<Date> dateList = entry.getValue();
            Date now = new Date();
            if (CollectionUtils.isEmpty(dateList)) {
                if (!this.isCanReplaceLatestDate(type, latestOrEarliestDate, now) && !this.isCanReplaceEarliestDate(type, latestOrEarliestDate, now)) continue;
                latestOrEarliestDate = now;
                continue;
            }
            for (Date date : dateList) {
                if (Objects.isNull(latestOrEarliestDate)) {
                    latestOrEarliestDate = date;
                    continue;
                }
                if (this.isCanReplaceLatestDate(type, latestOrEarliestDate, date)) {
                    latestOrEarliestDate = date;
                    continue;
                }
                if (!this.isCanReplaceEarliestDate(type, latestOrEarliestDate, date)) continue;
                latestOrEarliestDate = date;
            }
        }
        return HRDateTimeUtils.truncateDate(latestOrEarliestDate);
    }

    private boolean isCanReplaceEarliestDate(String type, Date latestOrEarliestDate, Date date) {
        return HRStringUtils.equals((String)type, (String)DATE_TYPE_EARLIEST) && (Objects.isNull(latestOrEarliestDate) || HRDateTimeUtils.dayBefore((Date)date, (Date)latestOrEarliestDate));
    }

    private boolean isCanReplaceLatestDate(String type, Date latestOrEarliestDate, Date date) {
        return HRStringUtils.equals((String)type, (String)DATE_TYPE_LATEST) && (Objects.isNull(latestOrEarliestDate) || HRDateTimeUtils.dayAfter((Date)date, (Date)latestOrEarliestDate));
    }

    private void handleHisCoverCurrent(Map<Long, Date> jobBsedMap, Map<Long, Long> jobBasedataBoIdMap, List<String> basedataFileds, Map<Long, List<DynamicObject>> basedataBoIdDynMap, DynamicObject job, String basedataName) {
        Long jobId = job.getLong("id");
        if (basedataBoIdDynMap != null && basedataBoIdDynMap.containsKey(jobBasedataBoIdMap.get(jobId))) {
            List<DynamicObject> basedataHisList = basedataBoIdDynMap.get(jobBasedataBoIdMap.get(jobId));
            for (DynamicObject basedataHis : basedataHisList) {
                Date bsed = basedataHis.getDate("bsed");
                Date bsled = basedataHis.getDate("bsled");
                if (!jobBsedMap.get(jobId).after(bsed) || !jobBsedMap.get(jobId).before(bsled)) continue;
                this.hisCoverCur(basedataFileds, job.getDynamicObject(basedataName), basedataHis);
                break;
            }
        }
    }

    private List<String> getBaseDataQueryFiled(DynamicObject basedata) {
        return basedata.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
    }

    private void hisCoverCur(List<String> refFileds, DynamicObject origin, DynamicObject target) {
        for (String filed : refFileds) {
            origin.set(filed, target.get(filed));
        }
    }

    private Map<Long, List<DynamicObject>> baseDataGroupByBoId(DynamicObject[] jobSeqDyns) {
        Map<Long, List<DynamicObject>> jobSeqIdDynMap = null;
        if (jobSeqDyns.length > 0) {
            jobSeqIdDynMap = Arrays.stream(jobSeqDyns).collect(Collectors.groupingBy(jobSeq -> jobSeq.getLong("boid")));
        }
        return jobSeqIdDynMap;
    }

    private void handleJobLevelHisCoverCurrent(Map<Long, Date> jobBsedMap, Map<Long, Long> highJobLevelEntryBoIdMap, Map<Long, Long> lowJobLevelEntryBoIdMap, Map<Long, Long> jobLevelIdALevelScmIdMap, Map<Long, List<DynamicObject>> jobLevelBoIdDynMap, DynamicObject job) {
        Long jobId = job.getLong("id");
        DynamicObject curHighJobLevel = job.getDynamicObject("highjoblevel");
        DynamicObject curLowJobLevel = job.getDynamicObject("lowjoblevel");
        if (curHighJobLevel != null && curLowJobLevel != null) {
            List<DynamicObject> jobLevelScmHisList;
            Long jobLevelScmId = jobLevelIdALevelScmIdMap.get(job.getLong("highjoblevel_id"));
            if (jobLevelBoIdDynMap != null && jobLevelScmId != null && (jobLevelScmHisList = jobLevelBoIdDynMap.get(jobLevelScmId)) != null && jobLevelScmHisList.size() > 0) {
                for (DynamicObject jobLevelScmHis : jobLevelScmHisList) {
                    Date bsed = jobLevelScmHis.getDate("bsed");
                    Date bsled = jobLevelScmHis.getDate("bsled");
                    if (jobBsedMap.get(jobId).before(bsed) || jobBsedMap.get(jobId).after(bsled)) continue;
                    DynamicObjectCollection hisJobLevelList = jobLevelScmHis.getDynamicObjectCollection("entryentity");
                    for (DynamicObject hisJobLevel : hisJobLevelList) {
                        this.jobLevelHisCoverCur(highJobLevelEntryBoIdMap, jobId, curHighJobLevel, hisJobLevel);
                        this.jobLevelHisCoverCur(lowJobLevelEntryBoIdMap, jobId, curLowJobLevel, hisJobLevel);
                    }
                }
            }
        }
    }

    private void handleJobGradeHisCoverCurrent(Map<Long, Date> jobBsedMap, Map<Long, Long> highJobGradeEntryBoIdMap, Map<Long, Long> lowJobGradeEntryBoIdMap, Map<Long, Long> jobGradeIdAGradeScmIdMap, Map<Long, List<DynamicObject>> jobGradeBoIdDynMap, DynamicObject dyn) {
        Long id = dyn.getLong("id");
        DynamicObject curHighJobGrade = dyn.getDynamicObject("highjobgrade");
        DynamicObject curLowJobGrade = dyn.getDynamicObject("lowjobgrade");
        if (curHighJobGrade != null && curLowJobGrade != null) {
            List<DynamicObject> jobGradeScmHisList;
            Long jobGradeScmId = jobGradeIdAGradeScmIdMap.get(dyn.getLong("highjobgrade_id"));
            if (jobGradeBoIdDynMap != null && jobGradeScmId != null && (jobGradeScmHisList = jobGradeBoIdDynMap.get(jobGradeScmId)) != null && jobGradeScmHisList.size() > 0) {
                for (DynamicObject jobGradeScmHis : jobGradeScmHisList) {
                    Date bsed = jobGradeScmHis.getDate("bsed");
                    Date bsled = jobGradeScmHis.getDate("bsled");
                    if (jobBsedMap.get(id).before(bsed) || jobBsedMap.get(id).after(bsled)) continue;
                    DynamicObjectCollection hisJobGradeList = jobGradeScmHis.getDynamicObjectCollection("entryentity");
                    for (DynamicObject hisJobGrade : hisJobGradeList) {
                        this.jobGradeHisCoverCur(highJobGradeEntryBoIdMap, id, curHighJobGrade, hisJobGrade);
                        this.jobGradeHisCoverCur(lowJobGradeEntryBoIdMap, id, curLowJobGrade, hisJobGrade);
                    }
                }
            }
        }
    }

    private void jobGradeHisCoverCur(Map<Long, Long> JobGradeEntryBoIdMap, Long jobId, DynamicObject curJobGrade, DynamicObject hisJobGrade) {
        if (hisJobGrade.getLong("entryboid") == JobGradeEntryBoIdMap.get(jobId).longValue()) {
            curJobGrade.set("id", (Object)hisJobGrade.getLong("id"));
            curJobGrade.set("name", (Object)hisJobGrade.getLocaleString("jobgrade_name"));
            curJobGrade.set("number", (Object)hisJobGrade.getString("jobgrade_number"));
            curJobGrade.set("jobgradeseq", (Object)hisJobGrade.getInt("jobgrade_seq"));
        }
    }

    private void jobLevelHisCoverCur(Map<Long, Long> JobLevelEntryBoIdMap, Long jobId, DynamicObject curJobLevel, DynamicObject hisJobLevel) {
        if (hisJobLevel.getLong("entryboid") == JobLevelEntryBoIdMap.get(jobId).longValue()) {
            curJobLevel.set("id", (Object)hisJobLevel.getLong("id"));
            curJobLevel.set("name", (Object)hisJobLevel.getLocaleString("joblevel_name"));
            curJobLevel.set("number", (Object)hisJobLevel.getString("joblevel_number"));
            curJobLevel.set("joblevelseq", (Object)hisJobLevel.getInt("joblevel_seq"));
        }
    }

    private void buildJobGradeOrLevelQueryParam(Map<Long, Long> numberMap, Set<Long> jobGradeOrLevelIds, DynamicObject dyn, DynamicObject jobGradeOrLevel) {
        if (jobGradeOrLevel != null) {
            jobGradeOrLevelIds.add(jobGradeOrLevel.getLong("id"));
            numberMap.put(dyn.getLong("id"), jobGradeOrLevel.getLong("entryboid"));
        }
    }
}

