/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.tree.TreeNode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.HBJMHisRepository;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.utils.JobTreeBuildUtil;
import kd.hrmp.hbjm.mservice.IHBJMJobClassService;

public class HBJMJobClassService
implements IHBJMJobClassService {
    private static final String SPLIT = "#";
    private static final char SPLIT_CHAR = '#';

    public Map<Long, String> getJobClassLongNameByJobAndBsed(List<Long> jobBoIdList, Date bsed) {
        DynamicObjectCollection jobdyncol = HBJMHisRepository.getInstance().getJobHis(jobBoIdList, bsed, "id,boid,jobfamily.id,jobclass.id");
        List jobFamilyIdList = jobdyncol.stream().map(dyn -> dyn.getLong("jobfamily.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> boidToHisDynMap = jobdyncol.stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn, (v1, v2) -> v1));
        DynamicObject[] jobClass = JobClassRepository.getInstance().getJobClassHisByFamilyBoId(jobFamilyIdList, "id,boid,name,jobfamily.id,parent.id,jobclasslevel");
        TreeNode root = this.buildTree(jobClass);
        HashMap jobToLongJobClassNameMap = Maps.newHashMapWithExpectedSize((int)jobBoIdList.size());
        for (Long jobBoId : jobBoIdList) {
            long jobclassId;
            long jobfamilyId;
            jobToLongJobClassNameMap.put(jobBoId, "");
            DynamicObject jobHis = boidToHisDynMap.get(jobBoId);
            if (jobHis == null || (jobfamilyId = jobHis.getLong("jobfamily.id")) == 0L || (jobclassId = jobHis.getLong("jobclass.id")) == 0L) continue;
            String pathStr = "01010#2" + jobfamilyId + '#';
            List childPath = root.getChildPathNodes(pathStr + "3" + jobclassId);
            String name = childPath.stream().filter(treeNode -> treeNode.getId().contains(pathStr)).map(TreeNode::getText).collect(Collectors.joining("-"));
            jobToLongJobClassNameMap.put(jobBoId, name);
        }
        return jobToLongJobClassNameMap;
    }

    private TreeNode buildTree(DynamicObject[] jobClassDys) {
        HashMap<String, TreeNode> treeNodes = new HashMap<String, TreeNode>();
        String rootId = this.buildFullNodeId("", "0", "1010", treeNodes);
        TreeNode root = new TreeNode("", rootId, "");
        treeNodes.put("1010", root);
        List jobClassDysSorted = Arrays.stream(jobClassDys).sorted(Comparator.comparing(jobclass -> jobclass.getInt("jobclasslevel"))).collect(Collectors.toList());
        for (DynamicObject classDy : jobClassDysSorted) {
            DynamicObject classFamily = classDy.getDynamicObject("jobfamily");
            if (ObjectUtils.isEmpty((Object)classFamily)) continue;
            Long classFamilyId = classFamily.getLong("id");
            JobTreeBuildUtil.appendNode(treeNodes, (String)"1010", (String)String.valueOf(classFamilyId), parentNode -> {
                String name = classFamily.getString("name");
                String currentNodeId = this.buildFullNodeId("1010", "2", String.valueOf(classFamilyId), treeNodes);
                TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                return node;
            });
            long parentClassId = classDy.getLong("parent.id");
            Long parentId = parentClassId == 0L ? classFamilyId : parentClassId;
            Long id = classDy.getLong("boid");
            JobTreeBuildUtil.appendNode(treeNodes, (String)String.valueOf(parentId), (String)String.valueOf(id), parentNode -> {
                String name = classDy.getString("name");
                String currentNodeId = this.buildFullNodeId(String.valueOf(parentId), "3", String.valueOf(id), treeNodes);
                TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                return node;
            });
        }
        return (TreeNode)treeNodes.get("1010");
    }

    private String buildFullNodeId(String parentId, String sign, String currentId, Map<String, TreeNode> treeNodes) {
        TreeNode parentNode = treeNodes.get(parentId);
        String parentNodeId = "";
        if (parentNode != null) {
            parentNodeId = treeNodes.get(parentId).getId();
            if (parentNodeId.contains("#3") && HRStringUtils.equals((String)"3", (String)sign)) {
                return parentNodeId.replace(parentId, currentId);
            }
            return parentNodeId + SPLIT + sign + currentId;
        }
        return sign + currentId;
    }
}

