/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hrmp.hbjm.business.domain.repository.JobGradeScmRepository;
import kd.hrmp.hbjm.common.util.PermOrgQFilterUtil;
import kd.hrmp.hbjm.common.util.ResultUtil;
import kd.hrmp.hbjm.mservice.HBJMJobLevelOrGradeServiceHelper;
import kd.hrmp.hbjm.mservice.IHBJMJobGradeScmService;

public class HBJMJobGradeScmService
implements IHBJMJobGradeScmService {
    public Map<String, Object> getJobGradeScmIdByNumberMap(Set<String> numberSet) {
        Map<String, Object> resultMap = HBJMJobLevelOrGradeServiceHelper.validateInputData(numberSet);
        if (resultMap != null) {
            return resultMap;
        }
        List<Map<String, Object>> mapList = HBJMJobLevelOrGradeServiceHelper.packageNumberVsBoIdMapData(numberSet, "hbjm_jobgradescmhr");
        return ResultUtil.buildSuccessResult((int)200, (String)"", mapList);
    }

    public Map<String, Object> hasPermJobGradeScmIds(Set<Long> ids, QFilter permFilter) {
        if (ids == null || ids.isEmpty()) {
            return ResultUtil.buildSuccessResult((int)201, (String)"id is empty", null);
        }
        if (permFilter == null) {
            return ResultUtil.buildSuccessResult((int)201, (String)"permFilter is null", null);
        }
        DynamicObject[] jobGradeScms = JobGradeScmRepository.getInstance().getJobGradeScmById(ids, permFilter);
        List jobGradeScmIds = Arrays.stream(jobGradeScms).map(jobGradeScm -> jobGradeScm.getLong("id")).collect(Collectors.toList());
        return ResultUtil.buildSuccessResult((int)200, (String)"query success", jobGradeScmIds);
    }

    public List<Long> getJobGradeScmIdsByUseorgIdList(List<Long> useorgIdList) {
        DynamicObject[] jobGradeScms;
        QFilter permFilter = PermOrgQFilterUtil.assembleFilterByOr((String)"hbjm_jobgradescmhr", useorgIdList);
        if (permFilter == null) {
            permFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
            permFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        if ((jobGradeScms = JobGradeScmRepository.getInstance().getJobGradeScmIdByPermFilter(permFilter)).length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(jobGradeScms).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }
}

