/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.mservice.IHBJMJobLevelGradeRangeService;

public class HBJMJobLevelGradeRangeService
implements IHBJMJobLevelGradeRangeService {
    public Map<Long, DynamicObject> getJobLevelGradeRangeInfo(List<Long> jobIds) {
        if (Objects.isNull(jobIds) || jobIds.isEmpty()) {
            return Maps.newHashMap();
        }
        DynamicObject[] jobInfo = JobRepository.getInstance().queryJobLevelGradeInfo(jobIds);
        if (Objects.isNull(jobInfo) || jobInfo.length == 0) {
            return Maps.newHashMap();
        }
        Map<Long, DynamicObject> jobCollect = Arrays.stream(jobInfo).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
        ArrayList<Long> jobClassIds = new ArrayList<Long>(jobInfo.length);
        ArrayList<Long> jobScmIds = new ArrayList<Long>(jobInfo.length);
        for (DynamicObject dy2 : jobInfo) {
            if (!Objects.isNull(dy2.get("lowjoblevel")) && !Objects.isNull(dy2.get("lowjobgrade")) || dy2.getLong("jobclass.id") == 0L || dy2.getLong("jobscm.id") == 0L) continue;
            jobClassIds.add(dy2.getLong("jobclass.id"));
            jobScmIds.add(dy2.getLong("jobscm.id"));
        }
        if (jobClassIds.isEmpty()) {
            return jobCollect;
        }
        DynamicObject[] jobClassInfo = JobClassScmRepository.getInstance().queryJobClassLevelGradeInfo(jobScmIds, jobClassIds);
        if (Objects.isNull(jobClassInfo) || jobClassInfo.length == 0) {
            return jobCollect;
        }
        Map<Long, Map<Long, DynamicObject>> jobClass = Arrays.stream(jobClassInfo).collect(Collectors.groupingBy(dy -> dy.getLong("jobscm.id"), Collectors.toMap(dy -> dy.getLong("jobclass.id"), dy -> dy, (v1, v2) -> v1)));
        for (Map.Entry<Long, DynamicObject> entry : jobCollect.entrySet()) {
            DynamicObject jobClassDy;
            DynamicObject dy3 = entry.getValue();
            Long jobClassId = dy3.getLong("jobclass.id");
            Long jobScmId = dy3.getLong("jobscm.id");
            Map<Long, DynamicObject> maps = jobClass.get(jobScmId);
            if (jobClassId == 0L || jobScmId == 0L || Objects.isNull(maps) || Objects.isNull(jobClassDy = maps.get(jobClassId))) continue;
            if (Objects.isNull(dy3.get("lowjoblevel")) && Objects.nonNull(jobClassDy.get("lowjoblevel"))) {
                dy3.set("lowjoblevel", jobClassDy.get("lowjoblevel"));
            }
            if (Objects.isNull(dy3.get("highjoblevel")) && Objects.nonNull(jobClassDy.get("highjoblevel"))) {
                dy3.set("highjoblevel", jobClassDy.get("highjoblevel"));
            }
            if (Objects.isNull(dy3.get("lowjobgrade")) && Objects.nonNull(jobClassDy.get("lowjobgrade"))) {
                dy3.set("lowjobgrade", jobClassDy.get("lowjobgrade"));
            }
            if (!Objects.isNull(dy3.get("highjobgrade")) || !Objects.nonNull(jobClassDy.get("highjobgrade"))) continue;
            dy3.set("highjobgrade", jobClassDy.get("highjobgrade"));
        }
        return jobCollect;
    }
}

