/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.application.impl.job.JobLevelAndGradeApplicationImpl;
import kd.hrmp.hbjm.business.domain.repository.JobGradeScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobLevelOrGradeRepository;
import kd.hrmp.hbjm.business.domain.repository.JobLevelScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.utils.MuliLangUtils;
import kd.hrmp.hbjm.common.util.ResultUtil;
import kd.hrmp.hbjm.mservice.IHBJMJobLevelGradeService;
import kd.hrmp.hbjm.mservice.helper.HBJMJobLevelGradeServiceHepler;
import kd.hrmp.hbjm.mservice.helper.JobGradeAndLevelRangeBo;
import kd.hrmp.hbjm.mservice.helper.JobGradeServiceBo;
import kd.hrmp.hbjm.mservice.helper.JobLevelGradeInfoBo;
import kd.hrmp.hbjm.mservice.helper.JobLevelGradeScmBo;
import kd.hrmp.hbjm.mservice.helper.JobLevelServiceBo;
import kd.hrmp.hbjm.mservice.helper.JobRelationLevelGradeBo;
import kd.hrmp.hbjm.mservice.helper.MServiceBo;

public class HBJMJobLevelGradeService
implements IHBJMJobLevelGradeService {
    private static final Log logger = LogFactory.getLog(HBJMJobLevelGradeService.class);

    public Map<String, Object> getJobLevelGradeRangeInfo(List<Long> jobboidlist) {
        List<Long> gradeIds;
        logger.info("HBJMJobLevelGradeService getJobLevelGradeRangeInfo params:{}", jobboidlist);
        if (ObjectUtils.isEmpty(jobboidlist)) {
            return ResultUtil.buildSuccessResult((int)200, (String)"jobboidlist can not be null", null);
        }
        DynamicObject[] jobArray = JobRepository.getInstance().queryJobLevelGrade(jobboidlist);
        if (jobArray == null || jobArray.length <= 0) {
            return ResultUtil.buildSuccessResult((int)200, (String)" no job data", null);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)jobArray.length);
        Set levelscmids = Arrays.stream(jobArray).map(job -> job.getLong("highjoblevel.joblevelscm_id")).collect(Collectors.toSet());
        Set gradescmids = Arrays.stream(jobArray).map(job -> job.getLong("highjobgrade.jobgradescm_id")).collect(Collectors.toSet());
        DynamicObject[] jobscmlevels = JobLevelScmRepository.getInstance().getLevelScms(levelscmids);
        DynamicObject[] jobscmGrades = JobGradeScmRepository.getInstance().getGradeScms(gradescmids);
        Map<Long, List<DynamicObject>> levelmap = null;
        Map<Long, List<DynamicObject>> grademap = null;
        List<Long> levelIds = this.getPkIds(jobscmlevels);
        if (levelIds != null) {
            DynamicObject[] joblevels = JobLevelOrGradeRepository.getInstance().getLevelByIds(levelIds);
            levelmap = Arrays.stream(joblevels).collect(Collectors.groupingBy(dyn -> dyn.getLong("joblevelscm.id")));
        }
        if ((gradeIds = this.getPkIds(jobscmGrades)) != null) {
            DynamicObject[] jobGrades = JobLevelOrGradeRepository.getInstance().getGradeByIds(gradeIds);
            grademap = Arrays.stream(jobGrades).collect(Collectors.groupingBy(dyn -> dyn.getLong("jobgradescm.id")));
        }
        for (DynamicObject job2 : jobArray) {
            HashMap dynmap = Maps.newHashMapWithExpectedSize((int)4);
            if (levelmap != null) {
                long lowjoblevelseq = job2.getLong("lowjoblevel.joblevelseq");
                long highjoblevelseq = job2.getLong("highjoblevel.joblevelseq");
                long joblevelscmid = job2.getLong("highjoblevel.joblevelscm_id");
                List<DynamicObject> joblevelcoll = levelmap.get(joblevelscmid);
                ArrayList<DynamicObject> levellist = new ArrayList<DynamicObject>();
                if (!CollectionUtils.isEmpty(joblevelcoll)) {
                    for (DynamicObject level : joblevelcoll) {
                        long joblevelseq = level.getLong("joblevelseq");
                        if (joblevelseq < lowjoblevelseq || joblevelseq > highjoblevelseq) continue;
                        levellist.add(level);
                    }
                }
                dynmap.put("joblevel", levellist);
            }
            if (grademap != null) {
                long lowjobgradeseq = job2.getLong("lowjobgrade.jobgradeseq");
                long highjobgradeseq = job2.getLong("highjobgrade.jobgradeseq");
                long jobgradescmid = job2.getLong("highjobgrade.jobgradescm_id");
                List<DynamicObject> jobgradecoll = grademap.get(jobgradescmid);
                ArrayList<DynamicObject> gradelist = new ArrayList<DynamicObject>();
                if (!CollectionUtils.isEmpty(jobgradecoll)) {
                    for (DynamicObject grade : jobgradecoll) {
                        long jobgradeseq = grade.getLong("jobgradeseq");
                        if (jobgradeseq < lowjobgradeseq || jobgradeseq > highjobgradeseq) continue;
                        gradelist.add(grade);
                    }
                }
                dynmap.put("jobgrade", gradelist);
            }
            map.put(job2.getString("id"), dynmap);
        }
        logger.info("HBJMJobLevelGradeService getJobLevelGradeRangeInfo result:{}", (Object)map);
        return ResultUtil.buildSuccessResult((int)200, (String)"", (Object)map);
    }

    private List<Long> getPkIds(DynamicObject[] jobscmlevelOrGrades) {
        ArrayList<Long> pkids = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty((Object[])jobscmlevelOrGrades)) {
            for (DynamicObject levelOrGradeScm : jobscmlevelOrGrades) {
                DynamicObjectCollection cols = levelOrGradeScm.getDynamicObjectCollection("entryentity");
                if (ObjectUtils.isEmpty((Object)cols)) continue;
                pkids.addAll(cols.stream().map(col -> col.getLong("id")).collect(Collectors.toList()));
            }
        }
        return pkids;
    }

    public Map<String, Object> getAllJobLevelGradeRangeInfoByJobId(List<Long> jobIds) {
        logger.info("HBJMJobLevelGradeService getAllJobLevelGradeRangeInfoByJobId params:{}", jobIds);
        if (jobIds == null || jobIds.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        if (jobIds.size() > 500) {
            return ResultUtil.buildResult((int)201, (String)"max size is 500", null);
        }
        DynamicObject[] dyns = JobRepository.getInstance().loadCurrentJobFieldDataByBoid(jobIds);
        List<JobRelationLevelGradeBo> results = this.assembleBoResult(jobIds, dyns, "boid");
        List<Map<String, Object>> infos = JobRelationLevelGradeBo.toMapInfo(results);
        logger.info("HBJMJobLevelGradeService getAllJobLevelGradeRangeInfoByJobId result:{}", infos);
        return ResultUtil.buildSuccessResult((int)200, (String)"", infos);
    }

    public Map<String, Object> getJobLevelRangeByJobId(List<Long> jobBoIdList, Date searchDate) {
        if (jobBoIdList == null || jobBoIdList.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        if (jobBoIdList.size() > 5000) {
            return ResultUtil.buildResult((int)201, (String)"max size is 5000", null);
        }
        if (Objects.isNull(searchDate)) {
            searchDate = new Date();
        }
        DynamicObject[] dyns = JobRepository.getInstance().loadHisJobFieldDataByBoId(jobBoIdList, searchDate);
        List<JobRelationLevelGradeBo> boList = this.assembleBoResult(jobBoIdList, dyns, "boid");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)boList.size());
        for (JobRelationLevelGradeBo jobRelationLevelGradeBo : boList) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("jobBoId", jobRelationLevelGradeBo.getJobId());
            String errorMsg = jobRelationLevelGradeBo.getErrorMsg();
            map.put("errorMsg", errorMsg);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                result.add(map);
                continue;
            }
            map.put("createOrgId", jobRelationLevelGradeBo.getJobCreateOrg().getLong("id"));
            map.put("jobLevelRange", this.buildJobLevelRangeResult(jobRelationLevelGradeBo, map));
            result.add(map);
        }
        return ResultUtil.buildSuccessResult((int)200, (String)"", (Object)result);
    }

    public Map<String, Object> getJobGradeRangeByJobId(List<Long> jobBoIdList, Date searchDate) {
        if (jobBoIdList == null || jobBoIdList.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        if (jobBoIdList.size() > 5000) {
            return ResultUtil.buildResult((int)201, (String)"max size is 5000", null);
        }
        if (Objects.isNull(searchDate)) {
            searchDate = new Date();
        }
        DynamicObject[] dyns = JobRepository.getInstance().loadHisJobFieldDataByBoId(jobBoIdList, searchDate);
        List<JobRelationLevelGradeBo> boList = this.assembleBoResult(jobBoIdList, dyns, "boid");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)boList.size());
        for (JobRelationLevelGradeBo jobRelationLevelGradeBo : boList) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("jobBoId", jobRelationLevelGradeBo.getJobId());
            String errorMsg = jobRelationLevelGradeBo.getErrorMsg();
            map.put("errorMsg", errorMsg);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                result.add(map);
                continue;
            }
            map.put("createOrgId", jobRelationLevelGradeBo.getJobCreateOrg().getLong("id"));
            map.put("jobGradeRange", this.buildJobGradeRangeResult(jobRelationLevelGradeBo, map));
            result.add(map);
        }
        return ResultUtil.buildSuccessResult((int)200, (String)"", (Object)result);
    }

    private List<Map<String, Object>> buildJobLevelRangeResult(JobRelationLevelGradeBo jobRelationLevelGradeBo, Map<String, Object> map) {
        ArrayList rangeResultList = Lists.newArrayListWithExpectedSize((int)16);
        JobLevelGradeScmBo jobScmJobLevelBo = jobRelationLevelGradeBo.getJobScmJobLevel();
        this.putJobLevelValue(map, rangeResultList, jobScmJobLevelBo);
        JobLevelGradeScmBo jobFamilyJobLevelBo = jobRelationLevelGradeBo.getJobFamilyJobLevel();
        this.putJobLevelValue(map, rangeResultList, jobFamilyJobLevelBo);
        JobLevelGradeScmBo jobClassJobLevelBo = jobRelationLevelGradeBo.getJobClassJobLevel();
        this.putJobLevelValue(map, rangeResultList, jobClassJobLevelBo);
        JobLevelGradeScmBo jobJobLevelBo = jobRelationLevelGradeBo.getJobJobLevel();
        this.putJobLevelValue(map, rangeResultList, jobJobLevelBo);
        return rangeResultList;
    }

    private void putJobLevelValue(Map<String, Object> map, List<Map<String, Object>> rangeResultList, JobLevelGradeScmBo jobClassJobLevelBo) {
        List<DynamicObject> jobClassRanges;
        if (Objects.nonNull(jobClassJobLevelBo) && !CollectionUtils.isEmpty(jobClassRanges = jobClassJobLevelBo.getRanges())) {
            rangeResultList.clear();
            this.addJobLevelRangeResultList(rangeResultList, jobClassRanges);
            map.put("jobLevelScmId", jobClassRanges.get(0).getLong("joblevelscm.id"));
        }
    }

    private List<Map<String, Object>> buildJobGradeRangeResult(JobRelationLevelGradeBo jobRelationLevelGradeBo, Map<String, Object> map) {
        ArrayList rangeResultList = Lists.newArrayListWithExpectedSize((int)16);
        JobLevelGradeScmBo jobScmJobGradeBo = jobRelationLevelGradeBo.getJobScmJobGrade();
        this.putJobGradeValue(map, rangeResultList, jobScmJobGradeBo);
        JobLevelGradeScmBo jobFamilyJobGradeBo = jobRelationLevelGradeBo.getJobFamilyJobGrade();
        this.putJobGradeValue(map, rangeResultList, jobFamilyJobGradeBo);
        JobLevelGradeScmBo jobClassJobGradeBo = jobRelationLevelGradeBo.getJobClassJobGrade();
        this.putJobGradeValue(map, rangeResultList, jobClassJobGradeBo);
        JobLevelGradeScmBo jobJobGradeBo = jobRelationLevelGradeBo.getJobJobGrade();
        this.putJobGradeValue(map, rangeResultList, jobJobGradeBo);
        return rangeResultList;
    }

    private void putJobGradeValue(Map<String, Object> map, List<Map<String, Object>> rangeResultList, JobLevelGradeScmBo jobClassJobGradeBo) {
        List<DynamicObject> jobClassRanges;
        if (Objects.nonNull(jobClassJobGradeBo) && !CollectionUtils.isEmpty(jobClassRanges = jobClassJobGradeBo.getRanges())) {
            rangeResultList.clear();
            this.addJobGradeRangeResultList(rangeResultList, jobClassRanges);
            map.put("jobGradeScmId", jobClassRanges.get(0).getLong("jobgradescm.id"));
        }
    }

    private List<JobRelationLevelGradeBo> assembleBoResult(List<Long> jobIds, DynamicObject[] dyns, String idKey) {
        List results = JobRelationLevelGradeBo.getEmptyBo(JobRelationLevelGradeBo.class, jobIds.size());
        for (int index = 0; index < results.size(); ++index) {
            ((JobRelationLevelGradeBo)results.get(index)).setJobId(jobIds.get(index));
        }
        if (dyns != null) {
            Map<Long, DynamicObject> dbDatas = Arrays.stream(dyns).collect(Collectors.toMap(data -> data.getLong(idKey), v1 -> v1, (v1, v2) -> v1));
            results.forEach(result -> {
                DynamicObject jobDyn = (DynamicObject)dbDatas.get(result.getJobId());
                if (jobDyn != null) {
                    result.setExist(true);
                    result.setJobNumber(jobDyn.getString("number"));
                    result.setJobName(jobDyn.getLocaleString("name"));
                    result.setJobCreateOrg(jobDyn.getDynamicObject("createorg"));
                    result.setJobUseOrg(jobDyn.getDynamicObject("useorg"));
                    result.setJob(jobDyn);
                    DynamicObject jobscm = jobDyn.getDynamicObject("jobscm");
                    result.setJobScm(jobscm);
                    if (jobscm != null) {
                        result.setJobSeq(jobDyn.getDynamicObject("jobseq"));
                        result.setJobFamily(jobDyn.getDynamicObject("jobfamily"));
                        result.setJobClass(jobDyn.getDynamicObject("jobclass"));
                    }
                } else {
                    result.setExist(false);
                    result.setErrorMsg("not job data,id:" + result.getJobId());
                }
            });
            HBJMJobLevelGradeServiceHepler.dealScmJobLevelAndGrade(results);
        }
        return results;
    }

    private void addJobGradeRangeResultList(List<Map<String, Object>> rangeResultList, List<DynamicObject> jobGradeRanges) {
        for (DynamicObject jobJobGradeDyn : jobGradeRanges) {
            HashMap jobGradeRangeResultMap = Maps.newHashMapWithExpectedSize((int)4);
            jobGradeRangeResultMap.put("jobGradeId", jobJobGradeDyn.getLong("id"));
            jobGradeRangeResultMap.put("jobGradeNumber", jobJobGradeDyn.getString("number"));
            jobGradeRangeResultMap.put("jobGradeName", jobJobGradeDyn.getString("name"));
            jobGradeRangeResultMap.put("jobGradeSeq", jobJobGradeDyn.getInt("jobgradeseq"));
            rangeResultList.add(jobGradeRangeResultMap);
        }
    }

    private void addJobLevelRangeResultList(List<Map<String, Object>> rangeResultList, List<DynamicObject> jobLevelRanges) {
        for (DynamicObject jobLevelDyn : jobLevelRanges) {
            HashMap jobRangeResultMap = Maps.newHashMapWithExpectedSize((int)4);
            jobRangeResultMap.put("jobLevelId", jobLevelDyn.getLong("id"));
            jobRangeResultMap.put("jobLevelNumber", jobLevelDyn.getString("number"));
            jobRangeResultMap.put("jobLevelName", jobLevelDyn.getString("name"));
            jobRangeResultMap.put("jobLevelSeq", jobLevelDyn.getInt("joblevelseq"));
            rangeResultList.add(jobRangeResultMap);
        }
    }

    public Map<String, Object> getJobLevelRangeByScmId(List<Map<String, Object>> levelScmIds, String lang) {
        List names;
        logger.info("HBJMJobLevelGradeService getJobLevelRangeByScmId params levelScmIds:{},lang:{}", levelScmIds, (Object)lang);
        boolean isSupportLang = MuliLangUtils.isSupportLang((String)lang);
        if (!isSupportLang) {
            return ResultUtil.buildResult((int)201, (String)"do not support this lang", null);
        }
        if (levelScmIds == null || levelScmIds.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        List results = JobLevelServiceBo.getEmptyBo(JobLevelServiceBo.class, levelScmIds.size());
        HBJMJobLevelGradeServiceHepler.valideAndInitParamsByLevel(levelScmIds, results);
        List successData = results.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(successData)) {
            return ResultUtil.buildResult((int)200, (String)"", JobLevelServiceBo.toMap(results));
        }
        JobLevelAndGradeApplicationImpl jobLevelAndGradeApplication = new JobLevelAndGradeApplicationImpl();
        List scmIds = successData.stream().map(JobLevelServiceBo::getScmId).collect(Collectors.toList());
        DynamicObjectCollection collections = jobLevelAndGradeApplication.getJobLevelByScmIdAndLangName(scmIds, names = successData.stream().map(JobLevelServiceBo::getJoblevelName).collect(Collectors.toList()), Lang.from((String)lang));
        if (collections != null && collections.size() > 0) {
            Map<String, DynamicObject> groupMap = collections.stream().collect(Collectors.toMap(data -> data.getLong("joblevelscm.id") + data.getString("name"), v1 -> v1, (v1, v2) -> v2));
            successData.stream().forEach(data -> {
                String dataKey = data.getScmId() + data.getJoblevelName();
                DynamicObject dyn = (DynamicObject)groupMap.get(dataKey);
                if (dyn != null) {
                    data.setJoblevel(dyn);
                    data.setScmName(dyn.getString("joblevelscm.name"));
                    data.setExist(true);
                }
            });
        }
        List<Map<String, Object>> infos = JobLevelServiceBo.toMap(results);
        logger.info("HBJMJobLevelGradeService getJobLevelRangeByScmId result:{}", infos);
        return ResultUtil.buildResult((int)200, (String)"", infos);
    }

    public Map<String, Object> getJobGradeRangeByScmId(List<Map<String, Object>> gradeScmIds, String lang) {
        List names;
        logger.info("HBJMJobLevelGradeService getJobGradeRangeByScmId params gradeScmIds:{}  lang:{}", gradeScmIds, (Object)lang);
        boolean isSupportLang = MuliLangUtils.isSupportLang((String)lang);
        if (!isSupportLang) {
            return ResultUtil.buildResult((int)201, (String)"do not support this lang", null);
        }
        if (gradeScmIds == null || gradeScmIds.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        List results = JobGradeServiceBo.getEmptyBo(JobGradeServiceBo.class, gradeScmIds.size());
        HBJMJobLevelGradeServiceHepler.valideAndInitParamsByGrade(gradeScmIds, results);
        List successData = results.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(successData)) {
            return ResultUtil.buildResult((int)200, (String)"", JobGradeServiceBo.toMap(results));
        }
        JobLevelAndGradeApplicationImpl jobLevelAndGradeApplication = new JobLevelAndGradeApplicationImpl();
        List scmIds = successData.stream().map(JobGradeServiceBo::getScmId).collect(Collectors.toList());
        DynamicObjectCollection collections = jobLevelAndGradeApplication.getJobGradeByScmIdAndLangName(scmIds, names = successData.stream().map(JobGradeServiceBo::getJobgradeName).collect(Collectors.toList()), Lang.from((String)lang));
        if (collections != null && collections.size() > 0) {
            Map<String, DynamicObject> groupMap = collections.stream().collect(Collectors.toMap(data -> data.getLong("jobgradescm.id") + data.getString("name"), v1 -> v1, (v1, v2) -> v2));
            successData.stream().forEach(data -> {
                String dataKey = data.getScmId() + data.getJobgradeName();
                DynamicObject dyn = (DynamicObject)groupMap.get(dataKey);
                if (dyn != null) {
                    data.setJobgrade(dyn);
                    data.setScmName(dyn.getString("jobgradescm.name"));
                    data.setExist(true);
                }
            });
        }
        List<Map<String, Object>> infos = JobGradeServiceBo.toMap(results);
        logger.info("HBJMJobLevelGradeService getJobGradeRangeByScmId result:{}", infos);
        return ResultUtil.buildResult((int)200, (String)"", infos);
    }

    public Map<String, Object> getJobGradeAndLevelRange(List<Map<String, Long>> rangs) {
        DynamicObject[] levelInfos;
        List scmIds;
        DynamicObject[] gradeInfos;
        logger.info("HBJMJobLevelGradeService getJobGradeAndLevelRange params:{}", rangs);
        if (rangs == null || rangs.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        List results = JobGradeAndLevelRangeBo.getEmptyBo(JobGradeAndLevelRangeBo.class, rangs.size());
        HBJMJobLevelGradeServiceHepler.valideAndInitJobGradeAndLevelRange(rangs, results);
        List<JobGradeAndLevelRangeBo> canDealSourceData = results.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList());
        if (canDealSourceData == null || canDealSourceData.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", JobGradeAndLevelRangeBo.toMap(results));
        }
        ArrayList gradeIds = new ArrayList(rangs.size() * 4);
        ArrayList levelIds = new ArrayList(rangs.size() * 4);
        canDealSourceData.forEach(data -> {
            Long lowJobGrade = data.getLowJobGrade();
            Long highJobGrade = data.getHighJobGrade();
            Long lowJobLevel = data.getLowJobLevel();
            Long highJobLevel = data.getHighJobLevel();
            if (lowJobGrade != null && lowJobGrade > 0L) {
                gradeIds.add(lowJobGrade);
            }
            if (highJobGrade != null && highJobGrade > 0L) {
                gradeIds.add(highJobGrade);
            }
            if (lowJobLevel != null && lowJobLevel > 0L) {
                levelIds.add(lowJobLevel);
            }
            if (highJobLevel != null && highJobLevel > 0L) {
                levelIds.add(highJobLevel);
            }
        });
        if (gradeIds.size() > 0 && (gradeInfos = JobLevelOrGradeRepository.getInstance().getGradeByIds(gradeIds)) != null && gradeInfos.length > 0) {
            scmIds = Arrays.stream(gradeInfos).map(data -> data.getLong("jobgradescm.id")).collect(Collectors.toList());
            DynamicObject[] allGradeInfo = JobLevelOrGradeRepository.getInstance().getGradeByScmIds(scmIds);
            HBJMJobLevelGradeServiceHepler.valideLowAndHighGrade(allGradeInfo, canDealSourceData);
            HBJMJobLevelGradeServiceHepler.buildGradeRangs(allGradeInfo, results.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList()));
        }
        if (levelIds != null && levelIds.size() > 0 && (levelInfos = JobLevelOrGradeRepository.getInstance().getLevelByIds(levelIds)) != null && levelInfos.length > 0) {
            scmIds = Arrays.stream(levelInfos).map(data -> data.getLong("joblevelscm.id")).collect(Collectors.toList());
            DynamicObject[] allLevelInfo = JobLevelOrGradeRepository.getInstance().getLevelByScmIds(scmIds);
            HBJMJobLevelGradeServiceHepler.valideLowAndHighLevel(allLevelInfo, canDealSourceData);
            HBJMJobLevelGradeServiceHepler.buildLevelRangs(allLevelInfo, results.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList()));
        }
        List<Map<String, Object>> infos = JobGradeAndLevelRangeBo.toMapInfo(results);
        logger.info("HBJMJobLevelGradeService getJobGradeAndLevelRange result:{}", infos);
        return ResultUtil.buildResult((int)200, (String)"", infos);
    }

    public Map<String, Object> getJobGradeByScmAndName(List<Map<String, Object>> infos) {
        return this.getJobLevelGradeByScmAndName(infos, "hbjm_jobgradescmhr");
    }

    public Map<String, Object> getJobLevelByScmAndName(List<Map<String, Object>> infos) {
        return this.getJobLevelGradeByScmAndName(infos, "hbjm_joblevelscmhr");
    }

    private Map<String, Object> getJobLevelGradeByScmAndName(List<Map<String, Object>> infos, String entityName) {
        logger.info("HBJMJobLevelGradeService getJobLevelGradeByScmAndName params:{}, {}", infos, (Object)entityName);
        if (infos == null || infos.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        List results = JobLevelGradeInfoBo.getEmptyBo(JobLevelGradeInfoBo.class, infos.size());
        HBJMJobLevelGradeServiceHepler.valideAndInitParamsByGradeInfo(infos, results);
        List successData = results.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(successData)) {
            return ResultUtil.buildResult((int)200, (String)"", JobLevelGradeInfoBo.toMap(results));
        }
        Map<String, JobLevelGradeInfoBo> dataByScmNumberMap = successData.stream().filter(data -> HRStringUtils.isNotEmpty((String)data.getScmNumber())).collect(Collectors.toMap(JobLevelGradeInfoBo::getScmNumber, data -> data));
        Map<String, JobLevelGradeInfoBo> dataByScmNameMap = successData.stream().filter(data -> HRStringUtils.isEmpty((String)data.getScmNumber())).collect(Collectors.toMap(JobLevelGradeInfoBo::getScmName, data -> data));
        JobLevelAndGradeApplicationImpl jobLevelAndGradeApplication = new JobLevelAndGradeApplicationImpl();
        DynamicObject[] scmData = jobLevelAndGradeApplication.getScmByNumberOrName(dataByScmNumberMap.keySet(), dataByScmNameMap.keySet(), entityName);
        this.assembleJobLevelGradeInfoBo("number", dataByScmNumberMap, scmData, entityName);
        this.assembleJobLevelGradeInfoBo("name", dataByScmNameMap, scmData, entityName);
        List<Map<String, Object>> resultInfos = JobGradeServiceBo.toMap(results);
        logger.info("HBJMJobLevelGradeService getJobLevelGradeByScmAndName result:{}", resultInfos);
        return ResultUtil.buildResult((int)200, (String)"", resultInfos);
    }

    private void assembleJobLevelGradeInfoBo(String key, Map<String, JobLevelGradeInfoBo> dataByScmMap, DynamicObject[] scmData, String entityName) {
        if (dataByScmMap == null || dataByScmMap.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> scmDataMap = Arrays.stream(scmData).collect(Collectors.groupingBy(dy -> dy.getString(key)));
        dataByScmMap.forEach((keyField, infoBo) -> {
            List scmList = (List)scmDataMap.get(keyField);
            if (scmList == null || scmList.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"HBJMJobLevelGradeService_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                infoBo.setSuccess(false);
                infoBo.setErrorMsg(msg);
            } else if (scmList.size() > 1) {
                String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u591a\u6761\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"HBJMJobLevelGradeService_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                infoBo.setSuccess(false);
                infoBo.setErrorMsg(msg);
            } else {
                DynamicObject scm = (DynamicObject)scmList.get(0);
                infoBo.setScmId(scm.getLong("id"));
                DynamicObjectCollection entry = scm.getDynamicObjectCollection("entryentity");
                List<String> nameList = infoBo.getName();
                if (entry != null && nameList != null && nameList.size() > 0) {
                    HashMap<String, Long> nameToIdMap = new HashMap<String, Long>();
                    for (DynamicObject levelGrade : entry) {
                        String levelGradeName = levelGrade.getString(entityName.equals("hbjm_jobgradescmhr") ? "jobgrade_name" : "joblevel_name");
                        long gradeId = levelGrade.getLong("id");
                        if (!nameList.contains(levelGradeName)) continue;
                        nameToIdMap.put(levelGradeName, gradeId);
                    }
                    infoBo.setNameToIdMap(nameToIdMap);
                }
            }
        });
    }

    public Map<Long, Long> getJobLevelScmIdById(List<Long> ids) {
        DynamicObject[] dyns = JobLevelOrGradeRepository.getInstance().getLevelByIds(ids);
        if (dyns != null && dyns.length > 0) {
            return Arrays.stream(dyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("joblevelscm.id")));
        }
        return new HashMap<Long, Long>();
    }

    public Map<Long, Long> getJobGradeScmIdById(List<Long> ids) {
        DynamicObject[] dyns = JobLevelOrGradeRepository.getInstance().getGradeByIds(ids);
        if (dyns != null && dyns.length > 0) {
            return Arrays.stream(dyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("jobgradescm.id")));
        }
        return new HashMap<Long, Long>();
    }

    public Map<String, Object> getAllJobLevelGradeRangeInfoByJobVersionId(List<Long> jobIds) {
        logger.info("HBJMJobLevelGradeService getAllJobLevelGradeRangeInfoByJobId params:{}", jobIds);
        if (jobIds == null || jobIds.size() <= 0) {
            return ResultUtil.buildResult((int)200, (String)"", null);
        }
        if (jobIds.size() > 500) {
            return ResultUtil.buildResult((int)201, (String)"max size is 500", null);
        }
        DynamicObject[] dyns = JobRepository.getInstance().loadFieldDataById(jobIds);
        List<JobRelationLevelGradeBo> results = this.assembleBoResult(jobIds, dyns, "id");
        List<Map<String, Object>> infos = JobRelationLevelGradeBo.toMapInfo(results);
        return ResultUtil.buildSuccessResult((int)200, (String)"", infos);
    }
}

