/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hrmp.hbjm.business.domain.repository.JobLevelScmRepository;
import kd.hrmp.hbjm.common.util.PermOrgQFilterUtil;
import kd.hrmp.hbjm.common.util.ResultUtil;
import kd.hrmp.hbjm.mservice.HBJMJobLevelOrGradeServiceHelper;
import kd.hrmp.hbjm.mservice.IHBJMJobLevelScmService;

public class HBJMJobLevelScmService
implements IHBJMJobLevelScmService {
    public Map<String, Object> getJobLevelScmIdByNumberMap(Set<String> numberSet) {
        Map<String, Object> resultMap = HBJMJobLevelOrGradeServiceHelper.validateInputData(numberSet);
        if (resultMap != null) {
            return resultMap;
        }
        List<Map<String, Object>> map = HBJMJobLevelOrGradeServiceHelper.packageNumberVsBoIdMapData(numberSet, "hbjm_joblevelscmhr");
        return ResultUtil.buildSuccessResult((int)200, (String)"", map);
    }

    public Map<String, Object> hasPermJobLevelScmIds(Set<Long> ids, QFilter permFilter) {
        if (ids == null || ids.isEmpty()) {
            return ResultUtil.buildSuccessResult((int)201, (String)"id is empty", null);
        }
        if (permFilter == null) {
            return ResultUtil.buildSuccessResult((int)201, (String)"permFilter is null", null);
        }
        DynamicObject[] jobLevelScms = JobLevelScmRepository.getInstance().getJobLevelScmById(ids, permFilter);
        List jobLevelScmIds = Arrays.stream(jobLevelScms).map(jobLevelScm -> jobLevelScm.getLong("id")).collect(Collectors.toList());
        return ResultUtil.buildSuccessResult((int)200, (String)"query success", jobLevelScmIds);
    }

    public List<Long> getJobLevelScmIdsByUseorgIdList(List<Long> useorgIdList) {
        DynamicObject[] jobLevelScms;
        QFilter permFilter = PermOrgQFilterUtil.assembleFilterByOr((String)"hbjm_joblevelscmhr", useorgIdList);
        if (permFilter == null) {
            permFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
            permFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        if ((jobLevelScms = JobLevelScmRepository.getInstance().getJobLevelScmIdByPermFilter(permFilter)).length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(jobLevelScms).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }
}

