/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqScmRepository;
import kd.hrmp.hbjm.business.utils.JobTreeBuildUtil;
import kd.hrmp.hbjm.common.util.PermOrgQFilterUtil;
import kd.hrmp.hbjm.common.util.ResultUtil;
import kd.hrmp.hbjm.mservice.IHBJMScmInfoService;

public class HBJMScmInfoService
implements IHBJMScmInfoService {
    public Map<String, Object> getJobScmInfo(String scmnumber, Long orgId) {
        String jobseqid;
        if (StringUtils.isEmpty((CharSequence)scmnumber) || Objects.isNull(orgId)) {
            return ResultUtil.buildSuccessResult((int)200, (String)"", null);
        }
        QFilter permOrgFilter = PermOrgQFilterUtil.assembleFilterByOr((String)"hbjm_jobscmhr", (List)Lists.newArrayList((Object[])new Long[]{orgId}));
        DynamicObject scmdyn = JobScmRepository.getInstance().queryBaseInfoByNumberAndPerm(scmnumber, permOrgFilter);
        if (ObjectUtils.isEmpty((Object)scmdyn)) {
            return ResultUtil.buildSuccessResult((int)200, (String)"", null);
        }
        long scmid = scmdyn.getLong("id");
        String scmidstr = String.valueOf(scmid);
        String scmaname = scmdyn.getString("name");
        Object[] seqscms = JobSeqScmRepository.getInstance().queryJobSeqScmByScmId(Long.valueOf(scmid));
        Object[] familyscms = JobFamilyScmRepository.getInstance().queryJobFamilyScmByScmId(Long.valueOf(scmid));
        Object[] classscms = JobClassScmRepository.getInstance().queryJobClassScmByScmId(Long.valueOf(scmid));
        int classscms_length = ObjectUtils.isEmpty((Object[])classscms) ? 0 : classscms.length;
        int familyscms_length = ObjectUtils.isEmpty((Object[])familyscms) ? 0 : familyscms.length;
        int seqscms_length = ObjectUtils.isEmpty((Object[])seqscms) ? 0 : seqscms.length;
        HashMap treenodemap = Maps.newHashMapWithExpectedSize((int)(classscms_length + familyscms_length + seqscms_length + 1));
        TreeNode scmnode = new TreeNode("", scmidstr, scmnumber, (Object)scmaname);
        treenodemap.put(scmidstr, scmnode);
        if (ObjectUtils.isEmpty((Object[])seqscms)) {
            return ResultUtil.buildSuccessResult((int)200, (String)"", (Object)scmnode);
        }
        for (Object seqscm : seqscms) {
            jobseqid = seqscm.getString("jobseq.id");
            String jobseqnumber = seqscm.getString("jobseq.number");
            String jobseqname = seqscm.getString("jobseq.name");
            JobTreeBuildUtil.appendNode((Map)treenodemap, (String)scmidstr, (String)String.valueOf(jobseqid), parentNode -> {
                TreeNode node = new TreeNode(parentNode.getId(), jobseqid, jobseqnumber, (Object)jobseqname);
                return node;
            });
        }
        if (!ObjectUtils.isEmpty((Object[])familyscms)) {
            for (Object familyscmdyn : familyscms) {
                jobseqid = familyscmdyn.getString("jobseq.id");
                String jobfamilyid = familyscmdyn.getString("jobfamily.id");
                String jobfamilynumber = familyscmdyn.getString("jobfamily.number");
                String jobfamilyname = familyscmdyn.getString("jobfamily.name");
                JobTreeBuildUtil.appendNode((Map)treenodemap, (String)jobseqid, (String)String.valueOf(jobfamilyid), parentNode -> {
                    TreeNode node = new TreeNode(parentNode.getId(), jobfamilyid, jobfamilynumber, (Object)jobfamilyname);
                    return node;
                });
            }
        }
        if (!ObjectUtils.isEmpty((Object[])classscms)) {
            List jobClassDysSorted = Arrays.stream(classscms).sorted(Comparator.comparing(classscmsinfo -> classscmsinfo.getInt("jobclass.jobclasslevel"))).collect(Collectors.toList());
            for (DynamicObject classscm : jobClassDysSorted) {
                String jobfamilyid = classscm.getString("jobfamily.id");
                String jobclassid = classscm.getString("jobclass.id");
                String jobclassnumber = classscm.getString("jobclass.number");
                String jobclassname = classscm.getString("jobclass.name");
                String parentId = classscm.getString("jobclass.parent.id");
                if (HRStringUtils.isEmpty((String)parentId)) {
                    parentId = jobfamilyid;
                }
                JobTreeBuildUtil.appendNode((Map)treenodemap, (String)parentId, (String)jobclassid, parentNode -> {
                    TreeNode node = new TreeNode(parentNode.getId(), jobclassid, jobclassnumber, (Object)jobclassname);
                    return node;
                });
            }
        }
        return ResultUtil.buildSuccessResult((int)200, (String)"", (Object)scmnode);
    }
}

