/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.repository.JobScmRepository;
import kd.hrmp.hbjm.common.util.PermOrgQFilterUtil;
import kd.hrmp.hbjm.mservice.IHBJMService;

public class HBJMService
implements IHBJMService {
    private static final Log LOGGER = LogFactory.getLog(HBJMService.class);
    private static final String SCM_ID = "scm.id";
    private static final String HRMP_HBJM_MSERVICE = "hrmp-hbjm-mservice";

    public QFilter getJobPropRangeQFilter(String highJobPropId, String lowJobPropId, String jobProp) {
        if (null == highJobPropId && null == lowJobPropId) {
            return new QFilter("1", "=", (Object)"2");
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_" + jobProp);
        QFilter jobPropFilter = new QFilter("id", "in", Arrays.asList(highJobPropId, lowJobPropId));
        String selectProps = jobProp + "scm.id, " + jobProp + "seq";
        DynamicObject[] jobPropDyobjs = serviceHelper.query(selectProps, new QFilter[]{jobPropFilter});
        return this.getqFilter(highJobPropId, lowJobPropId, jobProp, jobPropDyobjs);
    }

    private QFilter getqFilter(String highJobPropId, String lowJobPropId, String jobProp, DynamicObject[] jobPropDyobjs) {
        DynamicObject highJobPropDyobj = null;
        DynamicObject lowJobPropDyobj = null;
        for (DynamicObject jobPropDyobj : jobPropDyobjs) {
            if (HRStringUtils.equals((String)highJobPropId, (String)lowJobPropId)) {
                if (!HRStringUtils.equals((String)highJobPropId, (String)jobPropDyobj.getString("id"))) continue;
                highJobPropDyobj = jobPropDyobj;
                lowJobPropDyobj = jobPropDyobj;
                continue;
            }
            if (HRStringUtils.equals((String)highJobPropId, (String)jobPropDyobj.getString("id"))) {
                highJobPropDyobj = jobPropDyobj;
                continue;
            }
            if (!HRStringUtils.equals((String)lowJobPropId, (String)jobPropDyobj.getString("id"))) continue;
            lowJobPropDyobj = jobPropDyobj;
        }
        QFilter qFilter = new QFilter("1", "=", (Object)"1");
        if (null != highJobPropDyobj) {
            QFilter highQFilter = new QFilter(jobProp + SCM_ID, "=", highJobPropDyobj.get(jobProp + SCM_ID));
            highQFilter.and(new QFilter(jobProp + "seq", "<=", highJobPropDyobj.get(jobProp + "seq")));
            qFilter.and(highQFilter);
        }
        if (null != lowJobPropDyobj) {
            QFilter lowQFilter = new QFilter(jobProp + SCM_ID, "=", lowJobPropDyobj.get(jobProp + SCM_ID));
            lowQFilter.and(new QFilter(jobProp + "seq", ">=", lowJobPropDyobj.get(jobProp + "seq")));
            qFilter.and(lowQFilter);
        }
        return qFilter;
    }

    public Map<String, String> validateJobPropIfWhitinJobAndJobScm(String jobProp, Map<String, String> jobAndJobPropPkRel) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String jobSelectProps = "id, jobscm, highjoblevel.joblevelseq, highjoblevel.joblevelscm, lowjoblevel.joblevelseq, lowjoblevel.joblevelscm, highjobgrade.jobgradeseq, highjobgrade.jobgradescm, lowjobgrade.jobgradeseq, lowjobgrade.jobgradescm ";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_job");
        QFilter jobFilter = new QFilter("id", "in", jobAndJobPropPkRel.keySet().stream().toArray(Object[]::new));
        DynamicObject[] jobDyobjs = serviceHelper.query(jobSelectProps, new QFilter[]{jobFilter});
        HashMap<String, DynamicObject> jobDyobjRel = new HashMap<String, DynamicObject>(jobDyobjs.length);
        for (DynamicObject jobDyobj : jobDyobjs) {
            jobDyobjRel.put(jobDyobj.getString("id"), jobDyobj);
        }
        serviceHelper = new HRBaseServiceHelper("hbjm_" + jobProp);
        QFilter jobPropFilter = new QFilter("id", "in", jobAndJobPropPkRel.values().stream().toArray(Object[]::new));
        String jobPropSelectProps = jobProp + "scm.id, " + jobProp + "seq";
        DynamicObject[] jobPropDyobjs = serviceHelper.query(jobPropSelectProps, new QFilter[]{jobPropFilter});
        HashMap<String, DynamicObject> jobPropDyobjRel = new HashMap<String, DynamicObject>(jobPropDyobjs.length);
        for (DynamicObject jobPropDyobj : jobPropDyobjs) {
            jobPropDyobjRel.put(jobPropDyobj.getString("id"), jobPropDyobj);
        }
        this.validateJobPropWhitinJobAndJobScm(jobProp, jobAndJobPropPkRel, errors, jobDyobjRel, jobPropDyobjRel);
        return errors;
    }

    private void validateJobPropWhitinJobAndJobScm(String jobProp, Map<String, String> jobAndJobPropPkRel, Map<String, String> errors, Map<String, DynamicObject> jobDyobjRel, Map<String, DynamicObject> jobPropDyobjRel) {
        jobAndJobPropPkRel.forEach((jobId, jobPropId) -> {
            DynamicObject jobDyobj = (DynamicObject)jobDyobjRel.get(jobId);
            DynamicObject highJobPropDyobj = jobDyobj.getDynamicObject("high" + jobProp);
            DynamicObject lowJobPropDyobj = jobDyobj.getDynamicObject("low" + jobProp);
            DynamicObject jobPropDyobj = (DynamicObject)jobPropDyobjRel.get(jobPropId);
            String jobPropDisplayName = jobPropDyobj.getDataEntityType().getDisplayName().getLocaleValue();
            if (null == highJobPropDyobj && null == lowJobPropDyobj) {
                errors.put((String)jobId, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5%1$s\u6ca1\u6709\u5bf9\u5e94\u7684%2$s\u8303\u56f4\uff0c \u8bf7\u53bb\u9664%3$s\u3002", (String)"HBJMService_0", (String)HRMP_HBJM_MSERVICE, (Object[])new Object[0]), jobPropDisplayName, jobPropDisplayName, jobPropDisplayName));
            } else {
                String jobPropScmId = null;
                Integer highPropSeq = Integer.MAX_VALUE;
                Integer lowPropSeq = Integer.MIN_VALUE;
                if (null != highJobPropDyobj) {
                    jobPropScmId = highJobPropDyobj.getString(jobProp + SCM_ID);
                    highPropSeq = highJobPropDyobj.getInt(jobProp + "seq");
                }
                if (null != lowJobPropDyobj) {
                    jobPropScmId = lowJobPropDyobj.getString(jobProp + SCM_ID);
                    lowPropSeq = lowJobPropDyobj.getInt(jobProp + "seq");
                }
                Integer jobPropSeq = jobPropDyobj.getInt(jobProp + "seq");
                if (!HRStringUtils.equals((String)jobPropDyobj.getString(jobProp + SCM_ID), (String)jobPropScmId)) {
                    errors.put((String)jobId, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5%1$s\u4e0e\u804c\u4f4d\u5bf9\u5e94\u7684%2$s\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c \u8bf7\u4fee\u6539\u3002", (String)"HBJMService_1", (String)HRMP_HBJM_MSERVICE, (Object[])new Object[0]), jobPropDisplayName, jobPropDisplayName));
                } else if (jobPropSeq > highPropSeq || jobPropSeq < lowPropSeq) {
                    errors.put((String)jobId, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5%1$s\u4e0d\u5728\u804c\u4f4d\u6240\u89c4\u5b9a\u7684%2$s\u8303\u56f4\u5185\uff0c \u8bf7\u4fee\u6539\u3002", (String)"HBJMService_2", (String)HRMP_HBJM_MSERVICE, (Object[])new Object[0]), jobPropDisplayName, jobPropDisplayName));
                }
            }
        });
    }

    public DynamicObject[] getJobScmByIds(List<Long> jobScmIds) {
        return JobScmRepository.getInstance().queryJobScmByIds(jobScmIds);
    }

    public DynamicObject[] getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds(List<Long> jobScmIds, List<Long> jobFamilyIds) {
        return JobFamilyScmRepository.getInstance().getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds(jobScmIds, jobFamilyIds);
    }

    public DynamicObject[] getJobByIds(List<Long> jobIds) {
        if (ObjectUtils.isEmpty(jobIds)) {
            return null;
        }
        return JobRepository.getInstance().loadJobData(jobIds);
    }

    public DynamicObject[] getJobByBoIds(List<Long> jobIds) {
        if (ObjectUtils.isEmpty(jobIds)) {
            return null;
        }
        return JobRepository.getInstance().loadJobDataByBoid(jobIds);
    }

    public Map<String, Object> getJobAndEvevtInfoByBoIds(List<Long> jobIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ObjectUtils.isEmpty(jobIds)) {
            return null;
        }
        Object[] jobs = JobRepository.getInstance().loadUnEnablingJobDataByBoid(jobIds);
        result.put("data", jobs);
        if (!ObjectUtils.isEmpty((Object[])jobs)) {
            List fvid = Arrays.stream(jobs).map(data -> data.getLong("id")).collect(Collectors.toList());
            HRBaseServiceHelper serviceHelper_his = new HRBaseServiceHelper("hbjm_jobhisevent");
            DynamicObject[] hisEvent = serviceHelper_his.loadDynamicObjectArray(new QFilter[]{new QFilter("vid", "in", fvid)});
            result.put("hisEvent", hisEvent);
            List fboid = Arrays.stream(jobs).map(data -> data.getLong("boid")).collect(Collectors.toList());
            HRBaseServiceHelper serviceHelper_biz = new HRBaseServiceHelper("hbjm_jobbizevent");
            Object[] bizEvent = serviceHelper_biz.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", fboid)});
            result.put("bizEvent", bizEvent);
            if (!ObjectUtils.isEmpty((Object[])bizEvent)) {
                List eventIds = Arrays.stream(bizEvent).map(data -> data.getLong("event")).collect(Collectors.toList());
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobevent");
                DynamicObject[] event = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", eventIds)});
                result.put("event", event);
            }
        }
        return result;
    }

    public DynamicObject[] getAllJobInfo() {
        QFilter qFilter = new QFilter("enable", "in", (Object)new String[]{"1", "0"});
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return JobRepository.getInstance().queryOriginalArray(qFilter);
    }

    public DynamicObject[] getJobInfoByOrgIds(List<Long> orgIdList) {
        QFilter permFilter = HBJMService.getBaseDataFilter("hbjm_jobhr", orgIdList);
        permFilter.and(new QFilter("enable", "in", (Object)new String[]{"1", "0"}));
        permFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return JobRepository.getInstance().queryOriginalArray(permFilter);
    }

    public static QFilter getBaseDataFilter(String entityName, List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return new QFilter("1", "!=", (Object)1);
        }
        if (orgIdList.size() == 1) {
            return BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgIdList.get(0));
        }
        return BaseDataServiceHelper.getBaseDataFilter((String)entityName, orgIdList, (boolean)true);
    }

    public List<Long> getJobIdsByUseorgIdList(List<Long> useorgIdList) {
        DynamicObject[] jobs;
        QFilter permFilter = PermOrgQFilterUtil.assembleFilterByOr((String)"hbjm_jobhr", useorgIdList);
        if (permFilter == null) {
            permFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
            permFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        if ((jobs = JobRepository.getInstance().getJobIdByPermFilter(permFilter)).length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(jobs).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }
}

