/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobLevelOrGradeRepository;
import kd.hrmp.hbjm.mservice.helper.JobGradeAndLevelRangeBo;
import kd.hrmp.hbjm.mservice.helper.JobGradeServiceBo;
import kd.hrmp.hbjm.mservice.helper.JobLevelGradeInfoBo;
import kd.hrmp.hbjm.mservice.helper.JobLevelGradeScmBo;
import kd.hrmp.hbjm.mservice.helper.JobLevelServiceBo;
import kd.hrmp.hbjm.mservice.helper.JobRelationLevelGradeBo;

public class HBJMJobLevelGradeServiceHepler {
    public static void valideAndInitParamsByLevel(List<Map<String, Object>> levelScmIds, List<JobLevelServiceBo> results) {
        if (levelScmIds == null || levelScmIds.size() <= 0 || results == null || results.size() <= 0 || levelScmIds.size() != results.size()) {
            return;
        }
        for (int index = 0; index < levelScmIds.size(); ++index) {
            Map<String, Object> map = levelScmIds.get(index);
            JobLevelServiceBo bo = results.get(index);
            Object scmId = map.get("scmId");
            if (!(scmId instanceof Long) || (Long)scmId <= 0L) {
                bo.setSuccess(false);
                bo.setErrorMsg("scmId is invalide");
            } else {
                bo.setScmId((Long)scmId);
            }
            Object name = map.get("joblevelName");
            if (!(name instanceof String) || HRStringUtils.isEmpty((String)String.valueOf(name))) {
                bo.setSuccess(false);
                bo.setErrorMsg("joblevelName is invalide");
                continue;
            }
            bo.setJoblevelName(String.valueOf(name));
        }
    }

    public static void valideAndInitParamsByGrade(List<Map<String, Object>> gradeScmIds, List<JobGradeServiceBo> results) {
        if (gradeScmIds == null || gradeScmIds.size() <= 0 || results == null || results.size() <= 0 || gradeScmIds.size() != results.size()) {
            return;
        }
        for (int index = 0; index < gradeScmIds.size(); ++index) {
            Map<String, Object> map = gradeScmIds.get(index);
            JobGradeServiceBo bo = results.get(index);
            Object scmId = map.get("scmId");
            if (!(scmId instanceof Long) || (Long)scmId <= 0L) {
                bo.setSuccess(false);
                bo.setErrorMsg("scmId is invalide");
            } else {
                bo.setScmId((Long)scmId);
            }
            Object name = map.get("jobgradeName");
            if (!(name instanceof String) || HRStringUtils.isEmpty((String)String.valueOf(name))) {
                bo.setSuccess(false);
                bo.setErrorMsg("jobgradeName is invalide");
                continue;
            }
            bo.setJobgradeName(String.valueOf(name));
        }
    }

    public static void dealScmJobLevelAndGrade(List<JobRelationLevelGradeBo> results) {
        if (results == null || results.size() <= 0) {
            return;
        }
        ArrayList scmIds = new ArrayList(results.size());
        ArrayList familyIds = new ArrayList(results.size());
        ArrayList classIds = new ArrayList(results.size());
        results.forEach(result -> {
            DynamicObject jobscm = result.getJobScm();
            if (jobscm != null) {
                DynamicObject jobclass;
                scmIds.add(jobscm.getLong("id"));
                DynamicObject jobfamily = result.getJobFamily();
                if (jobfamily != null) {
                    familyIds.add(jobfamily.getLong("id"));
                }
                if ((jobclass = result.getJobClass()) != null) {
                    classIds.add(jobclass.getLong("id"));
                }
            }
        });
        results.forEach(result -> {
            HBJMJobLevelGradeServiceHepler.buildJobScmLevelAndGradeBo(result);
            HBJMJobLevelGradeServiceHepler.buildJobLevelAndGradeBo(result);
        });
        if (scmIds.size() > 0 && familyIds.size() > 0) {
            DynamicObject[] jobClassScms;
            DynamicObject[] jobFamilyScms = JobFamilyScmRepository.getInstance().queryJobFamilyScmFieldByScmIdsAndFamilyIds(scmIds, familyIds);
            if (jobFamilyScms != null && jobFamilyScms.length > 0) {
                Map<String, DynamicObject> familyMap = Arrays.stream(jobFamilyScms).collect(Collectors.toMap(data -> {
                    Long jobScmId = data.getLong("jobscm.id");
                    Long jobFamilyId = data.getLong("jobfamily.id");
                    return jobScmId + "" + jobFamilyId;
                }, v1 -> v1, (v1, v2) -> v2));
                results.forEach(result -> HBJMJobLevelGradeServiceHepler.buildJobFamilyScmLevelAndGradeBo(result, familyMap));
            }
            if (classIds != null && classIds.size() > 0 && (jobClassScms = JobClassScmRepository.getInstance().getJobClassScmDyobjsByJobScmIdsAndJobClassIds(scmIds, classIds)) != null && jobClassScms.length > 0) {
                Map<String, DynamicObject> classMap = Arrays.stream(jobClassScms).collect(Collectors.toMap(data -> {
                    Long jobScmId = data.getLong("jobscm.id");
                    Long jobClassId = data.getLong("jobclass.id");
                    return jobScmId + "" + jobClassId;
                }, v1 -> v1, (v1, v2) -> v2));
                results.forEach(result -> HBJMJobLevelGradeServiceHepler.buildJobClassScmLevelAndGradeBo(result, classMap));
            }
        }
        HBJMJobLevelGradeServiceHepler.buildAllGradeAndLevelObjectData(results);
    }

    private static void buildJobScmLevelAndGradeBo(JobRelationLevelGradeBo result) {
        DynamicObject jobscm = result.getJobScm();
        if (jobscm != null) {
            DynamicObject levelScm;
            DynamicObject gradeScm = jobscm.getDynamicObject("jobgradescm");
            if (gradeScm != null) {
                result.setJobScmJobGrade(HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(gradeScm));
            }
            if ((levelScm = jobscm.getDynamicObject("joblevelscm")) != null) {
                result.setJobScmJobLevel(HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(levelScm));
            }
        }
    }

    private static void buildJobFamilyScmLevelAndGradeBo(JobRelationLevelGradeBo result, Map<String, DynamicObject> familyMap) {
        DynamicObject jobscm = result.getJobScm();
        if (jobscm != null) {
            Long jobScmId = jobscm.getLong("id");
            DynamicObject jobfamily = result.getJobFamily();
            if (jobfamily != null) {
                Long jobFamilyId = jobfamily.getLong("id");
                DynamicObject familyScm = familyMap.get(jobScmId + "" + jobFamilyId);
                if (familyScm != null) {
                    DynamicObject levelScm;
                    DynamicObject gradeScm = familyScm.getDynamicObject("jobgradescm");
                    if (gradeScm != null) {
                        result.setJobFamilyJobGrade(HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(gradeScm));
                    }
                    if ((levelScm = familyScm.getDynamicObject("joblevelscm")) != null) {
                        result.setJobFamilyJobLevel(HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(levelScm));
                    }
                }
            }
        }
    }

    private static void buildJobClassScmLevelAndGradeBo(JobRelationLevelGradeBo result, Map<String, DynamicObject> classMap) {
        DynamicObject jobScm = result.getJobScm();
        if (jobScm != null) {
            Long jobScmId = jobScm.getLong("id");
            DynamicObject jobClass = result.getJobClass();
            if (jobClass != null) {
                Long jobClassId = jobClass.getLong("id");
                DynamicObject classScm = classMap.get(jobScmId + "" + jobClassId);
                if (classScm != null) {
                    DynamicObject jobLevelScm;
                    DynamicObject jobGradeScm;
                    DynamicObject gradeScmStart = classScm.getDynamicObject("lowjobgrade");
                    DynamicObject gradeScmEnd = classScm.getDynamicObject("highjobgrade");
                    if (gradeScmStart != null && gradeScmEnd != null && (jobGradeScm = gradeScmStart.getDynamicObject("jobgradescm")) != null) {
                        JobLevelGradeScmBo jobLevelGradeScmBoJobScm = HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(jobGradeScm);
                        jobLevelGradeScmBoJobScm.setStart(gradeScmStart.getInt("jobgradeseq"));
                        jobLevelGradeScmBoJobScm.setEnd(gradeScmEnd.getInt("jobgradeseq"));
                        result.setJobClassJobGrade(jobLevelGradeScmBoJobScm);
                    }
                    DynamicObject levelScmStart = classScm.getDynamicObject("lowjoblevel");
                    DynamicObject levelScmEnd = classScm.getDynamicObject("highjoblevel");
                    if (levelScmStart != null && levelScmEnd != null && (jobLevelScm = levelScmStart.getDynamicObject("joblevelscm")) != null) {
                        JobLevelGradeScmBo jobLevelGradeScmBoJobScm = HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(jobLevelScm);
                        jobLevelGradeScmBoJobScm.setStart(levelScmStart.getInt("joblevelseq"));
                        jobLevelGradeScmBoJobScm.setEnd(levelScmEnd.getInt("joblevelseq"));
                        result.setJobClassJobLevel(jobLevelGradeScmBoJobScm);
                    }
                }
            }
        }
    }

    private static void buildJobLevelAndGradeBo(JobRelationLevelGradeBo result) {
        DynamicObject job = result.getJob();
        if (job != null) {
            DynamicObject jobLevelScm;
            DynamicObject jobGradeScm;
            DynamicObject gradeScmStart = job.getDynamicObject("lowjobgrade");
            DynamicObject gradeScmEnd = job.getDynamicObject("highjobgrade");
            if (gradeScmStart != null && gradeScmEnd != null && (jobGradeScm = gradeScmStart.getDynamicObject("jobgradescm")) != null) {
                JobLevelGradeScmBo jobLevelGradeScmBoJobScm = HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(jobGradeScm);
                jobLevelGradeScmBoJobScm.setStart(gradeScmStart.getInt("jobgradeseq"));
                jobLevelGradeScmBoJobScm.setEnd(gradeScmEnd.getInt("jobgradeseq"));
                result.setJobJobGrade(jobLevelGradeScmBoJobScm);
            }
            DynamicObject levelScmStart = job.getDynamicObject("lowjoblevel");
            DynamicObject levelScmEnd = job.getDynamicObject("highjoblevel");
            if (levelScmStart != null && levelScmEnd != null && (jobLevelScm = levelScmStart.getDynamicObject("joblevelscm")) != null) {
                JobLevelGradeScmBo jobLevelGradeScmBoJobScm = HBJMJobLevelGradeServiceHepler.buildLevelAndGradeBo(jobLevelScm);
                jobLevelGradeScmBoJobScm.setStart(levelScmStart.getInt("joblevelseq"));
                jobLevelGradeScmBoJobScm.setEnd(levelScmEnd.getInt("joblevelseq"));
                result.setJobJobLevel(jobLevelGradeScmBoJobScm);
            }
        }
    }

    private static void buildAllGradeAndLevelObjectData(List<JobRelationLevelGradeBo> results) {
        if (results == null || results.size() <= 0) {
            return;
        }
        ArrayList gradeScmIds = new ArrayList(results.size() * 4);
        ArrayList levelScmIds = new ArrayList(results.size() * 4);
        results.forEach(result -> {
            JobLevelGradeScmBo jobFamilyJobLevel;
            JobLevelGradeScmBo jobScmJobLevel;
            JobLevelGradeScmBo jobJobLevel;
            JobLevelGradeScmBo jobFamilyJobGrade;
            JobLevelGradeScmBo jobScmJobGrade;
            JobLevelGradeScmBo jobJobGrade = result.getJobJobGrade();
            if (jobJobGrade != null && jobJobGrade.getId() > 0L) {
                gradeScmIds.add(jobJobGrade.getId());
            }
            if ((jobScmJobGrade = result.getJobScmJobGrade()) != null && jobScmJobGrade.getId() > 0L) {
                gradeScmIds.add(jobScmJobGrade.getId());
            }
            if ((jobFamilyJobGrade = result.getJobFamilyJobGrade()) != null && jobFamilyJobGrade.getId() > 0L) {
                gradeScmIds.add(jobFamilyJobGrade.getId());
            }
            if ((jobJobLevel = result.getJobJobLevel()) != null && jobJobLevel.getId() > 0L) {
                levelScmIds.add(jobJobLevel.getId());
            }
            if ((jobScmJobLevel = result.getJobScmJobLevel()) != null && jobScmJobLevel.getId() > 0L) {
                levelScmIds.add(jobScmJobLevel.getId());
            }
            if ((jobFamilyJobLevel = result.getJobFamilyJobLevel()) != null && jobFamilyJobLevel.getId() > 0L) {
                levelScmIds.add(jobFamilyJobLevel.getId());
            }
        });
        if (gradeScmIds.size() > 0) {
            DynamicObject[] allGradeDatas = JobLevelOrGradeRepository.getInstance().getGradeByScmIds(gradeScmIds);
            HBJMJobLevelGradeServiceHepler.buildAllGradeData(results, allGradeDatas);
        }
        if (levelScmIds.size() > 0) {
            DynamicObject[] allLevelDatas = JobLevelOrGradeRepository.getInstance().getLevelByScmIds(levelScmIds);
            HBJMJobLevelGradeServiceHepler.buildAllLevelData(results, allLevelDatas);
        }
    }

    public static void buildAllGradeData(List<JobRelationLevelGradeBo> results, DynamicObject[] allGradeDatas) {
        if (allGradeDatas != null && allGradeDatas.length > 0) {
            Map<Long, List<DynamicObject>> allGradeMap = Arrays.stream(allGradeDatas).sorted(Comparator.comparing(data -> data.getInt("jobgradeseq"))).collect(Collectors.groupingBy(data -> data.getLong("jobgradescm.id")));
            results.forEach(result -> {
                JobLevelGradeScmBo jobJobGrade;
                JobLevelGradeScmBo jobClassJobGrade;
                JobLevelGradeScmBo jobFamilyJobGrade;
                JobLevelGradeScmBo jobScmJobGrade = result.getJobScmJobGrade();
                if (jobScmJobGrade != null && jobScmJobGrade.getId() > 0L) {
                    jobScmJobGrade.setRanges((List)allGradeMap.get(jobScmJobGrade.getId()));
                }
                if ((jobFamilyJobGrade = result.getJobFamilyJobGrade()) != null && jobFamilyJobGrade.getId() > 0L) {
                    jobFamilyJobGrade.setRanges((List)allGradeMap.get(jobFamilyJobGrade.getId()));
                }
                if ((jobClassJobGrade = result.getJobClassJobGrade()) != null && jobClassJobGrade.getId() > 0L) {
                    List<DynamicObject> ranges = HBJMJobLevelGradeServiceHepler.filterRangeData(jobClassJobGrade, (List)allGradeMap.get(jobClassJobGrade.getId()), "jobgradeseq");
                    jobClassJobGrade.setRanges(ranges);
                }
                if ((jobJobGrade = result.getJobJobGrade()) != null && jobJobGrade.getId() > 0L) {
                    List<DynamicObject> ranges = HBJMJobLevelGradeServiceHepler.filterRangeData(jobJobGrade, (List)allGradeMap.get(jobJobGrade.getId()), "jobgradeseq");
                    jobJobGrade.setRanges(ranges);
                }
            });
        }
    }

    public static void buildAllLevelData(List<JobRelationLevelGradeBo> results, DynamicObject[] allLevelDatas) {
        if (allLevelDatas != null && allLevelDatas.length > 0) {
            Map<Long, List<DynamicObject>> allLevelMap = Arrays.stream(allLevelDatas).sorted(Comparator.comparing(data -> data.getInt("joblevelseq"))).collect(Collectors.groupingBy(data -> data.getLong("joblevelscm.id")));
            results.forEach(result -> {
                JobLevelGradeScmBo jobJobLevel;
                JobLevelGradeScmBo jobClassJobLevel;
                JobLevelGradeScmBo jobFamilyJobLevel;
                JobLevelGradeScmBo jobScmJobLevel = result.getJobScmJobLevel();
                if (jobScmJobLevel != null && jobScmJobLevel.getId() > 0L) {
                    jobScmJobLevel.setRanges((List)allLevelMap.get(jobScmJobLevel.getId()));
                }
                if ((jobFamilyJobLevel = result.getJobFamilyJobLevel()) != null && jobFamilyJobLevel.getId() > 0L) {
                    jobFamilyJobLevel.setRanges((List)allLevelMap.get(jobFamilyJobLevel.getId()));
                }
                if ((jobClassJobLevel = result.getJobClassJobLevel()) != null && jobClassJobLevel.getId() > 0L) {
                    List<DynamicObject> ranges = HBJMJobLevelGradeServiceHepler.filterRangeData(jobClassJobLevel, (List)allLevelMap.get(jobClassJobLevel.getId()), "joblevelseq");
                    jobClassJobLevel.setRanges(ranges);
                }
                if ((jobJobLevel = result.getJobJobLevel()) != null && jobJobLevel.getId() > 0L) {
                    List<DynamicObject> ranges = HBJMJobLevelGradeServiceHepler.filterRangeData(jobJobLevel, (List)allLevelMap.get(jobJobLevel.getId()), "joblevelseq");
                    jobJobLevel.setRanges(ranges);
                }
            });
        }
    }

    private static List<DynamicObject> filterRangeData(JobLevelGradeScmBo bo, List<DynamicObject> allDatas, String indexCol) {
        if (bo == null || allDatas == null || allDatas.size() <= 0 || HRStringUtils.isEmpty((String)indexCol)) {
            return null;
        }
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>(allDatas.size());
        int start = bo.getStart();
        int end = bo.getEnd();
        allDatas.stream().forEach(data -> {
            int index = data.getInt(indexCol);
            if (start < 0 || end < 0 || index >= start && index <= end) {
                results.add((DynamicObject)data);
            }
        });
        return results;
    }

    private static JobLevelGradeScmBo buildLevelAndGradeBo(DynamicObject gradeOrLevelScm) {
        JobLevelGradeScmBo jobLevelGradeScmBoJobScm = new JobLevelGradeScmBo();
        jobLevelGradeScmBoJobScm.setId(gradeOrLevelScm.getLong("id"));
        jobLevelGradeScmBoJobScm.setName(gradeOrLevelScm.getLocaleString("name"));
        jobLevelGradeScmBoJobScm.setNumber(gradeOrLevelScm.getString("number"));
        return jobLevelGradeScmBoJobScm;
    }

    public static void valideAndInitJobGradeAndLevelRange(List<Map<String, Long>> rangs, List<JobGradeAndLevelRangeBo> results) {
        if (rangs == null || rangs.size() <= 0 || results == null || results.size() <= 0 || rangs.size() != results.size()) {
            return;
        }
        for (int index = 0; index < rangs.size(); ++index) {
            Map<String, Long> rang = rangs.get(index);
            JobGradeAndLevelRangeBo bo = results.get(index);
            bo.setBusinessID(rang.get("businessID"));
            Long lowJobGrade = rang.get("lowjobgrade");
            Long highJobGrade = rang.get("highjobgrade");
            Long lowJobLevel = rang.get("lowjoblevel");
            Long highJobLevel = rang.get("highjoblevel");
            if (lowJobGrade != null && highJobGrade != null || lowJobGrade == null && highJobGrade == null || lowJobGrade == 0L && highJobGrade == 0L) {
                bo.setLowJobGrade(lowJobGrade);
                bo.setHighJobGrade(highJobGrade);
            } else {
                bo.setSuccess(false);
                bo.addErrorMsg("lowjobgrade or highjobgrade is error");
            }
            if (lowJobLevel != null && highJobLevel != null || lowJobLevel == null && highJobLevel == null || lowJobLevel == 0L && highJobLevel == 0L) {
                bo.setLowJobLevel(lowJobLevel);
                bo.setHighJobLevel(highJobLevel);
                continue;
            }
            bo.setSuccess(false);
            bo.addErrorMsg("lowjoblevel or highjoblevel is error");
        }
    }

    public static void valideLowAndHighGrade(DynamicObject[] infos, List<JobGradeAndLevelRangeBo> canDealSourceData) {
        if (infos != null && infos.length > 0) {
            Map<Long, DynamicObject> allMap = Arrays.stream(infos).collect(Collectors.toMap(data -> data.getLong("id"), v1 -> v1, (v1, v2) -> v2));
            canDealSourceData.forEach(result -> {
                Long lowjobgrade = result.getLowJobGrade();
                Long highjobgrade = result.getHighJobGrade();
                if (lowjobgrade != null && lowjobgrade != 0L) {
                    DynamicObject highJobGradeInfo;
                    DynamicObject lowJobGradeInfo = (DynamicObject)allMap.get(lowjobgrade);
                    if (lowJobGradeInfo == null) {
                        result.setSuccess(false);
                        result.addErrorMsg("can not find lowjobgrade data");
                    }
                    if ((highJobGradeInfo = (DynamicObject)allMap.get(highjobgrade)) == null) {
                        result.setSuccess(false);
                        result.addErrorMsg("can not find highjobgrade data");
                    }
                    if (lowJobGradeInfo != null && highJobGradeInfo != null) {
                        Long highgradeScmId;
                        Long lowgradeScmId = lowJobGradeInfo.getLong("jobgradescm.id");
                        if (lowgradeScmId.compareTo(highgradeScmId = Long.valueOf(highJobGradeInfo.getLong("jobgradescm.id"))) != 0) {
                            result.setSuccess(false);
                            result.addErrorMsg("lowjobgrade and highjobgrade is not under one gradescm");
                        } else {
                            int jobgradeEnd;
                            int jobgradeStart = lowJobGradeInfo.getInt("jobgradeseq");
                            if (jobgradeStart > (jobgradeEnd = highJobGradeInfo.getInt("jobgradeseq"))) {
                                result.setSuccess(false);
                                result.addErrorMsg("lowjobgrade index can not be larger than highjobgrade index");
                            } else {
                                DynamicObject gradeScm = lowJobGradeInfo.getDynamicObject("jobgradescm");
                                if (gradeScm == null) {
                                    result.setSuccess(false);
                                    result.addErrorMsg("jobgradescm is null");
                                } else {
                                    JobLevelGradeScmBo jobLevelGradeScmBo = new JobLevelGradeScmBo();
                                    jobLevelGradeScmBo.setId(gradeScm.getLong("id"));
                                    jobLevelGradeScmBo.setNumber(gradeScm.getString("number"));
                                    jobLevelGradeScmBo.setName(gradeScm.getLocaleString("name"));
                                    jobLevelGradeScmBo.setStart(lowJobGradeInfo.getInt("jobgradeseq"));
                                    jobLevelGradeScmBo.setEnd(highJobGradeInfo.getInt("jobgradeseq"));
                                    result.setJobGradeRang(jobLevelGradeScmBo);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public static void valideLowAndHighLevel(DynamicObject[] infos, List<JobGradeAndLevelRangeBo> canDealSourceData) {
        if (infos != null && infos.length > 0) {
            Map<Long, DynamicObject> allMap = Arrays.stream(infos).collect(Collectors.toMap(data -> data.getLong("id"), v1 -> v1, (v1, v2) -> v2));
            canDealSourceData.forEach(result -> {
                Long lowJobLevel = result.getLowJobLevel();
                Long highJobLevel = result.getHighJobLevel();
                if (lowJobLevel != null && lowJobLevel != 0L) {
                    DynamicObject highJobLevelInfo;
                    DynamicObject lowJobLevelInfo = (DynamicObject)allMap.get(lowJobLevel);
                    if (lowJobLevelInfo == null) {
                        result.setSuccess(false);
                        result.addErrorMsg("can not find lowjoblevel data");
                    }
                    if ((highJobLevelInfo = (DynamicObject)allMap.get(highJobLevel)) == null) {
                        result.setSuccess(false);
                        result.addErrorMsg("can not find highjoblevel data");
                    }
                    if (lowJobLevelInfo != null && highJobLevelInfo != null) {
                        Long highlevelScmId;
                        Long lowlevelScmId = lowJobLevelInfo.getLong("joblevelscm.id");
                        if (lowlevelScmId.compareTo(highlevelScmId = Long.valueOf(highJobLevelInfo.getLong("joblevelscm.id"))) != 0) {
                            result.setSuccess(false);
                            result.addErrorMsg("lowjoblevel and highjoblevel is not under one levelscm");
                        } else {
                            int joblevelEnd;
                            int joblevelStart = lowJobLevelInfo.getInt("joblevelseq");
                            if (joblevelStart > (joblevelEnd = highJobLevelInfo.getInt("joblevelseq"))) {
                                result.setSuccess(false);
                                result.addErrorMsg("lowjoblevel index can not be larger than highjoblevel index");
                            } else {
                                DynamicObject levelScm = lowJobLevelInfo.getDynamicObject("joblevelscm");
                                if (levelScm == null) {
                                    result.setSuccess(false);
                                    result.addErrorMsg("joblevelscm is null");
                                } else {
                                    JobLevelGradeScmBo jobLevelGradeScmBo = new JobLevelGradeScmBo();
                                    jobLevelGradeScmBo.setId(levelScm.getLong("id"));
                                    jobLevelGradeScmBo.setNumber(levelScm.getString("number"));
                                    jobLevelGradeScmBo.setName(levelScm.getLocaleString("name"));
                                    jobLevelGradeScmBo.setStart(lowJobLevelInfo.getInt("joblevelseq"));
                                    jobLevelGradeScmBo.setEnd(highJobLevelInfo.getInt("joblevelseq"));
                                    result.setJobLevelRang(jobLevelGradeScmBo);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public static void buildGradeRangs(DynamicObject[] gradeInfos, List<JobGradeAndLevelRangeBo> canDealSourceData) {
        if (gradeInfos != null && gradeInfos.length > 0) {
            Map<Long, List<DynamicObject>> allLevelMap = Arrays.stream(gradeInfos).sorted(Comparator.comparing(data -> data.getInt("jobgradeseq"))).collect(Collectors.groupingBy(data -> data.getLong("jobgradescm.id")));
            canDealSourceData.forEach(result -> {
                JobLevelGradeScmBo jobLevelGradeScmBo = result.getJobGradeRang();
                if (jobLevelGradeScmBo != null) {
                    jobLevelGradeScmBo.setRanges(HBJMJobLevelGradeServiceHepler.filterRangeData(jobLevelGradeScmBo, (List)allLevelMap.get(jobLevelGradeScmBo.getId()), "jobgradeseq"));
                }
            });
        }
    }

    public static void buildLevelRangs(DynamicObject[] levelInfos, List<JobGradeAndLevelRangeBo> canDealSourceData) {
        if (levelInfos != null && levelInfos.length > 0) {
            Map<Long, List<DynamicObject>> allLevelMap = Arrays.stream(levelInfos).sorted(Comparator.comparing(data -> data.getInt("joblevelseq"))).collect(Collectors.groupingBy(data -> data.getLong("joblevelscm.id")));
            canDealSourceData.forEach(result -> {
                JobLevelGradeScmBo jobLevelGradeScmBo = result.getJobLevelRang();
                if (jobLevelGradeScmBo != null) {
                    jobLevelGradeScmBo.setRanges(HBJMJobLevelGradeServiceHepler.filterRangeData(jobLevelGradeScmBo, (List)allLevelMap.get(jobLevelGradeScmBo.getId()), "joblevelseq"));
                }
            });
        }
    }

    public static void valideAndInitParamsByGradeInfo(List<Map<String, Object>> infos, List<JobLevelGradeInfoBo> results) {
        if (infos == null || infos.size() <= 0 || results == null || results.size() <= 0 || infos.size() != results.size()) {
            return;
        }
        for (int index = 0; index < infos.size(); ++index) {
            String scmName;
            Map<String, Object> map = infos.get(index);
            JobLevelGradeInfoBo bo = results.get(index);
            String scmNumber = map.get("scmNumber") == null ? null : String.valueOf(map.get("scmNumber"));
            String string = scmName = map.get("scmName") == null ? null : String.valueOf(map.get("scmName"));
            if (HRStringUtils.isEmpty((String)scmNumber) && HRStringUtils.isEmpty((String)scmName)) {
                String msg = ResManager.loadKDString((String)"\u53c2\u6570\u201c\u65b9\u6848\u540d\u79f0\u201d\u548c\u201c\u65b9\u6848\u7f16\u7801\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"HBJMJobLevelGradeServiceHepler_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                bo.setSuccess(false);
                bo.setErrorMsg(msg);
            } else {
                bo.setScmNumber(scmNumber);
                bo.setScmName(scmName);
            }
            Object levelGradeNameList = map.get("name");
            if (levelGradeNameList != null && !(levelGradeNameList instanceof List)) {
                String msg = ResManager.loadKDString((String)"\u53c2\u6570\u201c\u540d\u79f0\u201d\u5e94\u8be5\u4e3aList\u96c6\u5408\u3002", (String)"HBJMJobLevelGradeServiceHepler_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                bo.setSuccess(false);
                bo.setErrorMsg(msg);
                continue;
            }
            bo.setName((List)levelGradeNameList);
        }
    }
}

