/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.mservice.helper;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;

public class MServiceBo
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(MServiceBo.class);
    private static final long serialVersionUID = 1L;
    private String errorMsg;
    private int errorCode;
    private boolean success = true;

    public static <T extends MServiceBo> List<Map<String, Object>> toMap(List<T> list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        MServiceBo singleData = (MServiceBo)list.get(0);
        Map<String, Method> fields = null;
        try {
            Class<?> aClass = singleData.getClass();
            fields = MServiceBo.getObjectReadFields(aClass);
        }
        catch (Exception exception) {
            LOGGER.info("kd.hrmp.hbjm.mservice.helper.MServiceBo.getObjectReadFields error ", (Object)exception.getMessage());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        for (MServiceBo source : list) {
            Map<String, Object> info = MServiceBo.toMap(source, fields);
            result.add(info);
        }
        return result;
    }

    public static <T extends MServiceBo> Map<String, Object> toMap(T info) {
        if (info == null) {
            return null;
        }
        Map<String, Method> fields = null;
        try {
            Class<?> aClass = info.getClass();
            fields = MServiceBo.getObjectReadFields(aClass);
        }
        catch (Exception exception) {
            LOGGER.info("kd.hrmp.hbjm.mservice.helper.MServiceBo.getObjectReadFields error ", (Object)exception.getMessage());
        }
        Map<String, Object> result = MServiceBo.toMap(info, fields);
        return result;
    }

    private static <T extends MServiceBo> Map<String, Object> toMap(T data, Map<String, Method> fields) {
        if (data == null) {
            return null;
        }
        HashMap<String, Object> result = null;
        try {
            Class<?> aClass = data.getClass();
            if (fields != null && fields.size() > 0) {
                result = new HashMap<String, Object>(fields.size());
                for (Map.Entry<String, Method> entry : fields.entrySet()) {
                    Method method = entry.getValue();
                    result.put(entry.getKey(), method.invoke(data, new Object[0]));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.info("kd.hrmp.hbjm.mservice.helper.MServiceBo.toMap error ", (Object)exception.getMessage());
        }
        return result;
    }

    public static Map<String, Method> getObjectReadFields(Class<?> classInfo) throws Exception {
        PropertyDescriptor prop = null;
        HashMap<String, Method> result = new HashMap<String, Method>(16);
        for (Class<?> aClass = Class.forName(classInfo.getCanonicalName()); aClass != null; aClass = aClass.getSuperclass()) {
            Field[] fields = aClass.getDeclaredFields();
            if (fields == null || fields.length <= 0) continue;
            for (Field field : fields) {
                String fieldName = field.getName();
                if (HRStringUtils.isEmpty((String)fieldName) || HRStringUtils.equals((String)fieldName, (String)"serialVersionUID") || HRStringUtils.equals((String)fieldName, (String)"LOGGER")) continue;
                try {
                    prop = new PropertyDescriptor(field.getName(), aClass);
                    Method readMethod = prop.getReadMethod();
                    if (readMethod == null) continue;
                    result.put(field.getName(), prop.getReadMethod());
                }
                catch (Exception exception) {
                    LOGGER.info("kd.hrmp.hbjm.mservice.helper.MServiceBo.getObjectReadFields error ", (Object)exception.getMessage());
                }
            }
        }
        return result;
    }

    public static <T> List getEmptyBo(Class<T> aclass, int size) {
        ArrayList<T> datas = new ArrayList<T>(size);
        for (int index = 0; index < size; ++index) {
            try {
                datas.add(aclass.newInstance());
                continue;
            }
            catch (InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Throwable)e);
            }
        }
        return datas;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void addErrorMsg(String errorMsg) {
        this.errorMsg = HRStringUtils.isEmpty((String)this.errorMsg) ? errorMsg : this.errorMsg + "\n" + errorMsg;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

