/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassTreeQueryRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqScmRepository;
import kd.hrmp.hbjm.business.jobclass.JobClassTreeService;
import kd.hrmp.hbjm.common.constants.JobClassConstants;
import kd.hrmp.hbjm.common.util.JobClassTreeUtil;
import kd.hrmp.hbjm.formplugin.web.jobclass.JobClassTreeListPluginPlus;

public class JobClassF7TreeListPlugin
extends JobClassTreeListPluginPlus {
    private static final Log logger = LogFactory.getLog(JobClassF7TreeListPlugin.class);

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode.getChildren() == null || rootNode.getChildren().size() == 0) {
            return;
        }
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (HRStringUtils.equals((String)currentNodeId, (String)"01010") && (currentNodeId = (String)this.getView().getFormShowParameter().getCustomParam("currentNodeId")) != null) {
            TreeNode currentTreeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 10);
            IPageCache iPageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String lock = iPageCache.get("lock");
            Integer lockIndex = null;
            if (lock != null) {
                lockIndex = Integer.parseInt(lock) + 1;
                iPageCache.put("lock", String.valueOf(lockIndex));
            } else {
                iPageCache.put("lock", "1");
            }
            lock = iPageCache.get("lock");
            if ("1".equals(lock)) {
                this.getTreeListView().getTreeView().focusNode(currentTreeNode);
                this.getTreeListView().getTreeView().treeNodeClick(currentTreeNode.getParentid(), currentNodeId);
                JobClassTreeUtil.setNodeExpend((TreeNode)currentTreeNode, (TreeNode)rootNode);
            }
        }
    }

    @Override
    public void refreshNode(RefreshNodeEvent evt) {
        super.refreshNode(evt);
    }

    @Override
    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        String nodeId = (String)evt.getNodeId();
        QFilter qFilter = JobClassTreeService.builJobClassQFilter((String)nodeId);
        evt.addQFilter(qFilter);
        evt.setCancel(true);
    }

    public void setFilter(SetFilterEvent evt) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("id", "!=", (Object)JobClassConstants.JOB_CLASS_DDL);
        qFilter.and("id", "!=", (Object)JobClassConstants.JOB_CLASS_DD);
        list.add(qFilter);
        list.add(this.buildFamilyFilterFromParent());
        list.add(this.buildScmFilterFromParent());
        evt.setCustomQFilters(list);
    }

    @Override
    protected DynamicObject[] getBuildJobClassData() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] jobClassDys = JobClassTreeQueryRepository.getInstance().queryJobClass(userId, super.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.buildFamilyFilterFromParent(), this.buildScmFilterFromParent(), this.getOrderCondition());
        return jobClassDys;
    }

    private QFilter buildFamilyFilterFromParent() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long selectedJobFamilyid = (Long)formShowParameter.getCustomParam("selectedJobFamilyId");
        QFilter filter = null;
        if (selectedJobFamilyid != null && selectedJobFamilyid > 0L) {
            filter = new QFilter("jobfamily.id", "=", (Object)selectedJobFamilyid);
        }
        return filter;
    }

    private QFilter buildFamilyFilterToFamilyFromParent() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long selectedJobFamilyid = (Long)formShowParameter.getCustomParam("selectedJobFamilyId");
        QFilter filter = null;
        if (selectedJobFamilyid != null && selectedJobFamilyid > 0L) {
            filter = new QFilter("id", "=", (Object)selectedJobFamilyid);
        }
        return filter;
    }

    private QFilter buildSeqFilterToSeqFromParent() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long selectedJobSeqId = (Long)formShowParameter.getCustomParam("selectedJobSeqId");
        QFilter filter = null;
        if (selectedJobSeqId != null && selectedJobSeqId > 0L) {
            filter = new QFilter("id", "=", (Object)selectedJobSeqId);
        }
        return filter;
    }

    private QFilter buildScmFilterFromParent() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long selectedScmid = (Long)formShowParameter.getCustomParam("selectedScmId");
        QFilter filter = null;
        if (selectedScmid != null && selectedScmid > 0L) {
            filter = this.putScmClassFilterToCache(selectedScmid);
        }
        return filter;
    }

    private QFilter putScmClassFilterToCache(Long selectedScmid) {
        String info = this.getPageCache().get("scmClassFilter");
        QFilter filter = null;
        if (ObjectUtils.isEmpty((Object)info)) {
            DynamicObject[] dynamicObject = JobSeqScmRepository.getJobClassByScmId((Long)selectedScmid);
            List jobclassUnderScm = Arrays.stream(dynamicObject).map(jobclass -> jobclass.get("jobclass.id")).collect(Collectors.toList());
            filter = new QFilter("id", "in", jobclassUnderScm);
            this.getPageCache().put("scmClassFilter", SerializationUtils.serializeToBase64((Object)filter));
        } else {
            filter = (QFilter)SerializationUtils.deSerializeFromBase64((String)info);
        }
        return filter;
    }

    private QFilter buildScmFilterToFamilyFromParent() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long selectedScmid = (Long)formShowParameter.getCustomParam("selectedScmId");
        QFilter filter = null;
        if (selectedScmid != null && selectedScmid > 0L) {
            DynamicObject[] dynamicObject = JobSeqScmRepository.getJobFamilyByScmId((Long)selectedScmid);
            List jobFamilyUnderScm = Arrays.stream(dynamicObject).map(jobclass -> jobclass.get("jobfamily.id")).collect(Collectors.toList());
            filter = new QFilter("id", "in", jobFamilyUnderScm);
        }
        return filter;
    }

    private QFilter buildScmFilterToSeqFromParent() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long selectedScmid = (Long)formShowParameter.getCustomParam("selectedScmId");
        QFilter filter = null;
        if (selectedScmid != null && selectedScmid > 0L) {
            DynamicObject[] dynamicObject = JobSeqScmRepository.getJobSeqByScmId((Long)selectedScmid);
            List jobSeqUnderScm = Arrays.stream(dynamicObject).map(jobclass -> jobclass.get("jobseq.id")).collect(Collectors.toList());
            filter = new QFilter("id", "in", jobSeqUnderScm);
        }
        return filter;
    }

    @Override
    protected DynamicObject[] getBuildJobfamilyData() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] jobfamilys = JobClassTreeQueryRepository.getInstance().queryJobFamily(userId, this.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.buildFamilyFilterToFamilyFromParent(), this.buildScmFilterToFamilyFromParent(), this.getOrderCondition());
        return jobfamilys;
    }

    @Override
    protected DynamicObject[] getBuildJobSeqData() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] jobSeqs = JobClassTreeQueryRepository.getInstance().queryJobSeq(userId, this.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.buildSeqFilterToSeqFromParent(), this.buildScmFilterToSeqFromParent(), this.getOrderCondition());
        return jobSeqs;
    }
}

