/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.impt;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;

public class JobBaseImportPlugin
extends HisBatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(JobBaseImportPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        for (ImportBillData billdata : billdatas) {
            JSONObject data = billdata.getData();
            this.handleGradeAndLevelField(data, "lowjobgrade");
            this.handleGradeAndLevelField(data, "highjobgrade");
            this.handleGradeAndLevelField(data, "lowjoblevel");
            this.handleGradeAndLevelField(data, "highjoblevel");
        }
    }

    private void handleGradeAndLevelField(JSONObject data, String field) {
        JSONObject importField = data.getJSONObject(field);
        if (importField == null) {
            return;
        }
        String importprop = importField.getString("importprop");
        if (!HRStringUtils.equals((String)importprop, (String)"name")) {
            return;
        }
        String value = importField.getString(importprop);
        data.remove((Object)field);
        data.put(field + "name", (Object)value);
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.FALSE, new String[]{"radiofield2"});
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }
}

